/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcConnection;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import com.google.common.base.MoreObjects;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GrpcChannel
extends Channel {
    private final GrpcConnection mConnection;
    private Channel mTrackedChannel;
    private ChannelResponseTracker mResponseTracker;
    private AuthenticatedChannelClientDriver mAuthDriver;
    private boolean mChannelReleased = false;

    public GrpcChannel(GrpcConnection connection, @Nullable AuthenticatedChannelClientDriver authDriver) {
        this.mConnection = connection;
        this.mAuthDriver = authDriver;
        this.mResponseTracker = new ChannelResponseTracker();
        this.mConnection.interceptChannel(this.mResponseTracker);
        this.mTrackedChannel = this.mConnection.getChannel();
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mTrackedChannel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.mTrackedChannel.authority();
    }

    public void intercept(ClientInterceptor interceptor) {
        this.mTrackedChannel = ClientInterceptors.intercept((Channel)this.mTrackedChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    public synchronized void shutdown() {
        if (this.mAuthDriver != null) {
            this.mAuthDriver.close();
            this.mAuthDriver = null;
        }
        if (!this.mChannelReleased) {
            try {
                this.mConnection.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to release the connection.", e);
            }
            this.mChannelReleased = true;
        }
    }

    public boolean isShutdown() {
        return this.mChannelReleased;
    }

    public boolean isHealthy() {
        boolean healthy = this.mResponseTracker.isChannelHealthy();
        if (this.mAuthDriver != null) {
            healthy &= this.mAuthDriver.isAuthenticated();
        }
        return healthy;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("ChannelKey", (Object)this.mConnection.getChannelKey()).add("ChannelHealthy", this.isHealthy()).add("ChannelReleased", this.mChannelReleased).toString();
    }

    public String toStringShort() {
        return this.mConnection.getChannelKey().toStringShort();
    }

    private class ChannelResponseTracker
    implements ClientInterceptor {
        private boolean mChannelHealthy = true;

        private ChannelResponseTracker() {
        }

        public boolean isChannelHealthy() {
            return this.mChannelHealthy;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                ChannelResponseTracker.this.mChannelHealthy = false;
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

