/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcConnectionKey;
import alluxio.grpc.GrpcConnectionPool;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import java.util.Objects;

public class GrpcConnection
implements AutoCloseable {
    private GrpcConnectionKey mKey;
    private ManagedChannel mManagedChannel;
    private Channel mChannel;
    private AlluxioConfiguration mConfiguration;

    public GrpcConnection(GrpcConnectionKey key, ManagedChannel managedChannel, AlluxioConfiguration conf) {
        this.mConfiguration = conf;
        this.mKey = key;
        this.mManagedChannel = managedChannel;
        this.mChannel = this.mManagedChannel;
    }

    public GrpcChannelKey getChannelKey() {
        return this.mKey.getChannelKey();
    }

    public Channel getChannel() {
        return this.mChannel;
    }

    public void interceptChannel(ClientInterceptor interceptor) {
        this.mChannel = ClientInterceptors.intercept((Channel)this.mChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    public AlluxioConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GrpcConnection)) {
            return false;
        }
        GrpcConnection otherConnection = (GrpcConnection)other;
        return Objects.equals(this.mKey, otherConnection.mKey) && Objects.equals(this.mManagedChannel, otherConnection.mManagedChannel) && Objects.equals(this.mChannel, ((GrpcConnection)other).mChannel);
    }

    public int hashCode() {
        return Objects.hash(this.mKey, this.mManagedChannel, this.mChannel);
    }

    @Override
    public void close() throws Exception {
        GrpcConnectionPool.INSTANCE.releaseConnection(this.mKey, this.mConfiguration);
    }
}

