/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.util.io.BufferUtils;
import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class NioDataBuffer
implements DataBuffer {
    private final ByteBuffer mBuffer;
    private final long mLength;

    public NioDataBuffer(ByteBuffer buffer, long length) {
        this.mBuffer = (ByteBuffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        return Unpooled.wrappedBuffer((ByteBuffer)this.mBuffer);
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        ByteBuffer buffer = this.mBuffer.asReadOnlyBuffer();
        buffer.position(0);
        return buffer;
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.mBuffer.get(dst, dstIndex, length);
    }

    @Override
    public void readBytes(OutputStream outputStream, int length) throws IOException {
        Unpooled.wrappedBuffer((ByteBuffer)this.mBuffer).readBytes(outputStream, length).release();
    }

    @Override
    public void readBytes(ByteBuffer outputBuf) {
        outputBuf.put(this.mBuffer);
    }

    @Override
    public int readableBytes() {
        return this.mBuffer.remaining();
    }

    @Override
    public void release() {
        if (this.mBuffer.isDirect()) {
            BufferUtils.cleanDirectBuffer(this.mBuffer);
        }
    }
}

