/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.grpc.BlockStoreLocationProto;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockStoreLocation {
    public static final String ANY_TIER = "";
    public static final int ANY_DIR = -1;
    public static final String ANY_MEDIUM = "";
    private final String mTierAlias;
    private final int mDirIndex;
    private final String mMediumType;

    public static BlockStoreLocation anyTier() {
        return new BlockStoreLocation("", -1, "");
    }

    public static BlockStoreLocation anyDirInTier(String tierAlias) {
        return new BlockStoreLocation(tierAlias, -1, "");
    }

    public static BlockStoreLocation anyDirInTierWithMedium(String mediumType) {
        return new BlockStoreLocation("", -1, mediumType);
    }

    public BlockStoreLocation(String tierAlias, int dirIndex) {
        this.mTierAlias = tierAlias;
        this.mDirIndex = dirIndex;
        this.mMediumType = "";
    }

    public BlockStoreLocation(String tierAlias, int dirIndex, String mediumType) {
        this.mTierAlias = tierAlias;
        this.mDirIndex = dirIndex;
        this.mMediumType = mediumType;
    }

    public String tierAlias() {
        return this.mTierAlias;
    }

    public int dir() {
        return this.mDirIndex;
    }

    public String mediumType() {
        return this.mMediumType;
    }

    public boolean belongsTo(BlockStoreLocation location) {
        boolean tierInRange = this.tierAlias().equals(location.tierAlias()) || location.tierAlias().equals("");
        boolean dirInRange = this.dir() == location.dir() || location.dir() == -1;
        boolean mediumTypeInRange = this.mediumType().equals(location.mediumType()) || location.mediumType().equals("");
        return tierInRange && dirInRange && mediumTypeInRange;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.mDirIndex == -1) {
            result.append("any dir");
        } else {
            result.append("dir ").append(this.mDirIndex);
        }
        if (this.mTierAlias.equals("")) {
            result.append(", any tier");
        } else {
            result.append(", tierAlias ").append(this.mTierAlias);
        }
        if (this.mMediumType.equals("")) {
            result.append(", any medium type");
        } else {
            result.append(", mediumType ").append(this.mMediumType);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockStoreLocation)) {
            return false;
        }
        BlockStoreLocation that = (BlockStoreLocation)o;
        return this.mTierAlias.equals(that.mTierAlias) && this.mDirIndex == that.mDirIndex && this.mMediumType.equals(that.mMediumType);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mTierAlias, this.mDirIndex, this.mMediumType});
    }

    public BlockStoreLocationProto toProto() {
        return BlockStoreLocationProto.newBuilder().setTierAlias(this.tierAlias()).setMediumType(this.mediumType()).build();
    }
}

