/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public interface Command
extends Closeable {
    public String getCommandName();

    default public Options getOptions() {
        return new Options();
    }

    default public boolean hasSubCommand() {
        return false;
    }

    default public Map<String, Command> getSubCommands() {
        return new HashMap<String, Command>();
    }

    default public CommandLine parseAndValidateArgs(String ... args) throws InvalidArgumentException {
        CommandLine cmdline;
        Options opts = this.getOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmdline = parser.parse(opts, args);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(String.format("Failed to parse args for %s: %s", this.getCommandName(), e.getMessage()), (Throwable)e);
        }
        this.validateArgs(cmdline);
        return cmdline;
    }

    default public void validateArgs(CommandLine cl) throws InvalidArgumentException {
    }

    default public int run(CommandLine cl) throws AlluxioException, IOException {
        return 0;
    }

    public String getUsage();

    public String getDescription();

    @Override
    default public void close() throws IOException {
    }
}

