/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class NettyDataBuffer
implements DataBuffer {
    private final ByteBuf mNettyBuf;

    public NettyDataBuffer(ByteBuf bytebuf) {
        Preconditions.checkNotNull((Object)bytebuf, (Object)"bytebuf");
        this.mNettyBuf = bytebuf;
    }

    @Override
    public Object getNettyOutput() {
        return this.mNettyBuf;
    }

    @Override
    public long getLength() {
        return this.mNettyBuf.readableBytes();
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        ByteBuffer buffer = this.mNettyBuf.nioBuffer().asReadOnlyBuffer();
        buffer.position(0);
        return buffer;
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.mNettyBuf.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(OutputStream outputStream, int length) throws IOException {
        this.mNettyBuf.readBytes(outputStream, length);
    }

    @Override
    public void readBytes(ByteBuffer outputBuf) {
        this.mNettyBuf.readBytes(outputBuf);
    }

    @Override
    public int readableBytes() {
        return this.mNettyBuf.readableBytes();
    }

    @Override
    public void release() {
        this.mNettyBuf.release();
    }
}

