/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.LockResource;
import alluxio.resource.Pool;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class ResourcePool<T>
implements Pool<T> {
    private static final long WAIT_INDEFINITELY = -1L;
    private final ReentrantLock mTakeLock = new ReentrantLock();
    private final Condition mNotEmpty = this.mTakeLock.newCondition();
    protected final int mMaxCapacity;
    protected final ConcurrentLinkedQueue<T> mResources;
    protected final AtomicInteger mCurrentCapacity;

    public ResourcePool(int maxCapacity) {
        this(maxCapacity, new ConcurrentLinkedQueue());
    }

    protected ResourcePool(int maxCapacity, ConcurrentLinkedQueue<T> resources) {
        this.mMaxCapacity = maxCapacity;
        this.mCurrentCapacity = new AtomicInteger();
        this.mResources = resources;
    }

    @Override
    public T acquire() {
        return this.acquire(-1L, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public T acquire(long time, TimeUnit unit) {
        T resource;
        Preconditions.checkState((time <= 0L == (unit == null) ? 1 : 0) != 0);
        long endTimeMs = 0L;
        if (time > 0L) {
            endTimeMs = System.currentTimeMillis() + unit.toMillis(time);
        }
        if ((resource = this.mResources.poll()) != null) {
            return resource;
        }
        if (this.mCurrentCapacity.getAndIncrement() < this.mMaxCapacity) {
            return this.createNewResource();
        }
        this.mCurrentCapacity.decrementAndGet();
        try {
            this.mTakeLock.lockInterruptibly();
            try {
                while (true) {
                    if ((resource = this.mResources.poll()) != null) {
                        T t = resource;
                        return t;
                    }
                    if (time > 0L) {
                        long currTimeMs = System.currentTimeMillis();
                        if (endTimeMs - currTimeMs <= 0L) {
                            T t = null;
                            return t;
                        }
                        if (this.mNotEmpty.await(endTimeMs - currTimeMs, TimeUnit.MILLISECONDS)) continue;
                        T t = null;
                        return t;
                    }
                    this.mNotEmpty.await();
                }
            }
            finally {
                this.mTakeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public void release(T resource) {
        if (resource != null) {
            this.mResources.add(resource);
            try (LockResource r = new LockResource(this.mTakeLock);){
                this.mNotEmpty.signal();
            }
        }
    }

    @Override
    public int size() {
        return this.mCurrentCapacity.get();
    }

    protected abstract T createNewResource();
}

