/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.SocketAddress;

public class ClientIpAddressInjector
implements ServerInterceptor {
    private static ThreadLocal<String> sIpAddressThreadLocal = new ThreadLocal();

    public static String getIpAddress() {
        return sIpAddressThreadLocal.get();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.setRemoteIpAddress(call);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onHalfClose() {
                ClientIpAddressInjector.this.setRemoteIpAddress(call);
                super.onHalfClose();
            }
        };
    }

    private <ReqT, RespT> void setRemoteIpAddress(ServerCall<ReqT, RespT> call) {
        String remoteIpAddress = ((SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        sIpAddressThreadLocal.set(remoteIpAddress);
    }
}

