/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.exception.ExceptionMessage;
import alluxio.underfs.AtomicFileOutputStreamCallback;
import alluxio.underfs.options.CreateOptions;
import alluxio.util.IdUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AtomicFileOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    private AtomicFileOutputStreamCallback mUfs;
    private CreateOptions mOptions;
    private String mPermanentPath;
    private String mTemporaryPath;
    private OutputStream mTemporaryOutputStream;
    private boolean mClosed = false;

    public AtomicFileOutputStream(String path, AtomicFileOutputStreamCallback ufs, CreateOptions options) throws IOException {
        this.mOptions = options;
        this.mPermanentPath = path;
        this.mTemporaryPath = PathUtils.temporaryFileName((long)IdUtils.getRandomNonNegativeLong(), (String)path);
        this.mTemporaryOutputStream = ufs.createDirect(this.mTemporaryPath, options);
        this.mUfs = ufs;
    }

    @Override
    public void write(int b) throws IOException {
        this.mTemporaryOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mTemporaryOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mTemporaryOutputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mTemporaryOutputStream.close();
        if (!this.mUfs.renameFile(this.mTemporaryPath, this.mPermanentPath)) {
            if (!this.mUfs.deleteFile(this.mTemporaryPath)) {
                LOG.error("Failed to delete temporary file {}", (Object)this.mTemporaryPath);
            }
            throw new IOException(ExceptionMessage.FAILED_UFS_RENAME.getMessage(new Object[]{this.mTemporaryPath, this.mPermanentPath}));
        }
        if (this.mOptions.getOwner() != null || this.mOptions.getGroup() != null) {
            try {
                this.mUfs.setOwner(this.mPermanentPath, this.mOptions.getOwner(), this.mOptions.getGroup());
            }
            catch (Exception e) {
                LOG.warn("Failed to update the ufs ownership, default values will be used. " + e);
            }
        }
        this.mClosed = true;
    }
}

