/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.util.CommonUtils;
import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BufferUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BufferUtils.class);
    private static final Object LOCK = new Object();
    private static Method sCleanerCleanMethod;
    private static Method sByteBufferCleanerMethod;
    private static Class sUnsafeClass;

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static void cleanDirectBuffer(ByteBuffer buffer) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer is null");
        Preconditions.checkArgument((boolean)buffer.isDirect(), (Object)"buffer isn't a DirectByteBuffer");
        int javaVersion = CommonUtils.getJavaVersion();
        if (javaVersion < 9) {
            BufferUtils.cleanDirectBufferJava8(buffer);
        } else {
            BufferUtils.cleanDirectBufferJava11(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanDirectBufferJava11(ByteBuffer buffer) {
        if (sByteBufferCleanerMethod == null || sUnsafeClass == null) {
            Object object = LOCK;
            synchronized (object) {
                block10: {
                    try {
                        if (sByteBufferCleanerMethod != null && sUnsafeClass != null) break block10;
                        try {
                            sUnsafeClass = Class.forName("sun.misc.Unsafe");
                        }
                        catch (Exception e) {
                            sUnsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                        }
                        sByteBufferCleanerMethod = sUnsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                        sByteBufferCleanerMethod.setAccessible(true);
                    }
                    catch (Exception e) {
                        buffer = null;
                        return;
                    }
                }
            }
        }
        try {
            Field theUnsafeField = sUnsafeClass.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Object theUnsafe = theUnsafeField.get(null);
            sByteBufferCleanerMethod.invoke(theUnsafe, buffer);
        }
        catch (Exception e) {
            LOG.warn("Failed to unmap direct ByteBuffer: {}, error message: {}", (Object)buffer.getClass().getName(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanDirectBufferJava8(ByteBuffer buffer) {
        if (sByteBufferCleanerMethod == null) {
            Object object = LOCK;
            synchronized (object) {
                try {
                    if (sByteBufferCleanerMethod == null) {
                        sByteBufferCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        sByteBufferCleanerMethod.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    buffer = null;
                    return;
                }
            }
        }
        try {
            Object cleaner = sByteBufferCleanerMethod.invoke((Object)buffer, new Object[0]);
            if (cleaner == null) {
                if (buffer.capacity() > 0) {
                    LOG.warn("Failed to get cleaner for ByteBuffer: {}", (Object)buffer.getClass().getName());
                }
                return;
            }
            if (sCleanerCleanMethod == null) {
                Object object = LOCK;
                synchronized (object) {
                    if (sCleanerCleanMethod == null) {
                        sCleanerCleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    }
                }
            }
            sCleanerCleanMethod.invoke(cleaner, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to unmap direct ByteBuffer: {}, error message: {}", (Object)buffer.getClass().getName(), (Object)e.getMessage());
        }
        finally {
            buffer = null;
        }
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit() - buf.position());
        if (buf.hasArray()) {
            ret.put(buf.array(), buf.position(), buf.limit() - buf.position());
        } else {
            ret.put(buf);
        }
        ret.flip();
        return ret;
    }

    public static List<ByteBuffer> cloneByteBufferList(List<ByteBuffer> source) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(source.size());
        for (ByteBuffer b : source) {
            ret.add(BufferUtils.cloneByteBuffer(b));
        }
        return ret;
    }

    public static void putIntByteBuffer(ByteBuffer buf, int b) {
        buf.put((byte)(b & 0xFF));
    }

    public static byte[] getIncreasingByteArray(int len) {
        return BufferUtils.getIncreasingByteArray(0, len);
    }

    public static byte[] getIncreasingByteArray(int start, int len) {
        byte[] ret = new byte[len];
        for (int k = 0; k < len; ++k) {
            ret[k] = (byte)(k + start);
        }
        return ret;
    }

    public static boolean equalConstantByteArray(byte value, int len, byte[] arr) {
        if (arr == null || arr.length != len) {
            return false;
        }
        for (int k = 0; k < len; ++k) {
            if (arr[k] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean equalIncreasingByteArray(int len, byte[] arr) {
        return BufferUtils.equalIncreasingByteArray(0, len, arr);
    }

    public static boolean equalIncreasingByteArray(int start, int len, byte[] arr) {
        if (arr == null || arr.length != len) {
            return false;
        }
        for (int k = 0; k < len; ++k) {
            if (arr[k] == (byte)(start + k)) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer getIncreasingByteBuffer(int len) {
        return BufferUtils.getIncreasingByteBuffer(0, len);
    }

    public static ByteBuffer getIncreasingByteBuffer(int start, int len) {
        return ByteBuffer.wrap(BufferUtils.getIncreasingByteArray(start, len));
    }

    public static boolean equalIncreasingByteBuffer(int start, int len, ByteBuffer buf) {
        if (buf == null) {
            return false;
        }
        buf.rewind();
        if (buf.remaining() != len) {
            return false;
        }
        for (int k = 0; k < len; ++k) {
            if (buf.get() == (byte)(start + k)) continue;
            return false;
        }
        return true;
    }

    public static void writeBufferToFile(String path, byte[] buffer) throws IOException {
        try (FileOutputStream os = new FileOutputStream(path);){
            os.write(buffer);
        }
    }

    public static void fastCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static int intAsUnsignedByteValue(int i) {
        return (byte)i & 0xFF;
    }

    public static byte[] newByteArrayFromByteBuffer(ByteBuffer buf) {
        int length = buf.remaining();
        byte[] bytes = new byte[length];
        buf.duplicate().get(bytes, 0, length);
        return bytes;
    }

    public static ByteBuffer sliceByteBuffer(ByteBuffer buffer, int position, int length) {
        ByteBuffer slicedBuffer = ((ByteBuffer)buffer.duplicate().position(position)).slice();
        slicedBuffer.limit(length);
        return slicedBuffer;
    }

    public static ByteBuffer sliceByteBuffer(ByteBuffer buffer, int position) {
        return ((ByteBuffer)buffer.duplicate().position(position)).slice();
    }

    private BufferUtils() {
    }
}

