/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.Command;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CommandUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommandUtils.class);

    private CommandUtils() {
    }

    public static Map<String, Command> loadCommands(String pkgName, Class[] classArgs, Object[] objectArgs) {
        HashMap<String, Command> commandsMap = new HashMap<String, Command>();
        Reflections reflections = new Reflections(Command.class.getPackage().getName(), new Scanner[0]);
        for (Class cls : reflections.getSubTypesOf(Command.class)) {
            if (!cls.getPackage().getName().equals(pkgName + ".command") || Modifier.isAbstract(cls.getModifiers())) continue;
            Command cmd = (Command)CommonUtils.createNewClassInstance(cls, classArgs, objectArgs);
            commandsMap.put(cmd.getCommandName(), cmd);
        }
        return commandsMap;
    }

    public static void checkNumOfArgsEquals(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length != n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }

    public static void checkNumOfArgsNoLessThan(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length < n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM_INSUFFICIENT.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }

    public static void checkNumOfArgsNoMoreThan(Command cmd, CommandLine cl, int n) throws InvalidArgumentException {
        if (cl.getArgs().length > n) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARGS_NUM_TOO_MANY.getMessage(cmd.getCommandName(), n, cl.getArgs().length));
        }
    }

    @Nullable
    public static Set<String> readNodeList(String confDir, String fileName) {
        List<String> lines;
        String path = Paths.get(confDir, fileName).normalize().toString();
        try {
            lines = Files.readAllLines(Paths.get(confDir, fileName), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.format("Failed to read file %s/%s. Ignored.%n", confDir, fileName);
            return new HashSet<String>();
        }
        HashSet<String> nodes = new HashSet<String>();
        for (String line : lines) {
            String node = line.trim();
            if (node.startsWith("#") || node.length() == 0 || nodes.add(node)) continue;
            System.out.format("Duplicate node hostname %s found in %s%n", node, path);
        }
        return nodes;
    }
}

