/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RunTestUtils.class);

    private RunTestUtils() {
    }

    public static void printTestStatus(boolean pass, PrintStream outStream) {
        if (pass) {
            outStream.println("\u001b[32mPassed the test!\u001b[0m");
        } else {
            outStream.println("\u001b[31mFailed the test!\u001b[0m");
        }
    }

    public static void printTestStatus(boolean pass) {
        RunTestUtils.printTestStatus(pass, System.out);
    }

    public static boolean runExample(Callable<Boolean> example) {
        boolean result;
        try {
            result = example.call();
        }
        catch (Exception e) {
            LOG.error("Exception running test: " + example, (Throwable)e);
            result = false;
        }
        RunTestUtils.printTestStatus(result);
        return result;
    }
}

