/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.DefaultSupplier;
import alluxio.RuntimeConstants;
import alluxio.conf.Deprecated;
import alluxio.conf.DeprecatedKeyChecker;
import alluxio.conf.RemovedKey;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.Scope;
import alluxio.grpc.WritePType;
import alluxio.util.OSUtils;
import alluxio.util.io.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PropertyKey
implements Comparable<PropertyKey> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyKey.class);
    private static final Map<String, PropertyKey> DEFAULT_KEYS_MAP = new ConcurrentHashMap<String, PropertyKey>();
    private static final Map<String, PropertyKey> DEFAULT_ALIAS_MAP = new ConcurrentHashMap<String, PropertyKey>();
    private static final Cache<String, Boolean> REGEXP_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build();
    public static final PropertyKey CONF_DIR = new Builder("alluxio.conf.dir").setDefaultValue(String.format("${%s}/conf", "alluxio.home")).setDescription("The directory containing files used to configure Alluxio.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey CONF_DYNAMIC_UPDATE_ENABLED = new Builder("alluxio.conf.dynamic.update.enabled").setDefaultValue(false).setDescription("Whether to support dynamic update property.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey CONF_VALIDATION_ENABLED = new Builder("alluxio.conf.validation.enabled").setDefaultValue(true).setDescription("Whether to validate the configuration properties when initializing Alluxio clients or server process.").setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey DEBUG = new Builder("alluxio.debug").setDefaultValue(false).setDescription("Set to true to enable debug mode which has additional logging and info in the Web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey EXTENSIONS_DIR = new Builder("alluxio.extensions.dir").setDefaultValue(String.format("${%s}/extensions", "alluxio.home")).setDescription("The directory containing Alluxio extensions.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey HOME = new Builder("alluxio.home").setDefaultValue("/opt/alluxio").setDescription("Alluxio installation directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey LOGGER_TYPE = new Builder("alluxio.logger.type").setDefaultValue("Console").setDescription("This controls which logger the process uses. This is only set by test code.").setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.ALL).build();
    public static final PropertyKey LOGS_DIR = new Builder("alluxio.logs.dir").setDefaultValue(String.format("${%s}/logs", "alluxio.work.dir")).setDescription("The path under Alluxio home directory to store log files. It has a corresponding environment variable $ALLUXIO_LOGS_DIR.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey USER_LOGS_DIR = new Builder("alluxio.user.logs.dir").setDefaultValue(String.format("${%s}/user", "alluxio.logs.dir")).setDescription("The path to store logs of Alluxio shell. To change its value, one can  set environment variable $ALLUXIO_USER_LOGS_DIR.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey METRICS_CONF_FILE = new Builder("alluxio.metrics.conf.file").setDefaultValue(String.format("${%s}/metrics.properties", "alluxio.conf.dir")).setDescription("The file path of the metrics system configuration file. By default it is `metrics.properties` in the `conf` directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey METRICS_CONTEXT_SHUTDOWN_TIMEOUT = new Builder("alluxio.metrics.context.shutdown.timeout").setDefaultValue("1sec").setDescription("Time to wait for the metrics context to shut down. The main purpose for this property is to allow tests to shut down faster.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setIsHidden(true).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_AUTH_TIMEOUT = new Builder("alluxio.network.connection.auth.timeout").setDefaultValue("30sec").setDescription("Maximum time to wait for a connection (gRPC channel) to attempt to receive an authentication response.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT = new Builder("alluxio.network.connection.health.check.timeout").setAlias("alluxio.network.connection.health.check.timeout.ms").setDefaultValue("5sec").setDescription("Allowed duration for checking health of client connections (gRPC channels) before being assigned to a client. If a connection does not become active  within configured time, it will be shut down and a new connection will be created for the client").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT = new Builder("alluxio.network.connection.server.shutdown.timeout").setDefaultValue("60sec").setDescription("Maximum time to wait for gRPC server to stop on shutdown").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey NETWORK_CONNECTION_SHUTDOWN_GRACEFUL_TIMEOUT = new Builder("alluxio.network.connection.shutdown.graceful.timeout").setDefaultValue("45sec").setDescription("Maximum time to wait for connections (gRPC channels) to stop on shutdown").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_CONNECTION_SHUTDOWN_TIMEOUT = new Builder("alluxio.network.connection.shutdown.timeout").setDefaultValue("15sec").setDescription("Maximum time to wait for connections (gRPC channels) to stop after graceful shutdown attempt.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_HOST_RESOLUTION_TIMEOUT_MS = new Builder("alluxio.network.host.resolution.timeout").setAlias("alluxio.network.host.resolution.timeout.ms").setDefaultValue("5sec").setDescription("During startup of the Master and Worker processes Alluxio needs to ensure that they are listening on externally resolvable and reachable host names. To do this, Alluxio will automatically attempt to select an appropriate host name if one was not explicitly specified. This represents the maximum amount of time spent waiting to determine if a candidate host name is resolvable over the network.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey SITE_CONF_DIR = new Builder("alluxio.site.conf.dir").setDefaultSupplier(() -> String.format("${%s}/,%s/.alluxio/,/etc/alluxio/", "alluxio.conf.dir", System.getProperty("user.home")), String.format("${%s}/,${user.home}/.alluxio/,/etc/alluxio/", "alluxio.conf.dir")).setDescription(String.format("Comma-separated search path for %s.", "alluxio-site.properties")).setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_IP_ADDRESS_USED = new Builder("alluxio.network.ip.address.used").setDefaultValue("false").setDescription("If true, when alluxio.<service_name>.hostname and alluxio.<service_name>.bind.host of a service not specified, use IP as the connect host of the service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey TEST_MODE = new Builder("alluxio.test.mode").setDefaultValue(false).setDescription("Flag used only during tests to allow special behavior.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setIsHidden(true).setScope(Scope.ALL).build();
    public static final PropertyKey TMP_DIRS = new Builder("alluxio.tmp.dirs").setDefaultValue("/tmp").setDescription("The path(s) to store Alluxio temporary files, use commas as delimiters. If multiple paths are specified, one will be selected at random per temporary file. Currently, only files to be uploaded to object stores are stored in these paths.").setScope(Scope.SERVER).build();
    public static final PropertyKey VERSION = new Builder("alluxio.version").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setDefaultValue("2.6.2-3").setDescription("Version of Alluxio. User should never modify this property.").setIgnoredSiteProperty(true).setIsHidden(true).setScope(Scope.ALL).build();
    public static final PropertyKey WEB_FILE_INFO_ENABLED = new Builder("alluxio.web.file.info.enabled").setDefaultValue(true).setDescription("Whether detailed file information are enabled for the web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_RESOURCES = new Builder("alluxio.web.resources").setDefaultValue(String.format("${%s}/webui/", "alluxio.home")).setDescription("Path to the web UI resources. User should never modify this property.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).setIsHidden(true).build();
    public static final PropertyKey WEB_THREADS = new Builder("alluxio.web.threads").setDefaultValue(1).setDescription("How many threads to serve Alluxio web UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_CORS_ENABLED = new Builder("alluxio.web.cors.enabled").setDefaultValue(false).setDescription("Set to true to enable Cross-Origin Resource Sharing for RESTful APIendpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_REFRESH_INTERVAL = new Builder("alluxio.web.refresh.interval").setDefaultValue("15s").setDescription("The amount of time to await before refreshing the Web UI if it is set to auto refresh.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey WEB_UI_ENABLED = new Builder("alluxio.web.ui.enabled").setDefaultValue(true).setDescription("Whether the master/worker will have Web UI enabled. If set to false, the master/worker will not have Web UI page, but the RESTful endpoints and metrics will still be available.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey WORK_DIR = new Builder("alluxio.work.dir").setDefaultValue(String.format("${%s}", "alluxio.home")).setDescription("The directory to use for Alluxio's working directory. By default, the journal, logs, and under file storage data (if using local filesystem) are written here.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey ZOOKEEPER_ADDRESS = new Builder("alluxio.zookeeper.address").setDescription("Address of ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_CONNECTION_TIMEOUT = new Builder("alluxio.zookeeper.connection.timeout").setDefaultValue("15s").setDescription("Connection timeout for Alluxio (job) masters to select the leading (job) master when connecting to Zookeeper").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey ZOOKEEPER_ELECTION_PATH = new Builder("alluxio.zookeeper.election.path").setDefaultValue("/alluxio/election").setDescription("Election directory in ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_ENABLED = new Builder("alluxio.zookeeper.enabled").setDefaultValue(false).setDescription("If true, setup master fault tolerant mode using ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT = new Builder("alluxio.zookeeper.leader.inquiry.retry").setDefaultValue(10).setDescription("The number of retries to inquire leader from ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_LEADER_PATH = new Builder("alluxio.zookeeper.leader.path").setDefaultValue("/alluxio/leader").setDescription("Leader directory in ZooKeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_SESSION_TIMEOUT = new Builder("alluxio.zookeeper.session.timeout").setDefaultValue("60s").setDescription("Session timeout to use when connecting to Zookeeper").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey ZOOKEEPER_AUTH_ENABLED = new Builder("alluxio.zookeeper.auth.enabled").setDefaultValue(true).setDescription("If true, enable client-side Zookeeper authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_LEADER_CONNECTION_ERROR_POLICY = new Builder("alluxio.zookeeper.leader.connection.error.policy").setDefaultValue("SESSION").setDescription("Connection error policy defines how errors on zookeeper connections to be treated in leader election. STANDARD policy treats every connection event as failure.SESSION policy relies on zookeeper sessions for judging failures, helping leader to retain its status, as long as its session is protected.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_ALLOW_SET_OWNER_FAILURE = new Builder("alluxio.underfs.allow.set.owner.failure").setDefaultValue(false).setDescription("Whether to allow setting owner in UFS to fail. When set to true, it is possible file or directory owners diverge between Alluxio and UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_CLEANUP_ENABLED = new Builder("alluxio.underfs.cleanup.enabled").setDefaultValue(false).setDescription("Whether or not to clean up under file storage periodically.Some ufs operations may not be completed and cleaned up successfully in normal ways and leave some intermediate data that needs periodical cleanup.If enabled, all the mount points will be cleaned up when a leader master starts or cleanup interval is reached. This should be used sparingly.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_CLEANUP_INTERVAL = new Builder("alluxio.underfs.cleanup.interval").setDefaultValue("1day").setDescription("The interval for periodically cleaning all the  mounted under file storages.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_LISTING_LENGTH = new Builder("alluxio.underfs.listing.length").setDefaultValue(1000).setDescription("The maximum number of directory entries to list in a single query to under file system. If the total number of entries is greater than the specified length, multiple queries will be issued.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey UNDERFS_LOGGING_THRESHOLD = new Builder("alluxio.underfs.logging.threshold").setDefaultValue("10s").setDescription("Logging a UFS API call when it takes more time than the threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_DEFAULT_MODE = new Builder("alluxio.underfs.gcs.default.mode").setDefaultValue("0700").setDescription("Mode (in octal notation) for GCS objects if mode cannot be discovered.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_DIRECTORY_SUFFIX = new Builder("alluxio.underfs.gcs.directory.suffix").setDefaultValue("/").setDescription("Directories are represented in GCS as zero-byte objects named with the specified suffix.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING = new Builder("alluxio.underfs.gcs.owner.id.to.username.mapping").setDescription(String.format("Optionally, specify a preset gcs owner id to Alluxio username static mapping in the format \"id1=user1;id2=user2\". The Google Cloud Storage IDs can be found at the console address https://console.cloud.google.com/storage/settings . Please use the \"Owners\" one. This property key is only valid when %s=1", "alluxio.underfs.gcs.version")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_INITIAL_DELAY_MS = new Builder("alluxio.underfs.gcs.retry.initial.delay").setDefaultValue(1000).setDescription("Initial delay before attempting the retry on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_MAX_DELAY_MS = new Builder("alluxio.underfs.gcs.retry.max.delay").setDefaultValue(60000).setDescription("Maximum delay before attempting the retry on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_DELAY_MULTIPLIER = new Builder("alluxio.underfs.gcs.retry.delay.multiplier").setDefaultValue(2).setDescription("Delay multiplier while retrying requests on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_JITTER = new Builder("alluxio.underfs.gcs.retry.jitter").setDefaultValue(true).setDescription("Enable delay jitter while retrying requests on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_TOTAL_DURATION_MS = new Builder("alluxio.underfs.gcs.retry.total.duration").setDefaultValue(300000).setDescription("Maximum retry duration on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_RETRY_MAX = new Builder("alluxio.underfs.gcs.retry.max").setDefaultValue(60).setDescription("Maximum Number of retries on the ufs").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_GCS_VERSION = new Builder("alluxio.underfs.gcs.version").setDefaultValue(2).setDescription(String.format("Specify the version of GCS module to use. GCS version \"1\" builds on top of jets3t package which requires %s and %s. GCS version \"2\" build on top of Google cloud API which requires %s", "fs.gcs.accessKeyId", "fs.gcs.secretAccessKey", "fs.gcs.credential.path")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_CONFIGURATION = new Builder("alluxio.underfs.hdfs.configuration").setDefaultValue(String.format("${%s}/core-site.xml:${%s}/hdfs-site.xml", "alluxio.conf.dir", "alluxio.conf.dir")).setDescription("Location of the HDFS configuration file to overwrite the default HDFS client configuration. Note that, these files must be availableon every node.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_IMPL = new Builder("alluxio.underfs.hdfs.impl").setDefaultValue("org.apache.hadoop.hdfs.DistributedFileSystem").setDescription("The implementation class of the HDFS as the under storage system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_PREFIXES = new Builder("alluxio.underfs.hdfs.prefixes").setDefaultValue("hdfs://,glusterfs:///").setDescription("Optionally, specify which prefixes should run through the HDFS implementation of UnderFileSystem. The delimiter is any whitespace and/or ','.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_HDFS_REMOTE = new Builder("alluxio.underfs.hdfs.remote").setDefaultValue(true).setDescription("Boolean indicating whether or not the under storage worker nodes are remote with respect to Alluxio worker nodes. If set to true, Alluxio will not attempt to discover locality information from the under storage because locality is impossible. This will improve performance. The default value is true.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_LOCAL_SKIP_BROKEN_SYMLINKS = new Builder("alluxio.underfs.local.skip.broken.symlinks").setDefaultValue(false).setDescription("When set to true, any time the local underfs lists a broken symlink, it will treat the entry as if it didn't exist at all.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_HEADER_LAST_MODIFIED = new Builder("alluxio.underfs.web.header.last.modified").setDefaultValue("EEE, dd MMM yyyy HH:mm:ss zzz").setDescription("Date format of last modified for a http response header.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_CONNECTION_TIMEOUT = new Builder("alluxio.underfs.web.connnection.timeout").setDefaultValue("60s").setDescription("Default timeout for a http connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_PARENT_NAMES = new Builder("alluxio.underfs.web.parent.names").setDefaultValue("Parent Directory,..,../").setDescription("The text of the http link for the parent directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_WEB_TITLES = new Builder("alluxio.underfs.web.titles").setDefaultValue("Index of,Directory listing for").setDescription("The title of the content for a http url.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_BREADCRUMBS_ENABLED = new Builder("alluxio.underfs.object.store.breadcrumbs.enabled").setDefaultValue(true).setDescription("Set this to false to prevent Alluxio from creating zero byte objects during read or list operations on object store UFS. Leaving this on enables more efficient listing of prefixes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE = new Builder("alluxio.underfs.object.store.multi.range.chunk.size").setDefaultValue(String.format("${%s}", "alluxio.user.block.size.bytes.default")).setDescription("Default chunk size for ranged reads from multi-range object input streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_SERVICE_THREADS = new Builder("alluxio.underfs.object.store.service.threads").setDefaultValue(20).setDescription("The number of threads in executor pool for parallel object store UFS operations, such as directory renames and deletes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_SKIP_PARENT_DIRECTORY_CREATION = new Builder("alluxio.underfs.object.store.skip.parent.directory.creation").setDefaultValue(true).setDescription("Do not create parent directory for new files. Object stores generally uses prefix which is not required for creating new files. Skipping parent directory is recommended for better performance. Set this to false if the object store requires prefix creation for new files.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY = new Builder("alluxio.underfs.object.store.mount.shared.publicly").setDefaultValue(false).setDescription("Whether or not to share object storage under storage system mounted point with all Alluxio users. Note that this configuration has no effect on HDFS nor local UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_BASE_SLEEP_MS = new Builder("alluxio.underfs.eventual.consistency.retry.base.sleep").setDefaultValue("50ms").setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the base time for the exponential backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_NUM = new Builder("alluxio.underfs.eventual.consistency.retry.max.num").setDefaultValue(20).setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the maximum number of retries.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_SLEEP_MS = new Builder("alluxio.underfs.eventual.consistency.retry.max.sleep").setDefaultValue("30sec").setDescription("To handle eventually consistent storage semantics for certain under storages, Alluxio will perform retries when under storage metadata doesn't match Alluxio's expectations. These retries use exponential backoff. This property determines the maximum wait time in the backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_MAX = new Builder("alluxio.underfs.oss.connection.max").setDefaultValue(1024).setDescription("The maximum number of OSS connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_TIMEOUT = new Builder("alluxio.underfs.oss.connection.timeout").setAlias("alluxio.underfs.oss.connection.timeout.ms").setDefaultValue("50sec").setDescription("The timeout when connecting to OSS.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_CONNECT_TTL = new Builder("alluxio.underfs.oss.connection.ttl").setDefaultValue(-1).setDescription("The TTL of OSS connections in ms.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_OSS_SOCKET_TIMEOUT = new Builder("alluxio.underfs.oss.socket.timeout").setAlias("alluxio.underfs.oss.socket.timeout.ms").setDefaultValue("50sec").setDescription("The timeout of OSS socket.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_ADMIN_THREADS_MAX = new Builder("alluxio.underfs.s3.admin.threads.max").setDefaultValue(20).setDescription("The maximum number of threads to use for metadata operations when communicating with S3. These operations may be fairly concurrent and frequent but should not take much time to process.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DISABLE_DNS_BUCKETS = new Builder("alluxio.underfs.s3.disable.dns.buckets").setDefaultValue(false).setDescription("Optionally, specify to make all S3 requests path style.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_ENDPOINT = new Builder("alluxio.underfs.s3.endpoint").setDescription("Optionally, to reduce data latency or visit resources which are separated in different AWS regions, specify a regional endpoint to make aws requests. An endpoint is a URL that is the entry point for a web service. For example, s3.cn-north-1.amazonaws.com.cn is an entry point for the Amazon S3 service in beijing region.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING = new Builder("alluxio.underfs.s3.owner.id.to.username.mapping").setDescription("Optionally, specify a preset s3 canonical id to Alluxio username static mapping, in the format \"id1=user1;id2=user2\". The AWS S3 canonical ID can be found at the console address https://console.aws.amazon.com/iam/home?#security_credential . Please expand the \"Account Identifiers\" tab and refer to \"Canonical User ID\". Unspecified owner id will map to a default empty username").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_PROXY_HOST = new Builder("alluxio.underfs.s3.proxy.host").setDescription("Optionally, specify a proxy host for communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_PROXY_PORT = new Builder("alluxio.underfs.s3.proxy.port").setDescription("Optionally, specify a proxy port for communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_THREADS_MAX = new Builder("alluxio.underfs.s3.threads.max").setDefaultValue(40).setDescription("The maximum number of threads to use for communicating with S3 and the maximum number of concurrent connections to S3. Includes both threads for data upload and metadata operations. This number should be at least as large as the max admin threads plus max upload threads.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_UPLOAD_THREADS_MAX = new Builder("alluxio.underfs.s3.upload.threads.max").setDefaultValue(20).setDescription("For an Alluxio worker, this is the maximum number of threads to use for uploading data to S3 for multipart uploads. These operations can be fairly expensive, so multiple threads are encouraged. However, this also splits the bandwidth between threads, meaning the overall latency for completing an upload will be higher for more threads. For the Alluxio master, this is the maximum number of threads used for the rename (copy) operation. It is recommended that value should be greater than or equal to alluxio.underfs.object.store.service.threads").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DEFAULT_MODE = new Builder("alluxio.underfs.s3.default.mode").setAlias("alluxio.underfs.s3a.default.mode").setDefaultValue("0700").setDescription("Mode (in octal notation) for S3 objects if mode cannot be discovered.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_DIRECTORY_SUFFIX = new Builder("alluxio.underfs.s3.directory.suffix").setAlias("alluxio.underfs.s3a.directory.suffix").setDefaultValue("/").setDescription("Directories are represented in S3 as zero-byte objects named with the specified suffix.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_BULK_DELETE_ENABLED = new Builder("alluxio.underfs.s3.bulk.delete.enabled").setAlias("alluxio.underfs.s3a.bulk.delete.enabled").setDefaultValue(true).setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_INHERIT_ACL = new Builder("alluxio.underfs.s3.inherit.acl").setAlias("alluxio.underfs.s3a.inherit_acl").setDefaultValue(true).setDescription("Set this property to false to disable inheriting bucket ACLs on objects. Note that the translation from bucket ACLs to Alluxio user permissions is best effort as some S3-like storage services doe not implement ACLs fully compatible with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE = new Builder("alluxio.underfs.s3.intermediate.upload.clean.age").setAlias("alluxio.underfs.s3a.intermediate.upload.clean.age").setDefaultValue("3day").setDescription("Streaming uploads may not have been completed/aborted correctly and need periodical ufs cleanup. If ufs cleanup is enabled, intermediate multipart uploads in all non-readonly S3 mount points older than this age will be cleaned. This may impact other ongoing upload operations, so a large clean age is encouraged.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_LIST_OBJECTS_V1 = new Builder("alluxio.underfs.s3.list.objects.v1").setAlias("alluxio.underfs.s3a.list.objects.v1").setDefaultValue(false).setDescription("Whether to use version 1 of GET Bucket (List Objects) API.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_MAX_ERROR_RETRY = new Builder("alluxio.underfs.s3.max.error.retry").setAlias("alluxio.underfs.s3a.max.error.retry").setDescription("The maximum number of retry attempts for failed retryable requests.Setting this property will override the AWS SDK default.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_REQUEST_TIMEOUT = new Builder("alluxio.underfs.s3.request.timeout").setAlias("alluxio.underfs.s3a.request.timeout.ms", "alluxio.underfs.s3a.request.timeout").setDefaultValue("1min").setDescription("The timeout for a single request to S3. Infinity if set to 0. Setting this property to a non-zero value can improve performance by avoiding the long tail of requests to S3. For very slow connections to S3, consider increasing this value or setting it to 0.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SECURE_HTTP_ENABLED = new Builder("alluxio.underfs.s3.secure.http.enabled").setAlias("alluxio.underfs.s3a.secure.http.enabled").setDefaultValue(false).setDescription("Whether or not to use HTTPS protocol when communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SERVER_SIDE_ENCRYPTION_ENABLED = new Builder("alluxio.underfs.s3.server.side.encryption.enabled").setAlias("alluxio.underfs.s3a.server.side.encryption.enabled").setDefaultValue(false).setDescription("Whether or not to encrypt data stored in S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SIGNER_ALGORITHM = new Builder("alluxio.underfs.s3.signer.algorithm").setAlias("alluxio.underfs.s3a.signer.algorithm").setDescription("The signature algorithm which should be used to sign requests to the s3 service. This is optional, and if not set, the client will automatically determine it. For interacting with an S3 endpoint which only supports v2 signatures, set this to \"S3SignerType\".").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_CONNECT_TTL = new Builder("alluxio.underfs.s3.connection.ttl").setDefaultValue(-1).setDescription("The expiration time of S3 connections in ms. -1 means the connection will never expire.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_SOCKET_TIMEOUT = new Builder("alluxio.underfs.s3.socket.timeout").setAlias("alluxio.underfs.s3a.socket.timeout.ms", "alluxio.underfs.s3a.socket.timeout").setDefaultValue("50sec").setDescription("Length of the socket timeout when communicating with S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_STREAMING_UPLOAD_ENABLED = new Builder("alluxio.underfs.s3.streaming.upload.enabled").setAlias("alluxio.underfs.s3a.streaming.upload.enabled").setDefaultValue(false).setDescription("(Experimental) If true, using streaming upload to write to S3.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE = new Builder("alluxio.underfs.s3.streaming.upload.partition.size").setAlias("alluxio.underfs.s3a.streaming.upload.partition.size").setDefaultValue("64MB").setDescription("Maximum allowable size of a single buffer file when using S3A streaming upload. When the buffer file reaches the partition size, it will be uploaded and the upcoming data will write to other buffer files.If the partition size is too small, S3A upload speed might be affected. ").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_KODO_REQUESTS_MAX = new Builder("alluxio.underfs.kodo.requests.max").setDefaultValue(64).setDescription("The maximum number of kodo connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_KODO_CONNECT_TIMEOUT = new Builder("alluxio.underfs.kodo.connect.timeout").setDefaultValue("50sec").setDescription("The connect timeout of kodo.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_AUTH_ID = new Builder("alluxio.underfs.cephfs.auth.id").setDefaultValue("admin").setDescription("Ceph client id for authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_CONF_FILE = new Builder("alluxio.underfs.cephfs.conf.file").setDefaultValue("/etc/ceph/ceph.conf").setDescription("Path to Ceph configuration file.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_CONF_OPTS = new Builder("alluxio.underfs.cephfs.conf.options").setDescription("Extra configuration options for CephFS client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_AUTH_KEY = new Builder("alluxio.underfs.cephfs.auth.key").setDescription("CephX authentication key, base64 encoded.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_AUTH_KEYFILE = new Builder("alluxio.underfs.cephfs.auth.keyfile").setDescription("Path to CephX authentication key file.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_AUTH_KEYRING = new Builder("alluxio.underfs.cephfs.auth.keyring").setDefaultValue("/etc/ceph/ceph.client.admin.keyring").setDescription("Path to CephX authentication keyring file.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_MON_HOST = new Builder("alluxio.underfs.cephfs.mon.host").setDefaultValue("0.0.0.0").setDescription("List of hosts or addresses to search for a Ceph monitor.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_MDS_NAMESPACE = new Builder("alluxio.underfs.cephfs.mds.namespace").setDescription("CephFS filesystem to mount.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_MOUNT_UID = new Builder("alluxio.underfs.cephfs.mount.uid").setDefaultValue(0).setDescription("The user ID of CephFS mount.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_MOUNT_GID = new Builder("alluxio.underfs.cephfs.mount.gid").setDefaultValue(0).setDescription("The group ID of CephFS mount.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_MOUNT_POINT = new Builder("alluxio.underfs.cephfs.mount.point").setDefaultValue("/").setDescription("Directory to mount on the CephFS filesystem.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey UNDERFS_CEPHFS_LOCALIZE_READS = new Builder("alluxio.underfs.cephfs.localize.reads").setDefaultValue(false).setDescription("Utilize Ceph localized reads feature.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey ABFS_CLIENT_ENDPOINT = new Builder("fs.azure.account.oauth2.client.endpoint").setDescription("The oauth endpoint for ABFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey ABFS_CLIENT_ID = new Builder("fs.azure.account.oauth2.client.id").setDescription("The client id for ABFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey ABFS_CLIENT_SECRET = new Builder("fs.azure.account.oauth2.client.secret").setDescription("The client secret for ABFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey GCS_ACCESS_KEY = new Builder("fs.gcs.accessKeyId").setDescription(String.format("The access key of GCS bucket. This property key is only valid when %s=1", "alluxio.underfs.gcs.version")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey GCS_SECRET_KEY = new Builder("fs.gcs.secretAccessKey").setDescription(String.format("The secret key of GCS bucket. This property key is only valid when %s=1", "alluxio.underfs.gcs.version")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey GCS_CREDENTIAL_PATH = new Builder("fs.gcs.credential.path").setDescription(String.format("The json file path of Google application credentials. This property key is only valid when %s=2", "alluxio.underfs.gcs.version")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey OSS_ACCESS_KEY = new Builder("fs.oss.accessKeyId").setDescription("The access key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey OSS_ENDPOINT_KEY = new Builder("fs.oss.endpoint").setDescription("The endpoint key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey OSS_SECRET_KEY = new Builder("fs.oss.accessKeySecret").setDescription("The secret key of OSS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey S3A_ACCESS_KEY = new Builder("aws.accessKeyId").setDescription("The access key of S3 bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey S3A_SECRET_KEY = new Builder("aws.secretKey").setDescription("The secret key of S3 bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_AUTH_METHOD_KEY = new Builder("fs.swift.auth.method").setDescription("Choice of authentication method: [tempauth (default), swiftauth, keystone, keystonev3].").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_AUTH_URL_KEY = new Builder("fs.swift.auth.url").setDescription("Authentication URL for REST server, e.g., http://server:8090/auth/v1.0.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_PASSWORD_KEY = new Builder("fs.swift.password").setDescription("The password used for user:tenant authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_SIMULATION = new Builder("fs.swift.simulation").setDescription("Whether to simulate a single node Swift backend for testing purposes: true or false (default).").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey SWIFT_TENANT_KEY = new Builder("fs.swift.tenant").setDescription("Swift user for authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_USER_KEY = new Builder("fs.swift.user").setDescription("Swift tenant for authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey SWIFT_REGION_KEY = new Builder("fs.swift.region").setDescription("Service region when using Keystone authentication.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).build();
    public static final PropertyKey COS_ACCESS_KEY = new Builder("fs.cos.access.key").setDescription("The access key of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey COS_APP_ID = new Builder("fs.cos.app.id").setDescription("The app id of COS bucket.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_CONNECTION_MAX = new Builder("fs.cos.connection.max").setDefaultValue(1024).setDescription("The maximum number of COS connections.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_CONNECTION_TIMEOUT = new Builder("fs.cos.connection.timeout").setDefaultValue("50sec").setDescription("The timeout of connecting to COS.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_SOCKET_TIMEOUT = new Builder("fs.cos.socket.timeout").setDefaultValue("50sec").setDescription("The timeout of COS socket.").setScope(Scope.SERVER).build();
    public static final PropertyKey COS_REGION = new Builder("fs.cos.region").setDescription("The region name of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey COS_SECRET_KEY = new Builder("fs.cos.secret.key").setDescription("The secret key of COS bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey MASTER_JOURNAL_UFS_OPTION = new Builder(Template.MASTER_JOURNAL_UFS_OPTION, new Object[0]).setDescription("The configuration to use for the journal operations.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey KODO_ACCESS_KEY = new Builder("fs.kodo.accesskey").setDescription("The access key of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey KODO_SECRET_KEY = new Builder("fs.kodo.secretkey").setDescription("The secret key of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).setDisplayType(DisplayType.CREDENTIALS).build();
    public static final PropertyKey KODO_DOWNLOAD_HOST = new Builder("alluxio.underfs.kodo.downloadhost").setDescription("The download domain of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey KODO_ENDPOINT = new Builder("alluxio.underfs.kodo.endpoint").setDescription("The endpoint of Kodo bucket.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_ALLUXIO = new Builder(Template.MASTER_MOUNT_TABLE_ALLUXIO, "root").setDefaultValue("/").setDescription("Alluxio root mount point.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_OPTION = new Builder(Template.MASTER_MOUNT_TABLE_OPTION, "root").setDescription("Configuration for the UFS of Alluxio root mount point.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_READONLY = new Builder(Template.MASTER_MOUNT_TABLE_READONLY, "root").setDefaultValue(false).setDescription("Whether Alluxio root mount point is readonly.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_SHARED = new Builder(Template.MASTER_MOUNT_TABLE_SHARED, "root").setDefaultValue(true).setDescription("Whether Alluxio root mount point is shared.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_MOUNT_TABLE_ROOT_UFS = new Builder(Template.MASTER_MOUNT_TABLE_UFS, "root").setAlias("alluxio.underfs.address").setDescription("The storage address of the UFS at the Alluxio root mount point.").setDefaultValue(String.format("${%s}/underFSStorage", "alluxio.work.dir")).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_ASYNC_PERSIST_SIZE_VALIDATION = new Builder("alluxio.master.async.persist.size.validation").setDefaultValue(true).setDescription("Checks if the size of an async persist file matches the original file and fails the async persist job if not.").setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_AUDIT_LOGGING_ENABLED = new Builder("alluxio.master.audit.logging.enabled").setDefaultValue(false).setDescription("Set to true to enable file system master audit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_AUDIT_LOGGING_QUEUE_CAPACITY = new Builder("alluxio.master.audit.logging.queue.capacity").setDefaultValue(10000).setDescription("Capacity of the queue used by audit logging.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_DIRECTORY = new Builder("alluxio.master.backup.directory").setDefaultValue("/alluxio_backups").setDescription("Default directory for writing master metadata backups. This path is an absolute path of the root UFS. For example, if the root ufs directory is hdfs://host:port/alluxio/data, the default backup directory will be hdfs://host:port/alluxio_backups.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_ENTRY_BUFFER_COUNT = new Builder("alluxio.master.backup.entry.buffer.count").setDefaultValue("10000").setDescription("How many journal entries to buffer during a back-up.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_DELEGATION_ENABLED = new Builder("alluxio.master.backup.delegation.enabled").setDefaultValue(false).setDescription("Whether to delegate journals to stand-by masters in HA cluster.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_TRANSPORT_TIMEOUT = new Builder("alluxio.master.backup.transport.timeout").setDefaultValue("30sec").setDescription("Request timeout for backup messaging.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_HEARTBEAT_INTERVAL = new Builder("alluxio.master.backup.heartbeat.interval").setDefaultValue("2sec").setDescription("Interval at which follower updates the leader on ongoing backup.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_CONNECT_INTERVAL_MIN = new Builder("alluxio.master.backup.connect.interval.min").setDefaultValue("1sec").setDescription("Minimum delay between each connection attempt to backup-leader.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_CONNECT_INTERVAL_MAX = new Builder("alluxio.master.backup.connect.interval.max").setDefaultValue("30sec").setDescription("Maximum delay between each connection attempt to backup-leader.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_ABANDON_TIMEOUT = new Builder("alluxio.master.backup.abandon.timeout").setDefaultValue("1min").setDescription("Duration after which leader will abandon the backup if not received heartbeat from backup-worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_STATE_LOCK_EXCLUSIVE_DURATION = new Builder("alluxio.master.backup.state.lock.exclusive.duration").setDefaultValue("0ms").setDescription("Alluxio master will allow only exclusive locking of the state-lock for this duration. This duration starts after masters are started for the first time. User RPCs will fail to acquire state-lock during this phase and a backup is guaranteed take the state-lock meanwhile.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_STATE_LOCK_INTERRUPT_CYCLE_ENABLED = new Builder("alluxio.master.backup.state.lock.interrupt.cycle.enabled").setDefaultValue(false).setDescription("This controls whether RPCs that are waiting/holding state-lock in shared-mode will be interrupted while state-lock is taken exclusively.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_STATE_LOCK_FORCED_DURATION = new Builder("alluxio.master.backup.state.lock.forced.duration").setDefaultValue("15min").setDescription("Exclusive locking of the state-lock will timeout after this duration is spent on forced phase.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_STATE_LOCK_INTERRUPT_CYCLE_INTERVAL = new Builder("alluxio.master.backup.state.lock.interrupt.cycle.interval").setDefaultValue("30sec").setDescription("The interval at which the RPCs that are waiting/holding state-lock in shared-mode will be interrupted while state-lock is taken exclusively.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BACKUP_SUSPEND_TIMEOUT = new Builder("alluxio.master.backup.suspend.timeout").setDefaultValue("1min").setDescription("Timeout for when suspend request is not followed by a backup request.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_ENABLED = new Builder("alluxio.master.daily.backup.enabled").setDefaultValue(false).setDescription("Whether or not to enable daily primary master metadata backup.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_FILES_RETAINED = new Builder("alluxio.master.daily.backup.files.retained").setDefaultValue(3).setDescription("The maximum number of backup files to keep in the backup directory.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_TIME = new Builder("alluxio.master.daily.backup.time").setDefaultValue("05:00").setDescription("Default UTC time for writing daily master metadata backups. The accepted time format is hour:minute which is based on a 24-hour clock (E.g., 05:30, 06:00, and 22:04). Backing up metadata requires a pause in master metadata changes, so please set this value to an off-peak time to avoid interfering with other users of the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SHELL_BACKUP_STATE_LOCK_GRACE_MODE = new Builder("alluxio.master.shell.backup.state.lock.grace.mode").setDefaultValue("TIMEOUT").setDescription("Grace mode helps taking the state-lock exclusively for backup with minimum disruption to existing RPCs. This low-impact locking phase is called grace-cycle. Two modes are supported: TIMEOUT/FORCED.TIMEOUT: Means exclusive locking will timeout if it cannot acquire the lockwith grace-cycle. FORCED: Means the state-lock will be taken forcefully if grace-cycle fails to acquire it. Forced phase might trigger interrupting of existing RPCs if it is enabled.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SHELL_BACKUP_STATE_LOCK_TRY_DURATION = new Builder("alluxio.master.shell.backup.state.lock.try.duration").setDefaultValue("1m").setDescription("The duration that controls how long the state-lock is tried within a single grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SHELL_BACKUP_STATE_LOCK_SLEEP_DURATION = new Builder("alluxio.master.shell.backup.state.lock.sleep.duration").setDefaultValue("0").setDescription("The duration that controls how long the lock waiter sleeps within a single grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SHELL_BACKUP_STATE_LOCK_TIMEOUT = new Builder("alluxio.master.shell.backup.state.lock.timeout").setDefaultValue("1m").setDescription("The max duration for a grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_STATE_LOCK_GRACE_MODE = new Builder("alluxio.master.daily.backup.state.lock.grace.mode").setDefaultValue("FORCED").setDescription("Grace mode helps taking the state-lock exclusively for backup with minimum disruption to existing RPCs. This low-impact locking phase is called grace-cycle. Two modes are supported: TIMEOUT/FORCED.TIMEOUT: Means exclusive locking will timeout if it cannot acquire the lockwith grace-cycle. FORCED: Means the state-lock will be taken forcefully if grace-cycle fails to acquire it. Forced phase might trigger interrupting of existing RPCs if it is enabled.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_STATE_LOCK_TRY_DURATION = new Builder("alluxio.master.daily.backup.state.lock.try.duration").setDefaultValue("30s").setDescription("The duration that controls how long the state-lock is tried within a single grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_STATE_LOCK_SLEEP_DURATION = new Builder("alluxio.master.daily.backup.state.lock.sleep.duration").setDefaultValue("10m").setDescription("The duration that controls how long the lock waiter sleeps within a single grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_DAILY_BACKUP_STATE_LOCK_TIMEOUT = new Builder("alluxio.master.daily.backup.state.lock.timeout").setDefaultValue("12h").setDescription("The max duration for a grace-cycle.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_BIND_HOST = new Builder("alluxio.master.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname that Alluxio master binds to.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_CLUSTER_METRICS_UPDATE_INTERVAL = new Builder("alluxio.master.cluster.metrics.update.interval").setDefaultValue("1min").setDescription("The interval for periodically updating the cluster level metrics.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).setIsHidden(true).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_PROXY_HOST = new Builder("alluxio.master.embedded.journal.bind.host").setDescription(String.format("Used to bind embedded journal servers to a proxied host.Proxy hostname will still make use of %s for bind port.", "alluxio.master.embedded.journal.port")).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_ADDRESSES = new Builder("alluxio.master.embedded.journal.addresses").setDescription(String.format("A comma-separated list of journal addresses for all masters in the cluster. The format is 'hostname1:port1,hostname2:port2,...'. When left unset, Alluxio uses ${%s}:${%s} by default", "alluxio.master.hostname", "alluxio.master.embedded.journal.port")).setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT = new Builder("alluxio.master.embedded.journal.election.timeout.min").setDescription("The min election timeout for the embedded journal.").setDefaultValue("10s").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT = new Builder("alluxio.master.embedded.journal.election.timeout.max").setDescription(String.format("The max election timeout for the embedded journal. When a random period between ${%s} and ${%s} elapses without a master receiving any messages, the master will attempt to become the primary Election timeout will be waited initially when the cluster is forming. So larger values for election timeout will cause longer start-up time. Smaller values might introduce instability to leadership.", "alluxio.master.embedded.journal.election.timeout.min", "alluxio.master.embedded.journal.election.timeout.max")).setDefaultValue("20s").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_CATCHUP_RETRY_WAIT = new Builder("alluxio.master.embedded.journal.catchup.retry.wait").setDefaultValue("1s").setDescription("Time for embedded journal leader to wait before retrying a catch up.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_ENTRY_SIZE_MAX = new Builder("alluxio.master.embedded.journal.entry.size.max").setDefaultValue("10MB").setDescription(String.format("The maximum single journal entry size allowed to be flushed. This value should be smaller than 30MB. If you update this value, please also update the value of %s ", "alluxio.master.embedded.journal.flush.size.max")).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_FLUSH_SIZE_MAX = new Builder("alluxio.master.embedded.journal.flush.size.max").setDefaultValue("160MB").setDescription("The maximum size in bytes of journal entries allowed in concurrent journal flushing (journal IO to standby masters and IO to local disks).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_PORT = new Builder("alluxio.master.embedded.journal.port").setDescription("The port to use for embedded journal communication with other masters.").setDefaultValue(19200).setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_RETRY_CACHE_EXPIRY_TIME = new Builder("alluxio.master.embedded.journal.retry.cache.expiry.time").setDefaultValue("60s").setDescription("The time for embedded journal server retry cache to expire. Setting a bigger value allows embedded journal server to cache the responses for a longer time in case of journal writer retries, but will take up more memory in master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_WRITE_LOCAL_FIRST_ENABLED = new Builder("alluxio.master.embedded.journal.write.local.first.enabled").setDefaultValue(true).setDescription("Whether the journal writer will attempt to write entry locally before falling back to a full remote raft client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_WRITE_REMOTE_ENABLED = new Builder("alluxio.master.embedded.journal.write.remote.enabled").setDefaultValue(false).setDescription("Whether the journal writer will write to remote master. This is disabled by default and should not be turned on unless Alluxio encounters issues with local journal write.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).setIsHidden(true).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_WRITE_TIMEOUT = new Builder("alluxio.master.embedded.journal.write.timeout").setDefaultValue("30sec").setDescription("Maximum time to wait for a write/flush on embedded journal.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_CHUNK_SIZE = new Builder("alluxio.master.embedded.journal.snapshot.replication.chunk.size").setDefaultValue("4MB").setDescription("The stream chunk size used by masters to replicate snapshots.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_TRANSPORT_REQUEST_TIMEOUT_MS = new Builder("alluxio.master.embedded.journal.transport.request.timeout.ms").setDefaultValue("5sec").setDescription("Timeout for requests between embedded journal masters.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_EMBEDDED_JOURNAL_TRANSPORT_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.master.embedded.journal.transport.max.inbound.message.size").setDefaultValue("100MB").setDescription("The maximum size of a message that can be sent to the embedded journal server node.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_ADDRESSES = new Builder("alluxio.master.rpc.addresses").setDescription("A list of comma-separated host:port RPC addresses where the client should look for masters when using multiple masters without Zookeeper. This property is not used when Zookeeper is enabled, since Zookeeper already stores the master addresses.").setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_JOURNAL_FLUSH_INTERVAL = new Builder("alluxio.master.file.access.time.journal.flush.interval").setDefaultValue("1h").setDescription("The minimum interval between files access time update journal entries get flushed asynchronously. Setting it to a non-positive value will make the the journal update synchronous. Asynchronous update reduces the performance impact of tracking access time but can lose some access time update when master stops unexpectedly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_UPDATE_PRECISION = new Builder("alluxio.master.file.access.time.update.precision").setDefaultValue("1d").setDescription("The file last access time is precise up to this value. Setting it toa non-positive value will update last access time on every file access operation.Longer precision will help reduce the performance impact of tracking access time by reduce the amount of metadata writes occur while reading the same group of files repetitively.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FILE_ACCESS_TIME_UPDATER_SHUTDOWN_TIMEOUT = new Builder("alluxio.master.file.access.time.updater.shutdown.timeout").setDefaultValue("1sec").setDescription("Maximum time to wait for access updater to stop on shutdown.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_FORMAT_FILE_PREFIX = new Builder("alluxio.master.format.file.prefix").setAlias("alluxio.master.format.file_prefix").setDefaultValue("_format_").setDescription("The file prefix of the file generated in the journal directory when the journal is formatted. The master will search for a file with this prefix when determining if the journal is formatted.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_STANDBY_HEARTBEAT_INTERVAL = new Builder("alluxio.master.standby.heartbeat.interval").setDefaultValue("2min").setDescription("The heartbeat interval between Alluxio primary master and standby masters.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE = new Builder("alluxio.master.metastore").setDefaultValue("ROCKS").setDescription("The type of metastore to use, either HEAP or ROCKS. The heap metastore keeps all metadata on-heap, while the rocks metastore stores some metadata on heap and some metadata on disk. The rocks metastore has the advantage of being able to support a large namespace (1 billion plus files) without needing a massive heap size.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_DIR = new Builder("alluxio.master.metastore.dir").setDefaultValue(String.format("${%s}/metastore", "alluxio.work.dir")).setDescription("The metastore work directory. Only some metastores need disk.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_EVICT_BATCH_SIZE = new Builder("alluxio.master.metastore.inode.cache.evict.batch.size").setDefaultValue("1000").setDescription("The batch size for evicting entries from the inode cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_HIGH_WATER_MARK_RATIO = new Builder("alluxio.master.metastore.inode.cache.high.water.mark.ratio").setDefaultValue("0.85").setDescription("The high water mark for the inode cache, as a ratio from high water mark to total cache size. If this is 0.85 and the max size is 10 million, the high water mark value is 8.5 million. When the cache reaches the high water mark, the eviction process will evict down to the low water mark.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_LOW_WATER_MARK_RATIO = new Builder("alluxio.master.metastore.inode.cache.low.water.mark.ratio").setDefaultValue("0.8").setDescription("The low water mark for the inode cache, as a ratio from low water mark to total cache size. If this is 0.8 and the max size is 10 million, the low water mark value is 8 million. When the cache reaches the high water mark, the eviction process will evict down to the low water mark.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_CACHE_MAX_SIZE = new Builder("alluxio.master.metastore.inode.cache.max.size").setDefaultValue(Math.min(0x3FFFFFFFL, Runtime.getRuntime().maxMemory() / 2000L / 2L)).setDescription("The number of inodes to cache on-heap. This only applies to off-heap metastores, e.g. ROCKS. Set this to 0 to disable the on-heap inode cache").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_ITERATION_CRAWLER_COUNT = new Builder("alluxio.master.metastore.inode.iteration.crawler.count").setDefaultSupplier(() -> Runtime.getRuntime().availableProcessors(), "Use {CPU core count} for enumeration").setDescription("The number of threads used during inode tree enumeration.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_ENUMERATOR_BUFFER_COUNT = new Builder("alluxio.master.metastore.inode.enumerator.buffer.count").setDefaultValue("10000").setDescription("The number of entries to buffer during read-ahead enumeration.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_ITERATOR_READAHEAD_SIZE = new Builder("alluxio.master.metastore.iterator.readahead.size").setDefaultValue("64MB").setDescription("The read-ahead size (in bytes) for metastore iterators.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METASTORE_INODE_INHERIT_OWNER_AND_GROUP = new Builder("alluxio.master.metastore.inode.inherit.owner.and.group").setDefaultValue("true").setDescription("Whether to inherit the owner/group from the parent when creating a new inode path if empty").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_SERVICE_THREADS = new Builder("alluxio.master.metrics.service.threads").setDefaultValue(5).setDescription("The number of threads in metrics master executor pool for parallel processing metrics submitted by workers or clients and update cluster metrics.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_TIME_SERIES_INTERVAL = new Builder("alluxio.master.metrics.time.series.interval").setDefaultValue("5min").setDescription("Interval for which the master records metrics information. This affects the granularity of the metrics graphed in the UI.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.master.network.max.inbound.message.size").setDefaultValue("100MB").setDescription("The maximum size of a message that can be sent to the Alluxio master").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL = new Builder("alluxio.master.lost.worker.file.detection.interval").setDefaultValue("5min").setDescription("The interval between Alluxio master detections to find lost files based on updates from Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_LOST_WORKER_DETECTION_INTERVAL = new Builder("alluxio.master.lost.worker.detection.interval").setDefaultValue("10sec").setAlias("alluxio.master.worker.heartbeat.interval").setDescription("The interval between Alluxio master detections to find lost workers based on updates from Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_HEARTBEAT_TIMEOUT = new Builder("alluxio.master.heartbeat.timeout").setDefaultValue("10min").setDescription("Timeout between leader master and standby master indicating a lost master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_HEAP_ENABLED = new Builder("alluxio.master.metrics.heap.enabled").setDefaultValue(true).setDescription("Enable master heap estimate metrics").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METRICS_FILE_SIZE_DISTRIBUTION_BUCKETS = new Builder("alluxio.master.metrics.file.size.distribution.buckets").setDefaultValue("1KB,1MB,10MB,100MB,1GB,10GB").setDescription("Master metrics file size buckets").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_HOSTNAME = new Builder("alluxio.master.hostname").setDescription("The hostname of Alluxio master.").setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_LOCK_POOL_INITSIZE = new Builder("alluxio.master.lock.pool.initsize").setDefaultValue(1000).setDescription("Initial size of the lock pool for master inodes.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_LOW_WATERMARK = new Builder("alluxio.master.lock.pool.low.watermark").setDefaultValue(500000).setDescription("Low watermark of lock pool size. When the size grows over the high watermark, a background thread will try to evict unused locks until the size reaches the low watermark.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_HIGH_WATERMARK = new Builder("alluxio.master.lock.pool.high.watermark").setDefaultValue(1000000).setDescription("High watermark of lock pool size. When the size grows over the high watermark, a background thread starts evicting unused locks from the pool.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOCK_POOL_CONCURRENCY_LEVEL = new Builder("alluxio.master.lock.pool.concurrency.level").setDefaultValue(100).setDescription("Maximum concurrency level for the lock pool").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_CATCHUP_PROTECT_ENABLED = new Builder("alluxio.master.journal.catchup.protect.enabled").setDefaultValue(true).setDescription("(Experimental) make sure the journal catchup finish before joining the quorum in fault tolerant mode when starting the master process and before the current master becoming the leader.This is added to prevent frequently leadership transition during heavy journal catchup stage. Catchup is only implemented in ufs journal with Zookeeper.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_EXIT_ON_DEMOTION = new Builder("alluxio.master.journal.exit.on.demotion").setDefaultValue(false).setDescription("(Experimental) When this flag is set to true, the master process may start as the primary or secondary in a quorum, but at any point in time after becoming a primary it is demoted to secondary, the process will shut down. This leaves the responsibility of restarting the master to re-join the quorum (e.g. in case of a journal failure on a particular node) to an external entity such as kubernetes or systemd.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_JOURNAL_MAX_CATCHUP_TIME = new Builder("alluxio.master.ufs.journal.max.catchup.time").setDefaultValue("10min").setDescription("The maximum time to wait for ufs journal catching up before listening to Zookeeper state change. This is added to prevent frequently leadership transition during heavy journal replay stage.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_BATCH_TIME_MS = new Builder("alluxio.master.journal.flush.batch.time").setAlias("alluxio.master.journal.flush.batch.time.ms").setDefaultValue("5ms").setDescription("Time to wait for batching journal writes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_TIMEOUT_MS = new Builder("alluxio.master.journal.flush.timeout").setAlias("alluxio.master.journal.flush.timeout.ms").setDefaultValue("5min").setDescription("The amount of time to keep retrying journal writes before giving up and shutting down the master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FLUSH_RETRY_INTERVAL = new Builder("alluxio.master.journal.retry.interval").setDefaultValue("1sec").setDescription("The amount of time to sleep between retrying journal flushes").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_FOLDER = new Builder("alluxio.master.journal.folder").setDefaultValue(String.format("${%s}/journal", "alluxio.work.dir")).setDescription("The path to store master journal logs. When using the UFS journal this could be a URI like hdfs://namenode:port/alluxio/journal. When using the embedded journal this must be a local path").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_INIT_FROM_BACKUP = new Builder("alluxio.master.journal.init.from.backup").setDescription("A uri for a backup to initialize the journal from. When the master becomes primary, if it sees that its journal is freshly formatted, it will restore its state from the backup. When running multiple masters, this property must be configured on all masters since it isn't known during startup which master will become the first primary.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_SPACE_MONITOR_PERCENT_FREE_THRESHOLD = new Builder("alluxio.master.journal.space.monitor.percent.free.threshold").setDefaultValue(10).setDescription("When the percent of free space on any disk which backs the journal falls below this percentage, begin logging warning messages to let administrators know the journal disk(s) may be running low on space.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TOLERATE_CORRUPTION = new Builder("alluxio.master.journal.tolerate.corruption").setDefaultValue(false).setDescription("Whether to tolerate master state corruption when leader master recovering from backup and standby master replaying journal. If enabled, errors from applying journal to master metadata will only be logged instead of forcing master to exit. This property should be used sparingly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setIsHidden(true).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TYPE = new Builder("alluxio.master.journal.type").setDefaultValue("EMBEDDED").setDescription("The type of journal to use. Valid options are UFS (store journal in UFS), EMBEDDED (use a journal embedded in the masters), and NOOP (do not use a journal)").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_LOG_SIZE_BYTES_MAX = new Builder("alluxio.master.journal.log.size.bytes.max").setDefaultValue("10MB").setDescription("If a log file is bigger than this value, it will rotate to next file.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_SPACE_MONITOR_INTERVAL = new Builder("alluxio.master.journal.space.monitor.interval").setDefaultValue("10min").setDescription(String.format("How often to check and update information on space utilization of the journal disk. This is currently only compatible with linux-basedsystems and when %s is configured to EMBEDDED", "alluxio.master.journal.type")).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS = new Builder("alluxio.master.journal.tailer.shutdown.quiet.wait.time").setAlias("alluxio.master.journal.tailer.shutdown.quiet.wait.time.ms").setDefaultValue("5sec").setDescription("Before the standby master shuts down its tailer thread, there should be no update to the leader master's journal in this specified time period.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TAILER_SLEEP_TIME_MS = new Builder("alluxio.master.journal.tailer.sleep.time").setAlias("alluxio.master.journal.tailer.sleep.time.ms").setDefaultValue("1sec").setDescription("Time for the standby master to sleep for when it cannot find anything new in leader master's journal.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES = new Builder("alluxio.master.journal.checkpoint.period.entries").setDefaultValue(2000000).setDescription("The number of journal entries to write before creating a new journal checkpoint.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_GC_PERIOD_MS = new Builder("alluxio.master.journal.gc.period").setAlias("alluxio.master.journal.gc.period.ms").setDefaultValue("2min").setDescription("Frequency with which to scan for and delete stale journal checkpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_GC_THRESHOLD_MS = new Builder("alluxio.master.journal.gc.threshold").setAlias("alluxio.master.journal.gc.threshold.ms").setDefaultValue("5min").setDescription("Minimum age for garbage collecting checkpoints.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_JOURNAL_TEMPORARY_FILE_GC_THRESHOLD_MS = new Builder("alluxio.master.journal.temporary.file.gc.threshold").setAlias("alluxio.master.journal.temporary.file.gc.threshold.ms").setDescription("Minimum age for garbage collecting temporary checkpoint files.").setDefaultValue("30min").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_KEYTAB_KEY_FILE = new Builder("alluxio.master.keytab.file").setDescription("Kerberos keytab file for Alluxio master.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_LOG_CONFIG_REPORT_HEARTBEAT_INTERVAL = new Builder("alluxio.master.log.config.report.heartbeat.interval").setDefaultValue("1h").setDescription("The interval for periodically logging the configuration check report.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_REPAIR = new Builder("alluxio.master.periodic.block.integrity.check.repair").setDefaultValue(false).setDescription("Whether the system should delete orphaned blocks found during the periodic integrity check. This is an experimental feature.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_INTERVAL = new Builder("alluxio.master.periodic.block.integrity.check.interval").setDefaultValue("1hr").setDescription("The period for the block integrity check, disabled if <= 0.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_CHECKER_INTERVAL_MS = new Builder("alluxio.master.persistence.checker.interval").setDefaultValue("1s").setDescription("How often the master checks persistence status for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_INITIAL_INTERVAL_MS = new Builder("alluxio.master.persistence.initial.interval").setDefaultValue("1s").setDescription("How often the  master persistence checker checks persistence status for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_MAX_INTERVAL_MS = new Builder("alluxio.master.persistence.max.interval").setDefaultValue("1hr").setDescription("Max wait interval for master persistence checker persistence status for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_MAX_TOTAL_WAIT_TIME_MS = new Builder("alluxio.master.persistence.max.total.wait.time").setDefaultValue("1day").setDescription("Total wait time for master persistence checker persistence status for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS = new Builder("alluxio.master.persistence.scheduler.interval").setDefaultValue("1s").setDescription("How often the master schedules persistence jobs for files written using ASYNC_THROUGH").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PERSISTENCE_BLACKLIST = new Builder("alluxio.master.persistence.blacklist").setDescription("Patterns to blacklist persist, comma separated, string match, no regex. This affects any async persist call (including ASYNC_THROUGH writes and CLI persist) but does not affect CACHE_THROUGH writes. Users may want to specify temporary files in the blacklist to avoid unnecessary I/O and errors. Some examples are `.staging` and `.tmp`.").setScope(Scope.MASTER).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_REPLICATION_CHECK_INTERVAL_MS = new Builder("alluxio.master.replication.check.interval").setDefaultValue("1min").setDescription("How often the master runs background process to check replication level for files").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_PRINCIPAL = new Builder("alluxio.master.principal").setDescription("Kerberos principal for Alluxio master.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_PORT = new Builder("alluxio.master.rpc.port").setAlias("alluxio.master.port").setDefaultValue(19998).setDescription("The port for Alluxio master's RPC service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_SERVING_THREAD_TIMEOUT = new Builder("alluxio.master.serving.thread.timeout").setDefaultValue("5m").setDescription("When stepping down from being the primary, the master will wait this long for the gRPC serving thread to stop before giving up and shutting down the server").setIsHidden(true).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_SKIP_ROOT_ACL_CHECK = new Builder("alluxio.master.skip.root.acl.check").setDefaultValue(false).setDescription("Skip root directory ACL check when restarting either from journal or backup. This is to allow users to restore a backup from a different cluster onto their current one without having to recreate the different clusters owner user.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).setIsHidden(true).setIgnoredSiteProperty(true).build();
    public static final PropertyKey MASTER_STARTUP_BLOCK_INTEGRITY_CHECK_ENABLED = new Builder("alluxio.master.startup.block.integrity.check.enabled").setDefaultValue(true).setDescription("Whether the system should be checked on startup for orphaned blocks (blocks having no corresponding files but still taking system resource due to various system failures). Orphaned blocks will be deleted during master startup if this property is true. This property is available since 1.7.1").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS = new Builder("alluxio.master.tieredstore.global.level0.alias").setDefaultValue("MEM").setDescription("The name of the highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS = new Builder("alluxio.master.tieredstore.global.level1.alias").setDefaultValue("SSD").setDescription("The name of the second highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS = new Builder("alluxio.master.tieredstore.global.level2.alias").setDefaultValue("HDD").setDescription("The name of the third highest storage tier in the entire system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_LEVELS = new Builder("alluxio.master.tieredstore.global.levels").setDefaultValue(3).setDescription("The total number of storage tiers in the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TIERED_STORE_GLOBAL_MEDIUMTYPE = new Builder("alluxio.master.tieredstore.global.mediumtype").setDefaultValue("MEM,SSD,HDD").setDescription("The list of medium types we support in the system.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_TTL_CHECKER_INTERVAL_MS = new Builder("alluxio.master.ttl.checker.interval").setAlias("alluxio.master.ttl.checker.interval.ms").setDefaultValue("1hour").setDescription("How often to periodically check and delete the files with expired ttl value.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_INTERVAL = new Builder("alluxio.master.ufs.active.sync.interval").setDefaultValue("30sec").setDescription("Time interval to periodically actively sync UFS").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_MAX_AGE = new Builder("alluxio.master.ufs.active.sync.max.age").setDefaultValue("10").setDescription("The maximum number of intervals we will wait to find a quiet period before we have to sync the directories").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_INITIAL_SYNC_ENABLED = new Builder("alluxio.master.ufs.active.sync.initial.sync.enabled").setDefaultValue("true").setDescription("Whether to perform an initial sync when we add a sync point").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).setIsHidden(true).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_MAX_ACTIVITIES = new Builder("alluxio.master.ufs.active.sync.max.activities").setDefaultValue("10").setDescription("Max number of changes in a directory to be considered for active syncing").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_THREAD_POOL_SIZE = new Builder("alluxio.master.ufs.active.sync.thread.pool.size").setDefaultSupplier(() -> Math.max(2, Runtime.getRuntime().availableProcessors() / 2), "The number of threads used by the active sync provider process active sync events. A higher number allow the master to use more CPU to process events from an event stream in parallel. If this value is too low, Alluxio may fall behind processing events. Defaults to # of processors / 2").setDescription("Max number of threads used to perform active sync").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_POLL_TIMEOUT = new Builder("alluxio.master.ufs.active.sync.poll.timeout").setDefaultValue("10sec").setDescription("Max time to wait before timing out a polling operation").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_EVENT_RATE_INTERVAL = new Builder("alluxio.master.ufs.active.sync.event.rate.interval").setDefaultValue("60sec").setDescription("The time interval we use to estimate incoming event rate").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_RETRY_TIMEOUT = new Builder("alluxio.master.ufs.active.sync.retry.timeout").setDefaultValue("10sec").setDescription("The max total duration to retry failed active sync operations.A large duration is useful to handle transient failures such as an unresponsive under storage but can lock the inode tree being synced longer.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_ACTIVE_SYNC_POLL_BATCH_SIZE = new Builder("alluxio.master.ufs.active.sync.poll.batch.size").setDefaultValue("1024").setDescription("The number of event batches that should be submitted together to a single thread for processing.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_BLOCK_LOCATION_CACHE_CAPACITY = new Builder("alluxio.master.ufs.block.location.cache.capacity").setDefaultValue(1000000).setDescription("The capacity of the UFS block locations cache. This cache caches UFS block locations for files that are persisted but not in Alluxio space, so that listing status of these files do not need to repeatedly ask UFS for their block locations. If this is set to 0, the cache will be disabled.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_MANAGED_BLOCKING_ENABLED = new Builder("alluxio.master.ufs.managed.blocking.enabled").setDescription("Whether to run UFS operations with managed blocking. This will provide RPC layer a hint that UFS is possible slow.The default is true for object stores and false for the rest. unless set explicitly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).setIsHidden(true).build();
    public static final PropertyKey MASTER_UFS_PATH_CACHE_CAPACITY = new Builder("alluxio.master.ufs.path.cache.capacity").setDefaultValue(100000).setDescription("The capacity of the UFS path cache. This cache is used to approximate the `ONCE` metadata load behavior (see `alluxio.user.file.metadata.load.type`). Larger caches will consume more memory, but will better approximate the `ONCE` behavior.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UFS_PATH_CACHE_THREADS = new Builder("alluxio.master.ufs.path.cache.threads").setDefaultValue(64).setDescription("The maximum size of the thread pool for asynchronously processing paths for the UFS path cache. Greater number of threads will decrease the amount of staleness in the async cache, but may impact performance. If this is set to 0, the cache will be disabled, and `alluxio.user.file.metadata.load.type=ONCE` will behave like `ALWAYS`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UPDATE_CHECK_ENABLED = new Builder("alluxio.master.update.check.enabled").setDefaultValue("true").setDescription("Whether to check for update availability.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UPDATE_CHECK_INTERVAL = new Builder("alluxio.master.update.check.interval").setDefaultValue("7day").setDescription("The interval to check for update availability.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED = new Builder("alluxio.master.unsafe.direct.persist.object.enabled").setDefaultValue(true).setDescription("When set to false, writing files using ASYNC_THROUGH or persist CLI with object stores as the UFS will first create temporary objects suffixed by \".alluxio.TIMESTAMP.tmp\" in the object store before committed to the final UFS path. When set to true, files will be put to the destination path directly in the object store without staging with a temp suffix. Enabling this optimization by directly persisting files can significantly improve the efficiency writing to object store by making less data copy as rename in object store can be slow, but leaving a short vulnerability window for undefined behavior if a file is written using ASYNC_THROUGH but renamed or removed before the async persist operation completes, while this same file path was reused for other new files in Alluxio.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WEB_BIND_HOST = new Builder("alluxio.master.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio master web UI binds to.").setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WEB_HOSTNAME = new Builder("alluxio.master.web.hostname").setDescription("The hostname of Alluxio Master web UI.").setScope(Scope.ALL).build();
    public static final PropertyKey MASTER_WEB_PORT = new Builder("alluxio.master.web.port").setDefaultValue(19999).setDescription("The port Alluxio web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WEB_JOURNAL_CHECKPOINT_WARNING_THRESHOLD_TIME = new Builder("alluxio.master.journal.checkpoint.warning.threshold.time").setDefaultValue(259200000L).setIsHidden(true).setDescription("The amount of time since the last checkpoint and when the number of journal entries is greater than alluxio.master.journal.checkpoint.period.entries which causes a warning to be displayed in the web UI ").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WHITELIST = new Builder("alluxio.master.whitelist").setDefaultValue("/").setDescription("A comma-separated list of prefixes of the paths which are cacheable, separated by semi-colons. Alluxio will try to cache the cacheable file when it is read for the first time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WORKER_CONNECT_WAIT_TIME = new Builder("alluxio.master.worker.connect.wait.time").setDefaultValue("5sec").setDescription("Alluxio master will wait a period of time after start up for all workers to register, before it starts accepting client requests. This property determines the wait time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WORKER_INFO_CACHE_REFRESH_TIME = new Builder("alluxio.master.worker.info.cache.refresh.time").setDefaultValue("10sec").setDescription("The worker information list will be refreshed after being cached for this time period. If the refresh time is too big, operations on the job servers or clients may fail because of the stale worker info. If it is too small, continuously updating worker information may case lock contention in the block master").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_WORKER_TIMEOUT_MS = new Builder("alluxio.master.worker.timeout").setAlias("alluxio.master.worker.timeout.ms").setDefaultValue("5min").setDescription("Timeout between master and worker indicating a lost worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_METADATA_SYNC_CONCURRENCY_LEVEL = new Builder("alluxio.master.metadata.sync.concurrency.level").setDefaultValue(6).setDescription("The maximum number of concurrent sync tasks running for a given sync operation").setScope(Scope.MASTER).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_METADATA_SYNC_EXECUTOR_POOL_SIZE = new Builder("alluxio.master.metadata.sync.executor.pool.size").setDefaultSupplier(() -> Runtime.getRuntime().availableProcessors(), "The total number of threads which can concurrently execute metadata sync operations.").setDescription("The number of threads used to execute all metadata syncoperations").setScope(Scope.MASTER).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_METADATA_SYNC_REPORT_FAILURE = new Builder("alluxio.master.metadata.sync.report.failure").setDescription("Report failure if any metadata sync fails").setScope(Scope.MASTER).setDefaultValue(true).setIsHidden(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_METADATA_SYNC_UFS_PREFETCH_POOL_SIZE = new Builder("alluxio.master.metadata.sync.ufs.prefetch.pool.size").setDefaultSupplier(() -> 10 * Runtime.getRuntime().availableProcessors(), "The number of threads which can concurrently fetch metadata from UFSes during a metadata sync operations").setDescription("The number of threads used to fetch UFS objects for all metadata syncoperations").setScope(Scope.MASTER).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_PARALLELISM = new Builder("alluxio.master.rpc.executor.parallelism").setDefaultSupplier(() -> 2 * Runtime.getRuntime().availableProcessors(), "2 * {CPU core count}").setDescription("The parallelism level of master RPC executor service .").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_MIN_RUNNABLE = new Builder("alluxio.master.rpc.executor.min.runnable").setDefaultValue(1).setDescription("the minimum allowed number of core threads not blocked. To ensure progress, when too few unblocked threads exist and unexecuted tasks may exist, new threads are constructed up to the value of alluxio.master.rpc.executor.max.pool.size. A value of 1 ensures liveness. A larger value might improve throughput but might also increase overhead.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_CORE_POOL_SIZE = new Builder("alluxio.master.rpc.executor.core.pool.size").setDefaultValue(0).setDescription("the number of threads to keep in thread pool of master RPC executor service. By default it is same as the parallelism level, but may be set to a larger value to reduce dynamic overhead if tasks regularly block. A smaller value (for example 0) is equivalent to the default.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_MAX_POOL_SIZE = new Builder("alluxio.master.rpc.executor.max.pool.size").setDefaultValue(500).setDescription("the maximum number of threads allowed for master RPC executor service. When the maximum is reached, attempts to replace blocked threads fail.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey MASTER_RPC_EXECUTOR_KEEPALIVE = new Builder("alluxio.master.rpc.executor.keepalive").setDefaultValue("60sec").setDescription("the keep alive time of a thread in master RPC executor servicelast used before this thread is terminated (and replaced if necessary).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey SECONDARY_MASTER_METASTORE_DIR = new Builder("alluxio.secondary.master.metastore.dir").setDefaultValue(String.format("${%s}/secondary-metastore", "alluxio.work.dir")).setDescription("The secondary master metastore work directory. Only some metastores need disk.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_FILE_SYSTEM_LISTSTATUS_RESULTS_PER_MESSAGE = new Builder("alluxio.master.filesystem.liststatus.result.message.length").setDefaultValue(10000).setDescription("Count of items on each list-status response message.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey WORKER_ALLOCATOR_CLASS = new Builder("alluxio.worker.allocator.class").setDefaultValue("alluxio.worker.block.allocator.MaxFreeAllocator").setDescription("The strategy that a worker uses to allocate space among storage directories in certain storage layer. Valid options include: `alluxio.worker.block.allocator.MaxFreeAllocator`, `alluxio.worker.block.allocator.GreedyAllocator`, `alluxio.worker.block.allocator.RoundRobinAllocator`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BIND_HOST = new Builder("alluxio.worker.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio's worker node binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_HEARTBEAT_INTERVAL_MS = new Builder("alluxio.worker.block.heartbeat.interval").setAlias("alluxio.worker.block.heartbeat.interval.ms").setDefaultValue("1sec").setDescription("The interval between block workers' heartbeats to update block status, storage health and other workers' information to Alluxio Master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS = new Builder("alluxio.worker.block.heartbeat.timeout").setAlias("alluxio.worker.block.heartbeat.timeout.ms").setDefaultValue(String.format("${%s}", "alluxio.worker.master.connect.retry.timeout")).setDescription("The timeout value of block workers' heartbeats. If the worker can't connect to master before this interval expires, the worker will exit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_CONTAINER_HOSTNAME = new Builder("alluxio.worker.container.hostname").setDescription("The container hostname if worker is running in a container.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_FOLDER = new Builder("alluxio.worker.data.folder").setDefaultValue("/alluxioworker/").setDescription("A relative path within each storage directory used as the data folder for Alluxio worker to put data for tiered store.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_FOLDER_PERMISSIONS = new Builder("alluxio.worker.data.folder.permissions").setDefaultValue("rwxrwxrwx").setDescription("The permission set for the worker data folder. If short circuit is used this folder should be accessible by all users (rwxrwxrwx).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_SERVER_DOMAIN_SOCKET_ADDRESS = new Builder("alluxio.worker.data.server.domain.socket.address").setDescription("The path to the domain socket. Short-circuit reads make use of a UNIX domain socket when this is set (non-empty). This is a special path in the file system that allows the client and the AlluxioWorker to communicate. You will need to set a path to this socket. The AlluxioWorker needs to be able to create the path. If alluxio.worker.data.server.domain.socket.as.uuid is set, the path should be the home directory for the domain socket. The full path for the domain socket with be {path}/{uuid}.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID = new Builder("alluxio.worker.data.server.domain.socket.as.uuid").setDefaultValue("false").setDescription("If true, the property alluxio.worker.data.server.domain.socket.addressis the path to the home directory for the domain socket and a unique identifier is used as the domain socket name. If false, the property is the absolute path to the UNIX domain socket.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey WORKER_DATA_TMP_FOLDER = new Builder("alluxio.worker.data.folder.tmp").setDefaultValue(".tmp_blocks").setDescription("A relative path in alluxio.worker.data.folder used to store the temporary data for uncommitted files.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_DATA_TMP_SUBDIR_MAX = new Builder("alluxio.worker.data.tmp.subdir.max").setDefaultValue(1024).setDescription("The maximum number of sub-directories allowed to be created in ${alluxio.worker.data.tmp.folder}.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    @Deprecated(message="Use WORKER_BLOCK_ANNOTATOR_CLASS instead.")
    public static final PropertyKey WORKER_EVICTOR_CLASS = new Builder("alluxio.worker.evictor.class").setDescription("The strategy that a worker uses to evict block files when a storage layer runs out of space. Valid options include `alluxio.worker.block.evictor.LRFUEvictor`, `alluxio.worker.block.evictor.GreedyEvictor`, `alluxio.worker.block.evictor.LRUEvictor`, `alluxio.worker.block.evictor.PartialLRUEvictor`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_ANNOTATOR_CLASS = new Builder("alluxio.worker.block.annotator.class").setDefaultValue("alluxio.worker.block.annotator.LRUAnnotator").setDescription("The strategy that a worker uses to annotate blocks in order to have an ordered view of them during internalmanagement tasks such as eviction and promotion/demotion.  Valid options include: `alluxio.worker.block.annotator.LRFUAnnotator`, `alluxio.worker.block.annotator.LRUAnnotator`, ").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_ANNOTATOR_LRFU_ATTENUATION_FACTOR = new Builder("alluxio.worker.block.annotator.lrfu.attenuation.factor").setDefaultValue(2.0).setDescription("A attenuation factor in [2, INF) to control the behavior of LRFU annotator.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_ANNOTATOR_LRFU_STEP_FACTOR = new Builder("alluxio.worker.block.annotator.lrfu.step.factor").setDefaultValue(0.25).setDescription("A factor in [0, 1] to control the behavior of LRFU: smaller value makes LRFU more similar to LFU; and larger value makes LRFU closer to LRU.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FUSE_ENABLED = new Builder("alluxio.worker.fuse.enabled").setDefaultValue(false).setDescription("If true, launch worker embedded Fuse application.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FUSE_MOUNT_ALLUXIO_PATH = new Builder("alluxio.worker.fuse.mount.alluxio.path").setDefaultValue("/").setDescription(String.format("The Alluxio path to mount to the given Fuse mount point configured by %s in this worker.", "alluxio.worker.fuse.mount.point")).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FUSE_MOUNT_OPTIONS = new Builder("alluxio.worker.fuse.mount.options").setDescription("The platform specific Fuse mount options to mount the given Fuse mount point. If multiple mount options are provided, separate them with comma.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FUSE_MOUNT_POINT = new Builder("alluxio.worker.fuse.mount.point").setDefaultValue("/mnt/alluxio-fuse").setDescription("The absolute local filesystem path that this worker will mount Alluxio path to.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_BACKOFF_STRATEGY = new Builder("alluxio.worker.management.backoff.strategy").setDefaultValue("ANY").setDescription("Defines the backoff scope respected by background tasks. Supported values are ANY / DIRECTORY. ANY: Management tasks will backoff from worker when there is any user I/O.This mode will ensure low management task overhead in order to favor immediate user I/O performance. However, making progress on management tasks will require quite periods on the worker.DIRECTORY: Management tasks will backoff from directories with ongoing user I/O.This mode will give better chance of making progress on management tasks.However, immediate user I/O throughput might be reduced due to increased management task activity.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_LOAD_DETECTION_COOL_DOWN_TIME = new Builder("alluxio.worker.management.load.detection.cool.down.time").setDefaultValue("10sec").setDescription("Management tasks will not run for this long after load detected. Any user I/O will still register as a load for this period of time after it is finished. Short durations might cause interference between user I/O and background tier management tasks. Long durations might cause starvation for background tasks.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_ALIGN_RESERVED_BYTES = new Builder("alluxio.worker.management.tier.align.reserved.bytes").setDefaultValue("1GB").setDescription("The amount of space that is reserved from each storage directory for internal management tasks.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TASK_THREAD_COUNT = new Builder("alluxio.worker.management.task.thread.count").setDefaultSupplier(() -> Runtime.getRuntime().availableProcessors(), "Use {CPU core count} threads for all management tasks").setDescription("The number of threads for management task executor").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_BLOCK_TRANSFER_CONCURRENCY_LIMIT = new Builder("alluxio.worker.management.block.transfer.concurrency.limit").setDefaultSupplier(() -> Math.max(1, Runtime.getRuntime().availableProcessors() / 2), "Use {CPU core count}/2 threads block transfer").setDescription("Puts a limit to how many block transfers are executed concurrently during management.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_ALIGN_ENABLED = new Builder("alluxio.worker.management.tier.align.enabled").setDefaultValue(true).setDescription("Whether to align tiers based on access pattern.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_PROMOTE_ENABLED = new Builder("alluxio.worker.management.tier.promote.enabled").setDefaultValue(true).setDescription("Whether to promote blocks to higher tiers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_SWAP_RESTORE_ENABLED = new Builder("alluxio.worker.management.tier.swap.restore.enabled").setDefaultValue(true).setDescription("Whether to run management swap-restore task when tier alignment cannot make progress.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_ALIGN_RANGE = new Builder("alluxio.worker.management.tier.align.range").setDefaultValue(100).setDescription("Maximum number of blocks to consider from one tier for a single alignment task.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_PROMOTE_RANGE = new Builder("alluxio.worker.management.tier.promote.range").setDefaultValue(100).setDescription("Maximum number of blocks to consider from one tier for a single promote task.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MANAGEMENT_TIER_PROMOTE_QUOTA_PERCENT = new Builder("alluxio.worker.management.tier.promote.quota.percent").setDefaultValue(90).setDescription("Max percentage of each tier that could be used for promotions. Promotions will be stopped to a tier once its used space go over this value. (0 means never promote, and, 100 means always promote.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_FREE_SPACE_TIMEOUT = new Builder("alluxio.worker.free.space.timeout").setDefaultValue("10sec").setDescription("The duration for which a worker will wait for eviction to make space available for a client write request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_HOSTNAME = new Builder("alluxio.worker.hostname").setDescription("The hostname of Alluxio worker.").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_KEYTAB_FILE = new Builder("alluxio.worker.keytab.file").setDescription("Kerberos keytab file for Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MASTER_CONNECT_RETRY_TIMEOUT = new Builder("alluxio.worker.master.connect.retry.timeout").setDescription("Retry period before workers give up on connecting to master and exit.").setDefaultValue("1hour").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_MASTER_PERIODICAL_RPC_TIMEOUT = new Builder("alluxio.worker.master.periodical.rpc.timeout").setDefaultValue("5min").setDescription("Timeout for periodical RPC between workers and the leading master. This property is added to prevent workers from hanging in periodical RPCs with previous leading master during flaky network situations. If the timeout is too short, periodical RPCs may not have enough time to get response from the leading master during heavy cluster load and high network latency.").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_RAMDISK_SIZE = new Builder("alluxio.worker.ramdisk.size").setAlias("alluxio.worker.memory.size").setDefaultSupplier(() -> {
        try {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return operatingSystemMXBean.getTotalPhysicalMemorySize() * 2L / 3L;
        }
        catch (Throwable e) {
            return "1GB";
        }
    }, "2/3 of total system memory, or 1GB if system memory size cannot be determined").setDescription("The allocated memory for each worker node's ramdisk(s). It is recommended to set this value explicitly.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_ASYNC_CACHE_MANAGER_QUEUE_MAX = new Builder("alluxio.worker.network.async.cache.manager.queue.max").setDefaultValue(512).setDescription("The maximum number of outstanding async caching requests to cache blocks in each data server").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_ASYNC_CACHE_MANAGER_THREADS_MAX = new Builder("alluxio.worker.network.async.cache.manager.threads.max").setDefaultSupplier(() -> 2 * Runtime.getRuntime().availableProcessors(), "2 * {CPU core count}").setDescription("The maximum number of threads used to cache blocks asynchronously in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_BLOCK_READER_THREADS_MAX = new Builder("alluxio.worker.network.block.reader.threads.max").setDefaultValue(2048).setDescription("The maximum number of threads used to read blocks in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_BLOCK_WRITER_THREADS_MAX = new Builder("alluxio.worker.network.block.writer.threads.max").setDefaultValue(1024).setDescription("The maximum number of threads used to write blocks in the data server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.worker.network.writer.buffer.size.messages").setDefaultValue(8).setDescription("When a client writes to a remote worker, the maximum number of data messages to buffer by the server for each request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_FLOWCONTROL_WINDOW = new Builder("alluxio.worker.network.flowcontrol.window").setDefaultValue("2MB").setDescription("The HTTP2 flow control window used by worker gRPC connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_KEEPALIVE_TIME_MS = new Builder("alluxio.worker.network.keepalive.time").setDefaultValue("30sec").setDescription("The amount of time for data server (for block reads and block writes) to wait for a response before pinging the client to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_KEEPALIVE_TIMEOUT_MS = new Builder("alluxio.worker.network.keepalive.timeout").setDefaultValue("30sec").setDescription("The maximum time for a data server (for block reads and block writes) to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.worker.network.max.inbound.message.size").setDefaultValue("4MB").setDescription("The max inbound message size used by worker gRPC connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_BOSS_THREADS = new Builder("alluxio.worker.network.netty.boss.threads").setDefaultValue(1).setDescription("How many threads to use for accepting new requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_CHANNEL = new Builder("alluxio.worker.network.netty.channel").setDescription("Netty channel type: NIO or EPOLL. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).setDefaultValue("EPOLL").build();
    public static final PropertyKey WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD = new Builder("alluxio.worker.network.netty.shutdown.quiet.period").setDefaultValue("2sec").setDescription("The quiet period. When the netty server is shutting down, it will ensure that no RPCs occur during the quiet period. If an RPC occurs, then the quiet period will restart before shutting down the netty server.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WATERMARK_HIGH = new Builder("alluxio.worker.network.netty.watermark.high").setDefaultValue("32KB").setDescription("Determines how many bytes can be in the write queue before switching to non-writable.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WATERMARK_LOW = new Builder("alluxio.worker.network.netty.watermark.low").setDefaultValue("8KB").setDescription("Once the high watermark limit is reached, the queue must be flushed down to the low watermark before switching back to writable.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_NETTY_WORKER_THREADS = new Builder("alluxio.worker.network.netty.worker.threads").setDefaultValue(0).setDescription("How many threads to use for processing requests. Zero defaults to #cpuCores * 2.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_READER_BUFFER_SIZE_BYTES = new Builder("alluxio.worker.network.reader.buffer.size").setDefaultValue("4MB").setDescription("When a client reads from a remote worker, the maximum amount of data not received by client allowed before the worker pauses sending more data. If this value is lower than read chunk size, read performance may be impacted as worker waits more often for buffer to free up. Higher value will increase the memory consumed by each read request.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_READER_MAX_CHUNK_SIZE_BYTES = new Builder("alluxio.worker.network.reader.max.chunk.size.bytes").setDefaultValue("2MB").setDescription("When a client read from a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_SHUTDOWN_TIMEOUT = new Builder("alluxio.worker.network.shutdown.timeout").setDefaultValue("15sec").setDescription("Maximum amount of time to wait until the worker gRPC server is shutdown (regardless of the quiet period).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_NETWORK_ZEROCOPY_ENABLED = new Builder("alluxio.worker.network.zerocopy.enabled").setDefaultValue(true).setDescription("Whether zero copy is enabled on worker when processing data streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_REMOTE_IO_SLOW_THRESHOLD = new Builder("alluxio.worker.remote.io.slow.threshold").setDefaultValue("10s").setDescription("The time threshold for when a worker remote IO (read or write) of a single buffer is considered slow. When slow IO occurs, it is logged by a sampling logger.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_BLOCK_MASTER_CLIENT_POOL_SIZE = new Builder("alluxio.worker.block.master.client.pool.size").setDefaultValue(11).setDescription("The block master client pool size on the Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_PRINCIPAL = new Builder("alluxio.worker.principal").setDescription("Kerberos principal for Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_REVIEWER_PROBABILISTIC_SOFTLIMIT_BYTES = new Builder("alluxio.worker.reviewer.probabilistic.softlimit.bytes").setDefaultValue("256MB").setDescription("This is used by the `alluxio.worker.block.reviewer.ProbabilisticBufferReviewer`. We attempt to leave a buffer in each storage directory. When the free space in a certain storage directory on the worker falls below this soft limit, the chance that the Reviewer accepts new blocks into this directory goes down. This chance keeps falling linearly until it reaches 0, when the available space reaches the hard limit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_REVIEWER_PROBABILISTIC_HARDLIMIT_BYTES = new Builder("alluxio.worker.reviewer.probabilistic.hardlimit.bytes").setDefaultValue("64MB").setDescription("This is used by the `alluxio.worker.block.reviewer.ProbabilisticBufferReviewer`. When the free space in a storage dir falls below this hard limit, the ProbabilisticBufferReviewer will stop accepting new blocks into it.This is because we may load more data into existing blocks in the directory and their sizes may expand.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_REVIEWER_CLASS = new Builder("alluxio.worker.reviewer.class").setDefaultValue("alluxio.worker.block.reviewer.ProbabilisticBufferReviewer").setDescription("(Experimental) The API is subject to change in the future.The strategy that a worker uses to review space allocation in the Allocator. Each time a block allocation decision is made by the Allocator, the Reviewer will review the decision and rejects it,if the allocation does not meet certain criteria of the Reviewer.The Reviewer prevents the worker to make a bad block allocation decision.Valid options include:`alluxio.worker.block.reviewer.ProbabilisticBufferReviewer`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_RPC_PORT = new Builder("alluxio.worker.rpc.port").setAlias("alluxio.worker.port").setDefaultValue(29999).setDescription("The port for Alluxio worker's RPC service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey WORKER_SESSION_TIMEOUT_MS = new Builder("alluxio.worker.session.timeout").setAlias("alluxio.worker.session.timeout.ms").setDefaultValue("1min").setDescription("Timeout between worker and client connection indicating a lost session connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_STORAGE_CHECKER_ENABLED = new Builder("alluxio.worker.storage.checker.enabled").setDefaultValue(true).setDescription("Whether periodic storage health checker is enabled on Alluxio workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_BLOCK_LOCK_READERS = new Builder("alluxio.worker.tieredstore.block.lock.readers").setDefaultValue(1000).setDescription("The max number of concurrent readers for a block lock.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_BLOCK_LOCKS = new Builder("alluxio.worker.tieredstore.block.locks").setDefaultValue(1000).setDescription("Total number of block locks for an Alluxio block worker. Larger value leads to finer locking granularity, but uses more space.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_FREE_AHEAD_BYTES = new Builder("alluxio.worker.tieredstore.free.ahead.bytes").setDefaultValue(0).setDescription("Amount to free ahead when worker storage is full. Higher values will help decrease CPU utilization under peak storage. Lower values will increase storage utilization.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 0).setDefaultValue("MEM").setDescription("The alias of the top storage tier on this worker. It must match one of the global storage tiers from the master configuration. We disable placing an alias lower in the global hierarchy before an alias with a higher position on the worker hierarchy. So by default, SSD cannot come before MEM on any worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 0).setDefaultSupplier(() -> OSUtils.isLinux() ? "/mnt/ramdisk" : "/Volumes/ramdisk", "/mnt/ramdisk on Linux, /Volumes/ramdisk on OSX").setDescription("A comma-separated list of paths (eg., /mnt/ramdisk1,/mnt/ramdisk2,/mnt/ssd/alluxio/cache1) of storage directories for the top storage tier. Note that for MacOS, the root directory should be `/Volumes/` and not `/mnt/`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 0).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(0))).setDescription(String.format("A comma-separated list of media types (e.g., \"MEM,MEM,SSD\") for each storage directory on the top storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 0).setDefaultValue(String.format("${%s}", "alluxio.worker.ramdisk.size")).setDescription(String.format("A comma-separated list of capacities (e.g., \"500MB,500MB,5GB\") for each storage directory on the top storage tier specified by %s. For any \"MEM\"-type media (i.e, the ramdisks), this value should be set equivalent to the value specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH.mName, "alluxio.worker.ramdisk.size")).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 0).setDefaultValue(0.95).setDescription("The high watermark of the space in the top storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL0_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 0).setDefaultValue(0.7).setDescription("The low watermark of the space in the top storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 1).setDescription("The alias of the second storage tier on this worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 1).setDescription("A comma-separated list of paths (eg., /mnt/ssd/alluxio/cache2,/mnt/ssd/alluxio/cache3,/mnt/hdd/alluxio/cache1) of storage directories for the second storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 1).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(1))).setDescription(String.format("A list of media types (e.g., \"SSD,SSD,HDD\") for each storage directory on the second storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL1_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 1).setDescription(String.format("A comma-separated list of capacities (e.g., \"5GB,5GB,50GB\") for each storage directory on the second storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL1_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 1).setDescription("The high watermark of the space in the second storage tier (a value between 0 and 1).").setDefaultValue(0.95).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL1_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 1).setDefaultValue(0.7).setDescription("The low watermark of the space in the second storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_ALIAS = new Builder(Template.WORKER_TIERED_STORE_LEVEL_ALIAS, 2).setDescription("The alias of the third storage tier on this worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_PATH = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_PATH, 2).setDescription("A comma-separated list of paths (eg., /mnt/ssd/alluxio/cache4,/mnt/hdd/alluxio/cache2,/mnt/hdd/alluxio/cache3) of storage directories for the third storage tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_MEDIUMTYPE = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE, 2).setDefaultValue(String.format("${%s}", Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(2))).setDescription(String.format("A list of media types (e.g., \"SSD,HDD,HDD\") for each storage directory on the third storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL2_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_DIRS_QUOTA = new Builder(Template.WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA, 2).setDescription(String.format("A comma-separated list of capacities (e.g., \"5GB,50GB,50GB\") for each storage directory on the third storage tier specified by %s.", PropertyKey.WORKER_TIERED_STORE_LEVEL2_DIRS_PATH.mName)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_HIGH_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO, 2).setDefaultValue(0.95).setDescription("The high watermark of the space in the third storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVEL2_LOW_WATERMARK_RATIO = new Builder(Template.WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO, 2).setDefaultValue(0.7).setDescription("The low watermark of the space in the third storage tier (a value between 0 and 1).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_TIERED_STORE_LEVELS = new Builder("alluxio.worker.tieredstore.levels").setDefaultValue(1).setDescription("The number of storage tiers on the worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_BIND_HOST = new Builder("alluxio.worker.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio worker's web server binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_HOSTNAME = new Builder("alluxio.worker.web.hostname").setDescription("The hostname Alluxio worker's web UI binds to.").setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_WEB_PORT = new Builder("alluxio.worker.web.port").setDefaultValue(30000).setDescription("The port Alluxio worker's web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_BLOCK_OPEN_TIMEOUT_MS = new Builder("alluxio.worker.ufs.block.open.timeout").setAlias("alluxio.worker.ufs.block.open.timeout.ms").setDefaultValue("5min").setDescription("Timeout to open a block from UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_ENABLED = new Builder("alluxio.worker.ufs.instream.cache.enabled").setDefaultValue("true").setDescription("Enable caching for seekable under storage input stream, so that subsequent seek operations on the same file will reuse the cached input stream. This will improve position read performance as the open operations of some under file system would be expensive. The cached input stream would be stale, when the UFS file is modified without notifying alluxio. ").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_EXPIRARTION_TIME = new Builder("alluxio.worker.ufs.instream.cache.expiration.time").setDefaultValue("5min").setDescription("Cached UFS instream expiration time.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey WORKER_UFS_INSTREAM_CACHE_MAX_SIZE = new Builder("alluxio.worker.ufs.instream.cache.max.size").setDefaultValue("5000").setDescription("The max entries in the UFS instream cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey PROXY_S3_WRITE_TYPE = new Builder("alluxio.proxy.s3.writetype").setDefaultValue("CACHE_THROUGH").setDescription("Write type when creating buckets and objects through S3 API. Valid options are `MUST_CACHE` (write will only go to Alluxio and must be stored in Alluxio), `CACHE_THROUGH` (try to cache, write to UnderFS synchronously), `ASYNC_THROUGH` (try to cache, write to UnderFS asynchronously), `THROUGH` (no cache, write to UnderFS synchronously).").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_S3_DELETE_TYPE = new Builder("alluxio.proxy.s3.deletetype").setDefaultValue("ALLUXIO_AND_UFS").setDescription(String.format("Delete type when deleting buckets and objects through S3 API. Valid options are `%s` (delete both in Alluxio and UFS), `%s` (delete only the buckets or objects in Alluxio namespace).", "ALLUXIO_AND_UFS", "ALLUXIO_ONLY")).setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_S3_MULTIPART_TEMPORARY_DIR_SUFFIX = new Builder("alluxio.proxy.s3.multipart.temporary.dir.suffix").setDefaultValue("_s3_multipart_tmp").setDescription("Suffix for the directory which holds parts during a multipart upload.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.SERVER).build();
    public static final PropertyKey PROXY_STREAM_CACHE_TIMEOUT_MS = new Builder("alluxio.proxy.stream.cache.timeout").setAlias("alluxio.proxy.stream.cache.timeout.ms").setDefaultValue("1hour").setDescription("The timeout for the input and output streams cache eviction in the proxy.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_BIND_HOST = new Builder("alluxio.proxy.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname that the Alluxio proxy's web server runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_HOSTNAME = new Builder("alluxio.proxy.web.hostname").setDescription("The hostname Alluxio proxy's web UI binds to.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey PROXY_WEB_PORT = new Builder("alluxio.proxy.web.port").setDefaultValue(39999).setDescription("The port Alluxio proxy's web UI runs on.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.NONE).build();
    public static final PropertyKey LOCALITY_ORDER = new Builder("alluxio.locality.order").setDefaultValue(String.format("%s,%s", "node", "rack")).setDescription("Ordering of locality tiers").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey LOCALITY_SCRIPT = new Builder("alluxio.locality.script").setDefaultValue("alluxio-locality.sh").setDescription("A script to determine tiered identity for locality checking").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey LOCALITY_TIER_NODE = new Builder(Template.LOCALITY_TIER, "node").setDescription("Value to use for determining node locality").setScope(Scope.ALL).build();
    public static final PropertyKey LOCALITY_TIER_RACK = new Builder(Template.LOCALITY_TIER, "rack").setDescription("Value to use for determining rack locality").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey LOCALITY_COMPARE_NODE_IP = new Builder("alluxio.locality.compare.node.ip").setDefaultValue(false).setDescription("Whether try to resolve the node IP address for locality checking").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey LOGSERVER_LOGS_DIR = new Builder("alluxio.logserver.logs.dir").setDefaultValue(String.format("${%s}/logs", "alluxio.work.dir")).setDescription("Default location for remote log files.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_HOSTNAME = new Builder("alluxio.logserver.hostname").setDescription("The hostname of Alluxio logserver.").setIgnoredSiteProperty(true).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_PORT = new Builder("alluxio.logserver.port").setDefaultValue(45600).setDescription("Default port of logserver to receive logs from alluxio servers.").setIgnoredSiteProperty(true).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_THREADS_MAX = new Builder("alluxio.logserver.threads.max").setDefaultValue(2048).setDescription("The maximum number of threads used by logserver to service logging requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey LOGSERVER_THREADS_MIN = new Builder("alluxio.logserver.threads.min").setDefaultValue(512).setDescription("The minimum number of threads used by logserver to service logging requests.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MIN = new Builder("alluxio.user.block.master.client.pool.size.min").setDefaultValue(0).setDescription("The minimum number of block master clients cached in the block master client pool. For long running processes, this should be set to zero.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX = new Builder("alluxio.user.block.master.client.pool.size.max").setDefaultValue(500).setDescription("The maximum number of block master clients cached in the block master client pool.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setAlias("alluxio.user.block.master.client.threads").build();
    public static final PropertyKey USER_BLOCK_MASTER_CLIENT_POOL_GC_INTERVAL_MS = new Builder("alluxio.user.block.master.client.pool.gc.interval").setDefaultValue("120sec").setDescription("The interval at which block master client GC checks occur.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_MASTER_CLIENT_POOL_GC_THRESHOLD_MS = new Builder("alluxio.user.block.master.client.pool.gc.threshold").setDefaultValue("120sec").setDescription("A block master client is closed if it has been idle for more than this threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_POOL_MIN = new Builder("alluxio.user.block.worker.client.pool.min").setDefaultValue(0).setDescription("The minimum number of block worker clients cached in the block worker client pool.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setIsHidden(true).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_POOL_MAX = new Builder("alluxio.user.block.worker.client.pool.max").setDefaultValue(1024).setDescription("The maximum number of block worker clients cached in the block worker client pool.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setAlias("alluxio.user.block.worker.client.pool.size").build();
    public static final PropertyKey USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = new Builder("alluxio.user.block.worker.client.pool.gc.threshold").setDefaultValue("300sec").setDescription("A block worker client is closed if it has been idle for more than this threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES = new Builder("alluxio.user.block.remote.read.buffer.size.bytes").setDefaultValue("8MB").setDescription("The size of the file buffer to read data from remote Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setIsHidden(true).build();
    public static final PropertyKey USER_CONF_SYNC_INTERVAL = new Builder("alluxio.user.conf.sync.interval").setDefaultValue("1min").setDescription("The time period of client master heartbeat to update the configuration if necessary from meta master.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_MAX = new Builder("alluxio.user.file.replication.max").setDefaultValue(-1).setDescription("The target max replication level of a file in Alluxio space. Setting this property to a negative value means no upper limit.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_MIN = new Builder("alluxio.user.file.replication.min").setDefaultValue(0).setDescription("The target min replication level of a file in Alluxio space.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_REPLICATION_DURABLE = new Builder("alluxio.user.file.replication.durable").setDefaultValue(1).setDescription("The target replication level of a file created by ASYNC_THROUGH writesbefore this file is persisted.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_SEQUENTIAL_PREAD_THRESHOLD = new Builder("alluxio.user.file.sequential.pread.threshold").setDefaultValue("2MB").setDescription("An upper bound on the client buffer size for positioned read to hint at the sequential nature of reads. For reads with a buffer size greater than this threshold, the read op is treated to be sequential and the worker may handle the read differently. For instance, cold reads from the HDFS ufs may use a different HDFS client API.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_TARGET_MEDIA = new Builder("alluxio.user.file.target.media").setDescription("Preferred media type while storing file's blocks.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_SIZE_BYTES_DEFAULT = new Builder("alluxio.user.block.size.bytes.default").setDefaultValue("64MB").setDescription("Default block size for Alluxio files.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_READ_RETRY_SLEEP_MIN = new Builder("alluxio.user.block.read.retry.sleep.base").setDefaultValue("250ms").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_READ_RETRY_SLEEP_MAX = new Builder("alluxio.user.block.read.retry.sleep.max").setDefaultValue("2sec").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_READ_RETRY_MAX_DURATION = new Builder("alluxio.user.block.read.retry.max.duration").setDefaultValue("2min").build();
    public static final PropertyKey USER_CONF_CLUSTER_DEFAULT_ENABLED = new Builder("alluxio.user.conf.cluster.default.enabled").setDefaultValue(true).setDescription("When this property is true, an Alluxio client will load the default values of cluster-wide configuration and path-specific configuration set by Alluxio master.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_DATE_FORMAT_PATTERN = new Builder("alluxio.user.date.format.pattern").setDefaultValue("MM-dd-yyyy HH:mm:ss:SSS").setDescription("Display formatted date in cli command and web UI by given date format pattern.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_BUFFER_BYTES = new Builder("alluxio.user.file.buffer.bytes").setDefaultValue("8MB").setDescription("The size of the file buffer to use for file system reads/writes.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_RESERVED_BYTES = new Builder("alluxio.user.file.reserved.bytes").setDefaultValue(String.format("${%s}", "alluxio.user.block.size.bytes.default")).setDescription("The size to reserve on workers for file system writes.Using smaller value will improve concurrency for writes smaller than block size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY = new Builder("alluxio.user.file.copyfromlocal.block.location.policy.class").setDefaultValue("alluxio.client.block.policy.RoundRobinPolicy").setDescription("The default location policy for choosing workers for writing a file's blocks using copyFromLocal command.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_DELETE_UNCHECKED = new Builder("alluxio.user.file.delete.unchecked").setDefaultValue(false).setDescription("Whether to check if the UFS contents are in sync with Alluxio before attempting to delete persisted directories recursively.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_MASTER_CLIENT_POOL_SIZE_MIN = new Builder("alluxio.user.file.master.client.pool.size.min").setDefaultValue(0).setDescription("The minimum number of fs master clients cached in the fs master client pool. For long running processes, this should be set to zero.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX = new Builder("alluxio.user.file.master.client.pool.size.max").setDefaultValue(500).setDescription("The maximum number of fs master clients cached in the fs master client pool.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setAlias("alluxio.user.file.master.client.threads").build();
    public static final PropertyKey USER_FILE_MASTER_CLIENT_POOL_GC_INTERVAL_MS = new Builder("alluxio.user.file.master.client.pool.gc.interval").setDefaultValue("120sec").setDescription("The interval at which file system master client GC checks occur.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_MASTER_CLIENT_POOL_GC_THRESHOLD_MS = new Builder("alluxio.user.file.master.client.pool.gc.threshold").setDefaultValue("120sec").setDescription("A fs master client is closed if it has been idle for more than this threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_METADATA_LOAD_TYPE = new Builder("alluxio.user.file.metadata.load.type").setDefaultValue("ONCE").setDescription("The behavior of loading metadata from UFS. When information about a path is requested and the path does not exist in Alluxio, metadata can be loaded from the UFS. Valid options are `ALWAYS`, `NEVER`, and `ONCE`. `ALWAYS` will always access UFS to see if the path exists in the UFS. `NEVER` will never consult the UFS. `ONCE` will access the UFS the \"first\" time (according to a cache), but not after that. This parameter is ignored if a metadata sync is performed, via the parameter \"alluxio.user.file.metadata.sync.interval\"").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_METADATA_SYNC_INTERVAL = new Builder("alluxio.user.file.metadata.sync.interval").setDefaultValue("-1").setDescription("The interval for syncing UFS metadata before invoking an operation on a path. -1 means no sync will occur. 0 means Alluxio will always sync the metadata of the path before an operation. If you specify a time interval, Alluxio will (best effort) not re-sync a path within that time interval. Syncing the metadata for a path must interact with the UFS, so it is an expensive operation. If a sync is performed for an operation, the configuration of \"alluxio.user.file.metadata.load.type\" will be ignored.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PASSIVE_CACHE_ENABLED = new Builder("alluxio.user.file.passive.cache.enabled").setDefaultValue(true).setDescription("Whether to cache files to local Alluxio workers when the files are read from remote workers (not UFS).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_READ_TYPE_DEFAULT = new Builder("alluxio.user.file.readtype.default").setDefaultValue("CACHE").setDescription("Default read type when creating Alluxio files. Valid options are `CACHE_PROMOTE` (move data to highest tier if already in Alluxio storage, write data into highest tier of local Alluxio if data needs to be read from under storage), `CACHE` (write data into highest tier of local Alluxio if data needs to be read from under storage), `NO_CACHE` (no data interaction with Alluxio, if the read is from Alluxio data migration or eviction will not occur).").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PERSIST_ON_RENAME = new Builder("alluxio.user.file.persist.on.rename").setDefaultValue("false").setDescription("Whether or not to asynchronously persist any files which have been renamed. This is helpful when working with compute frameworks which use rename to commit results.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME = new Builder("alluxio.user.file.persistence.initial.wait.time").setDefaultValue("0").setDescription(String.format("Time to wait before starting the persistence job. When the value is set to -1, the file will be persisted by rename operation or persist CLI but will not be automatically persisted in other cases. This is to avoid the heavy object copy in rename operation when %s is set to %s. This value should be smaller than the value of %s", "alluxio.user.file.writetype.default", WritePType.ASYNC_THROUGH, "alluxio.master.persistence.max.total.wait.time")).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_WAITCOMPLETED_POLL_MS = new Builder("alluxio.user.file.waitcompleted.poll").setAlias("alluxio.user.file.waitcompleted.poll.ms").setDefaultValue("1sec").setDescription("The time interval to poll a file for its completion status when using waitCompleted.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_CREATE_TTL = new Builder("alluxio.user.file.create.ttl").setDefaultValue(-1L).setDescription("Time to live for files created by a user, no ttl by default.").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_CREATE_TTL_ACTION = new Builder("alluxio.user.file.create.ttl.action").setDefaultValue("DELETE").setDescription("When file's ttl is expired, the action performs on it. Options: DELETE (default) or FREE").setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_UFS_TIER_ENABLED = new Builder("alluxio.user.file.ufs.tier.enabled").setDescription("When workers run out of available memory, whether the client can skip writing data to Alluxio but fallback to write to UFS without stopping the application. This property only works when the write type is ASYNC_THROUGH.").setDefaultValue(false).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_READ_METRICS_ENABLED = new Builder("alluxio.user.block.read.metrics.enabled").setDescription("Whether detailed block read metrics will be recorded and sink.").setDefaultValue(false).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_WRITE_LOCATION_POLICY = new Builder("alluxio.user.block.write.location.policy.class").setDefaultValue("alluxio.client.block.policy.LocalFirstPolicy").setDescription("The default location policy for choosing workers for writing a file's blocks.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES = new Builder("alluxio.user.block.avoid.eviction.policy.reserved.size.bytes").setDefaultValue("0MB").setDescription("The portion of space reserved in a worker when using the LocalFirstAvoidEvictionPolicy class as block location policy.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED = new Builder("alluxio.user.client.cache.async.restore.enabled").setDefaultValue(true).setDescription("If this is enabled, cache restore state asynchronously.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED = new Builder("alluxio.user.client.cache.async.write.enabled").setDefaultValue(true).setDescription("If this is enabled, cache data asynchronously.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_ASYNC_WRITE_THREADS = new Builder("alluxio.user.client.cache.async.write.threads").setDefaultValue(16).setDescription("Number of threads to asynchronously cache data.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_ENABLED = new Builder("alluxio.user.client.cache.enabled").setDefaultValue(false).setDescription("If this is enabled, data will be cached on Alluxio client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_FILTER_CLASS = new Builder("alluxio.user.client.cache.filter.class").setDefaultValue("alluxio.client.file.cache.filter.DefaultCacheFilter").setDescription("The default cache filter caches everything").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_FILTER_CONFIG_FILE = new Builder("alluxio.user.client.cache.filter.config-file").setDefaultValue("/tmp/alluxio-filter-config").setDescription("The alluxio cache filter config file").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_EVICTOR_CLASS = new Builder("alluxio.user.client.cache.evictor.class").setDefaultValue("alluxio.client.file.cache.evictor.LRUCacheEvictor").setDescription("The strategy that client uses to evict local cached pages when running out of space. Currently valid options include `alluxio.client.file.cache.evictor.LRUCacheEvictor`,`alluxio.client.file.cache.evictor.LFUCacheEvictor`.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_EVICTOR_LFU_LOGBASE = new Builder("alluxio.user.client.cache.evictor.lfu.logbase").setDefaultValue(2.0).setDescription("The log base for client cache LFU evictor bucket index.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_EVICTOR_NONDETERMINISTIC_ENABLED = new Builder("alluxio.user.client.cache.evictor.nondeterministic.enabled").setDefaultValue(false).setDescription("If this is enabled, the evictor picks uniformly from the worst k elements.Currently only LRU is supported.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SCOPED_METRICS_COLLECTING_TYPE = new Builder("alluxio.user.client.cache.metrics.breakdown.collecting.type").setDefaultValue("NO_OP").setDescription("The type of client cache metrics breakdown to use, it could be either 'ALLUXIO_SYSTEM', 'IN_MEMORY' or 'NO_OP'.The 'ALLUXIO_SYSTEM' will expose the metrics to Alluxio system's metricsThe 'IN_MEMORY' will store the metrics in a hashmap in memory.The 'NO_OP' will disable the scoped metrics breakdown.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SHADOW_ENABLED = new Builder("alluxio.user.client.cache.shadow.enabled").setDefaultValue(false).setDescription("If this is enabled, a shadow cache will be created to tracking the working set of a past time window, and measure the hit ratio if the working set fits the cache").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SHADOW_METRICS_BREAKDOWN_ENABLED = new Builder("alluxio.user.client.cache.shadow.metrics.breakdown.enabled").setDefaultValue(false).setDescription("If this is enabled, a breakdown metrics will be collected on client side").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SHADOW_WINDOW = new Builder("alluxio.user.client.cache.shadow.window").setDefaultValue("24h").setDescription("The past time window for the shadow cache to tracking the working set, and it is in the unit of second").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SHADOW_MEMORY_OVERHEAD = new Builder("alluxio.user.client.cache.shadow.memory.overhead").setDefaultValue("125MB").setDescription("The total memory overhead for bloom filters used for tracking").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SHADOW_BLOOMFILTER_NUM = new Builder("alluxio.user.client.cache.shadow.bloomfilter.num").setDefaultValue(4).setDescription("The number of bloom filters used for tracking. Each tracks a segment of window").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_DIR = new Builder("alluxio.user.client.cache.dir").setDefaultValue("/tmp/alluxio_cache").setDescription("The directory where client-side cache is stored.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_EVICTION_RETRIES = new Builder("alluxio.user.client.cache.eviction.retries").setDefaultValue(10).setDescription("Max number of eviction retries.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_TIMEOUT_DURATION = new Builder("alluxio.user.client.cache.timeout.duration").setDefaultValue("-1").setDescription("The timeout duration for local cache I/O operations (reading/writing/deleting). When this property is a positive value,local cache operations after timing out will fail and fallback to external file system but transparent to applications; when this property is a negative value, this feature is disabled.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_TIMEOUT_THREADS = new Builder("alluxio.user.client.cache.timeout.threads").setDefaultValue("32").setDescription("The number of threads to handle cache I/O operation timeout, when alluxio.user.client.cache.timeout.duration is positive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_STORE_OVERHEAD = new Builder("alluxio.user.client.cache.store.overhead").setDescription("A fraction value representing the storage overhead writing to disk. For example, with 1GB allocated cache space, and 10% storage overhead we expect no more than 1024MB / (1 + 10%) user data to store.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_STORE_TYPE = new Builder("alluxio.user.client.cache.store.type").setDefaultValue("LOCAL").setDescription("The type of page store to use for client-side cache. Can be either `LOCAL` or `ROCKS`. The `LOCAL` page store stores all pages in a directory, the `ROCKS` page store utilizes rocksDB to persist the data.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS = new Builder("alluxio.user.client.cache.local.store.file.buckets").setDefaultValue("1000").setDescription("The number of file buckets for the local page store of the client-side cache. It is recommended to set this to a high value if the number of unique files is expected to be high (# files / file buckets <= 100,000).").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_QUOTA_ENABLED = new Builder("alluxio.user.client.cache.quota.enabled").setDefaultValue("false").setDescription("Whether to support cache quota.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_SIZE = new Builder("alluxio.user.client.cache.size").setDefaultValue("512MB").setDescription("The maximum size of the client-side cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_CLIENT_CACHE_PAGE_SIZE = new Builder("alluxio.user.client.cache.page.size").setDefaultValue("1MB").setDescription("Size of each page in client-side cache.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_WRITE_TYPE_DEFAULT = new Builder("alluxio.user.file.writetype.default").setDefaultValue("ASYNC_THROUGH").setDescription(String.format("Default write type when creating Alluxio files. Valid options are `MUST_CACHE` (write will only go to Alluxio and must be stored in Alluxio), `CACHE_THROUGH` (try to cache, write to UnderFS synchronously), `THROUGH` (no cache, write to UnderFS synchronously), `ASYNC_THROUGH` (write to cache, write to UnderFS asynchronously, replicated %s times in Alluxio before data is persisted.", USER_FILE_REPLICATION_DURABLE)).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_HOSTNAME = new Builder("alluxio.user.hostname").setDescription("The hostname to use for an Alluxio client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_FILE_WRITE_TIER_DEFAULT = new Builder("alluxio.user.file.write.tier.default").setDefaultValue(0).setDescription("The default tier for choosing a where to write a block. Valid option is any integer. Non-negative values identify tiers starting from top going down (0 identifies the first tier, 1 identifies the second tier, and so on). If the provided value is greater than the number of tiers, it identifies the last tier. Negative values identify tiers starting from the bottom going up (-1 identifies the last tier, -2 identifies the second to last tier, and so on). If the absolute value of the provided value is greater than the number of tiers, it identifies the first tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_LOCAL_READER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.local.reader.chunk.size.bytes").setDefaultValue("8MB").setDescription("When a client reads from a local worker, the maximum data chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_LOCAL_WRITER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.local.writer.chunk.size.bytes").setDefaultValue("64KB").setDescription("When a client writes to a local worker, the maximum data chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_LOGGING_THRESHOLD = new Builder("alluxio.user.logging.threshold").setDefaultValue("10s").setDescription("Logging a client RPC when it takes more time than the threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_MASTER_POLLING_TIMEOUT = new Builder("alluxio.user.master.polling.timeout").setDefaultValue("30sec").setDescription("The maximum time for a rpc client to wait for master to respond.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_ENABLED = new Builder("alluxio.user.metadata.cache.enabled").setDefaultValue(false).setDescription("If this is enabled, metadata of paths will be cached. The cached metadata will be evicted when it expires after alluxio.user.metadata.cache.expiration.time or the cache size is over the limit of alluxio.user.metadata.cache.max.size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_MAX_SIZE = new Builder("alluxio.user.metadata.cache.max.size").setDefaultValue(100000).setDescription("Maximum number of paths with cached metadata. Only valid if the filesystem is alluxio.client.file.MetadataCachingBaseFileSystem.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METADATA_CACHE_EXPIRATION_TIME = new Builder("alluxio.user.metadata.cache.expiration.time").setDefaultValue("10min").setDescription("Metadata will expire and be evicted after being cached for this time period. Only valid if the filesystem is alluxio.client.file.MetadataCachingBaseFileSystem.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METRICS_COLLECTION_ENABLED = new Builder("alluxio.user.metrics.collection.enabled").setDefaultValue(false).setDescription("Enable collecting the client-side metrics and heartbeat them to master").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_METRICS_HEARTBEAT_INTERVAL_MS = new Builder("alluxio.user.metrics.heartbeat.interval").setAlias("alluxio.user.metrics.heartbeat.interval.ms").setDefaultValue("10sec").setDescription("The time period of client master heartbeat to send the client-side metrics.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_APP_ID = new Builder("alluxio.user.app.id").setScope(Scope.CLIENT).setDescription("The custom id to use for labeling this client's info, such as metrics. If unset, a random long will be used. This value is displayed in the client logs on initialization. Note that using the same app id will cause client info to be aggregated, so different applications must set their own ids or leave this value unset to use a randomly generated id.").build();
    public static final PropertyKey USER_SKIP_AUTHORITY_CHECK = new Builder("alluxio.user.skip.authority.check").setScope(Scope.CLIENT).setDefaultValue(false).setIsHidden(true).setDescription("By default, Alluxio will validate the AlluxioURI. If the authority part contradicts with the configuration (e.g. You specified master1,master2,master3 for high availability masters but the AlluxioURI is alluxio://master1:<port>/), Alluxio client will throw an exception. If this option is turned on, Alluxio client will ignore the wrong authority passed in by the AlluxioURI and use the configured value. This property is useful for the legacy client code, where the cluster setup has changed but the client code has hard-coded stale address. The admin can turn on this property and control where the clients connect in the configuration.").build();
    public static final PropertyKey USER_STREAMING_DATA_READ_TIMEOUT = new Builder("alluxio.user.streaming.data.read.timeout").setAlias("alluxio.user.network.data.timeout.ms", "alluxio.user.network.data.timeout", "alluxio.user.streaming.data.timeout").setDefaultValue("1h").setDescription("The maximum time for an Alluxio client to wait for a data response for read requests from Alluxio worker. Keep in mind that some streaming operations may take an unexpectedly long time, such as UFS io. In order to handle occasional slow operations, it is recommended for this parameter to be set to a large value, to avoid spurious timeouts.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_DATA_WRITE_TIMEOUT = new Builder("alluxio.user.streaming.data.write.timeout").setDefaultValue("1h").setDescription("The maximum time for an Alluxio client to wait for when writing 1 chunk for block writes to an Alluxio worker. This value can be tuned to offset instability from the UFS.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_READER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.streaming.reader.buffer.size.messages").setAlias("alluxio.user.network.reader.buffer.size.messages").setDefaultValue(16).setDescription("When a client reads from a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_READER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.streaming.reader.chunk.size.bytes").setAlias("alluxio.user.network.reader.chunk.size.bytes").setDefaultValue("1MB").setDescription("When a client reads from a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_READER_CLOSE_TIMEOUT = new Builder("alluxio.user.streaming.reader.close.timeout").setDefaultValue("5s").setDescription("The timeout to close a grpc streaming reader client. If too long, it may add delays to closing clients. If too short, the client will complete the close() before the server confirms the close()").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_WRITER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.streaming.writer.buffer.size.messages").setAlias("alluxio.user.network.writer.buffer.size.messages").setDefaultValue(16).setDescription("When a client writes to a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_WRITER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.streaming.writer.chunk.size.bytes").setAlias("alluxio.user.network.writer.chunk.size.bytes").setDefaultValue("1MB").setDescription("When a client writes to a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_WRITER_CLOSE_TIMEOUT = new Builder("alluxio.user.streaming.writer.close.timeout").setAlias("alluxio.user.network.writer.close.timeout.ms", "alluxio.user.network.writer.close.timeout").setDefaultValue("30min").setDescription("The timeout to close a writer client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_WRITER_FLUSH_TIMEOUT = new Builder("alluxio.user.streaming.writer.flush.timeout").setAlias("alluxio.user.network.writer.flush.timeout").setDefaultValue("30min").setDescription("The timeout to wait for flush to finish in a data writer.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_STREAMING_ZEROCOPY_ENABLED = new Builder("alluxio.user.streaming.zerocopy.enabled").setAlias("alluxio.user.network.zerocopy.enabled").setDefaultValue(true).setDescription("Whether zero copy is enabled on client when processing data streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_DATA_TIMEOUT_MS = new Builder("alluxio.user.network.data.timeout").setAlias("alluxio.user.network.data.timeout.ms").setDescription("The maximum time for an Alluxio client to wait for a data response (e.g. block reads and block writes) from Alluxio worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_READER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.network.reader.buffer.size.messages").setDescription("When a client reads from a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_READER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.network.reader.chunk.size.bytes").setDescription("When a client reads from a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = new Builder("alluxio.user.network.writer.buffer.size.messages").setDescription("When a client writes to a remote worker, the maximum number of messages to buffer by the client. A message can be either a command response, a data chunk, or a gRPC stream event such as complete or error.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_WRITER_CHUNK_SIZE_BYTES = new Builder("alluxio.user.network.writer.chunk.size.bytes").setDescription("When a client writes to a remote worker, the maximum chunk size.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_WRITER_CLOSE_TIMEOUT_MS = new Builder("alluxio.user.network.writer.close.timeout").setAlias("alluxio.user.network.writer.close.timeout.ms").setDescription("The timeout to close a writer client.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_WRITER_FLUSH_TIMEOUT = new Builder("alluxio.user.network.writer.flush.timeout").setDescription("The timeout to wait for flush to finish in a data writer.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_ZEROCOPY_ENABLED = new Builder("alluxio.user.network.zerocopy.enabled").setDescription("Whether zero copy is enabled on client when processing data streams.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_FLOWCONTROL_WINDOW = new Builder("alluxio.user.network.flowcontrol.window").setDescription("The HTTP2 flow control window used by user gRPC connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_KEEPALIVE_TIME = new Builder("alluxio.user.network.keepalive.time").setDescription("The amount of time for a gRPC client (for block reads and block writes) to wait for a response before pinging the server to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_KEEPALIVE_TIMEOUT = new Builder("alluxio.user.network.keepalive.timeout").setDescription("The maximum time for a gRPC client (for block reads and block writes) to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.user.network.max.inbound.message.size").setDescription("The max inbound message size used by user gRPC connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_NETTY_CHANNEL = new Builder("alluxio.user.network.netty.channel").setDescription("Type of netty channels. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    @Deprecated
    public static final PropertyKey USER_NETWORK_NETTY_WORKER_THREADS = new Builder("alluxio.user.network.netty.worker.threads").setDescription("How many threads to use for remote block worker client to read from remote block workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_FLOWCONTROL_WINDOW = new Builder("alluxio.user.network.rpc.flowcontrol.window").setDefaultValue("2MB").setDescription("The HTTP2 flow control window used by user rpc connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_KEEPALIVE_TIME = new Builder("alluxio.user.network.rpc.keepalive.time").setDefaultValue(Long.MAX_VALUE).setDescription("The amount of time for a rpc client to wait for a response before pinging the server to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_KEEPALIVE_TIMEOUT = new Builder("alluxio.user.network.rpc.keepalive.timeout").setDefaultValue("30sec").setDescription("The maximum time for a rpc client to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.user.network.rpc.max.inbound.message.size").setDefaultValue("100MB").setDescription("The max inbound message size used by user rpc connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_NETTY_CHANNEL = new Builder("alluxio.user.network.rpc.netty.channel").setDescription("Type of netty channels used by rpc connections. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setDefaultValue("EPOLL").build();
    public static final PropertyKey USER_NETWORK_RPC_NETTY_WORKER_THREADS = new Builder("alluxio.user.network.rpc.netty.worker.threads").setDefaultValue(0).setDescription("How many threads to use for rpc client to read from remote workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_RPC_MAX_CONNECTIONS = new Builder("alluxio.user.network.rpc.max.connections").setDefaultValue(1).setDescription("The maximum number of physical connections to be used per target host.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_FLOWCONTROL_WINDOW = new Builder("alluxio.user.network.streaming.flowcontrol.window").setAlias("alluxio.user.network.flowcontrol.window").setDefaultValue("2MB").setDescription("The HTTP2 flow control window used by user streaming connections. Larger value will allow more data to be buffered but will use more memory.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_KEEPALIVE_TIME = new Builder("alluxio.user.network.streaming.keepalive.time").setAlias("alluxio.user.network.keepalive.time").setDefaultValue(Long.MAX_VALUE).setDescription("The amount of time for a streaming client to wait for a response before pinging the server to see if it is still alive.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_KEEPALIVE_TIMEOUT = new Builder("alluxio.user.network.streaming.keepalive.timeout").setAlias("alluxio.user.network.keepalive.timeout").setDefaultValue("30sec").setDescription("The maximum time for a streaming client to wait for a keepalive response before closing the connection.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_MAX_INBOUND_MESSAGE_SIZE = new Builder("alluxio.user.network.streaming.max.inbound.message.size").setAlias("alluxio.user.network.max.inbound.message.size").setDefaultValue("100MB").setDescription("The max inbound message size used by user streaming connections.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_NETTY_CHANNEL = new Builder("alluxio.user.network.streaming.netty.channel").setAlias("alluxio.user.network.netty.channel").setDescription("Type of netty channels used by streaming connections. If EPOLL is not available, this will automatically fall back to NIO.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).setDefaultValue("EPOLL").build();
    public static final PropertyKey USER_NETWORK_STREAMING_NETTY_WORKER_THREADS = new Builder("alluxio.user.network.streaming.netty.worker.threads").setAlias("alluxio.user.network.netty.worker.threads").setDefaultValue(0).setDescription("How many threads to use for streaming client to read from remote workers.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_NETWORK_STREAMING_MAX_CONNECTIONS = new Builder("alluxio.user.network.streaming.max.connections").setDefaultValue(64).setDescription("The maximum number of physical connections to be used per target host.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_BASE_SLEEP_MS = new Builder("alluxio.user.rpc.retry.base.sleep").setAlias("alluxio.user.rpc.retry.base.sleep.ms").setDefaultValue("50ms").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the base time in the exponential backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_MAX_DURATION = new Builder("alluxio.user.rpc.retry.max.duration").setDefaultValue("2min").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the maximum duration to retry for before giving up. Note that, this value is set to 5s for fs and fsadmin CLIs.").build();
    public static final PropertyKey USER_WORKER_LIST_REFRESH_INTERVAL = new Builder("alluxio.user.worker.list.refresh.interval").setDefaultValue("2min").setDescription("The interval used to refresh the live worker list on the client").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_RPC_RETRY_MAX_SLEEP_MS = new Builder("alluxio.user.rpc.retry.max.sleep").setAlias("alluxio.user.rpc.retry.max.sleep.ms").setDefaultValue("3sec").setDescription("Alluxio client RPCs automatically retry for transient errors with an exponential backoff. This property determines the maximum wait time in the backoff.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED = new Builder("alluxio.user.ufs.block.location.all.fallback.enabled").setDefaultValue(true).setDescription("Whether to return all workers as block location if ufs block locations are not co-located with any Alluxio workers or is empty.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_LOCATION_POLICY = new Builder("alluxio.user.ufs.block.read.location.policy").setDefaultValue("alluxio.client.block.policy.LocalFirstPolicy").setDescription(String.format("When an Alluxio client reads a file from the UFS, it delegates the read to an Alluxio worker. The client uses this policy to choose which worker to read through. Built-in choices: %s.", Arrays.asList(PropertyKey.javadocLink("alluxio.client.block.policy.DeterministicHashPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.LocalFirstAvoidEvictionPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.LocalFirstPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.MostAvailableFirstPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.RoundRobinPolicy"), PropertyKey.javadocLink("alluxio.client.block.policy.SpecificHostPolicy")))).setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_LOCATION_POLICY_DETERMINISTIC_HASH_SHARDS = new Builder("alluxio.user.ufs.block.read.location.policy.deterministic.hash.shards").setDefaultValue(1).setDescription("When alluxio.user.ufs.block.read.location.policy is set to alluxio.client.block.policy.DeterministicHashPolicy, this specifies the number of hash shards.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UFS_BLOCK_READ_CONCURRENCY_MAX = new Builder("alluxio.user.ufs.block.read.concurrency.max").setDefaultValue(Integer.MAX_VALUE).setDescription("The maximum concurrent readers for one UFS block on one Block Worker.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_DIRECT_MEMORY_IO_ENABLED = new Builder("alluxio.user.unsafe.direct.local.io.enabled").setDefaultValue(false).setAlias("alluxio.user.direct.memory.io.enabled").setIsHidden(true).setDescription("(Experimental) If this is enabled, clients will read from local worker directly without invoking extra RPCs to worker to require locations. Note this optimization is only safe when the workload is read only and the worker has only one tier and one storage directory in this tier.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_UPDATE_FILE_ACCESSTIME_DISABLED = new Builder("alluxio.user.update.file.accesstime.disabled").setDefaultValue(false).setIsHidden(true).setDescription("(Experimental) If this is enabled, the clients doesn't update file access time which may cause issues for some applications.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_SHORT_CIRCUIT_ENABLED = new Builder("alluxio.user.short.circuit.enabled").setDefaultValue(true).setDescription("The short circuit read/write which allows the clients to read/write data without going through Alluxio workers if the data is local is enabled if set to true.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey USER_SHORT_CIRCUIT_PREFERRED = new Builder("alluxio.user.short.circuit.preferred").setDefaultValue(false).setDescription("When short circuit and domain socket both enabled, prefer to use short circuit.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_AUTH_POLICY_CLASS = new Builder("alluxio.fuse.auth.policy.class").setDefaultValue("alluxio.fuse.auth.SystemUserGroupAuthPolicy").setDescription("The fuse auth policy class.  Valid options include: `alluxio.fuse.auth.SystemUserGroupAuthPolicy`, `alluxio.fuse.auth.CustomAuthPolicy`.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_AUTH_POLICY_CUSTOM_USER = new Builder("alluxio.fuse.auth.policy.custom.user").setDescription("The fuse user name for custom auth policy. Only valid if the alluxio.fuse.auth.policy.class is alluxio.fuse.auth.CustomAuthPolicy").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_AUTH_POLICY_CUSTOM_GROUP = new Builder("alluxio.fuse.auth.policy.custom.group").setDescription("The fuse group name for custom auth policy. Only valid if the alluxio.fuse.auth.policy.class is alluxio.fuse.auth.CustomAuthPolicy").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_CACHED_PATHS_MAX = new Builder("alluxio.fuse.cached.paths.max").setDefaultValue(500).setDescription("Maximum number of Alluxio paths to cache for FUSE conversion.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_DEBUG_ENABLED = new Builder("alluxio.fuse.debug.enabled").setDefaultValue(false).setDescription("Run FUSE in debug mode, and have the fuse process log every FS request.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_FS_NAME = new Builder("alluxio.fuse.fs.name").setDefaultValue("alluxio-fuse").setDescription("The FUSE file system name.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_JNIFUSE_ENABLED = new Builder("alluxio.fuse.jnifuse.enabled").setDefaultValue(true).setDescription("Use JNI-Fuse library for better performance. If disabled, JNR-Fuse will be used.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_SHARED_CACHING_READER_ENABLED = new Builder("alluxio.fuse.shared.caching.reader.enabled").setDefaultValue(false).setDescription("(Experimental) Use share grpc data reader for better performance on multi-process file reading through Alluxio JNI Fuse. Blocks data will be cached on the client side so more memory is required for the Fuse process.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_LOGGING_THRESHOLD = new Builder("alluxio.fuse.logging.threshold").setDefaultValue("10s").setDescription("Logging a FUSE API call when it takes more time than the threshold.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_MAXWRITE_BYTES = new Builder("alluxio.fuse.maxwrite.bytes").setDefaultValue("128KB").setDescription("Maximum granularity of write operations, capped by the kernel to 128KB max (as of Linux 3.16.0).").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_UMOUNT_TIMEOUT = new Builder("alluxio.fuse.umount.timeout").setDefaultValue("1min").setDescription("The timeout to wait for all in progress file read and write to finish before unmounting the Fuse filesystem. After the timeout, all in progress file read will be forced to stop and all in progress file write will be abandoned.").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_USER_GROUP_TRANSLATION_ENABLED = new Builder("alluxio.fuse.user.group.translation.enabled").setDefaultValue(false).setDescription("Whether to translate Alluxio users and groups into Unix users and groups when exposing Alluxio files through the FUSE API. When this property is set to false, the user and group for all FUSE files will match the user who started the alluxio-fuse process.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_WEB_ENABLED = new Builder("alluxio.fuse.web.enabled").setDefaultValue(false).setDescription("Whether to enable FUSE web server.").setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_WEB_BIND_HOST = new Builder("alluxio.fuse.web.bind.host").setDefaultValue("0.0.0.0").setDescription("The hostname Alluxio FUSE web UI binds to.").setScope(Scope.CLIENT).build();
    public static final PropertyKey FUSE_WEB_HOSTNAME = new Builder("alluxio.fuse.web.hostname").setDescription("The hostname of Alluxio FUSE web UI.").setScope(Scope.ALL).build();
    public static final PropertyKey FUSE_WEB_PORT = new Builder("alluxio.fuse.web.port").setDefaultValue(49999).setDescription("The port Alluxio FUSE web UI runs on.").setScope(Scope.CLIENT).build();
    public static final PropertyKey SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS = new Builder("alluxio.security.authentication.custom.provider.class").setDescription("The class to provide customized authentication implementation, when alluxio.security.authentication.type is set to CUSTOM. It must implement the interface 'alluxio.security.authentication.AuthenticationProvider'.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey SECURITY_AUTHENTICATION_TYPE = new Builder("alluxio.security.authentication.type").setDefaultValue("SIMPLE").setDescription("The authentication mode. Currently three modes are supported: NOSASL, SIMPLE, CUSTOM. The default value SIMPLE indicates that a simple authentication is enabled. Server trusts whoever the client claims to be.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).setIsDynamic(false).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_ENABLED = new Builder("alluxio.security.authorization.permission.enabled").setDefaultValue(true).setDescription("Whether to enable access control based on file permission.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).setIsDynamic(false).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP = new Builder("alluxio.security.authorization.permission.supergroup").setDefaultValue("supergroup").setDescription("The super group of Alluxio file system. All users in this group have super permission.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.MASTER).build();
    public static final PropertyKey SECURITY_AUTHORIZATION_PERMISSION_UMASK = new Builder("alluxio.security.authorization.permission.umask").setDefaultValue("022").setDescription("The umask of creating file and directory. The initial creation permission is 777, and the difference between directory and file is 111. So for default umask value 022, the created directory has permission 755 and file has permission 644.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS = new Builder("alluxio.security.group.mapping.cache.timeout").setAlias("alluxio.security.group.mapping.cache.timeout.ms").setDefaultValue("1min").setDescription("Time for cached group mapping to expire.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey SECURITY_GROUP_MAPPING_CLASS = new Builder("alluxio.security.group.mapping.class").setDefaultValue("alluxio.security.group.provider.ShellBasedUnixGroupsMapping").setDescription("The class to provide user-to-groups mapping service. Master could get the various group memberships of a given user.  It must implement the interface 'alluxio.security.group.GroupMappingService'. The default implementation execute the 'groups' shell command to fetch the group memberships of a given user.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).build();
    public static final PropertyKey SECURITY_LOGIN_IMPERSONATION_USERNAME = new Builder("alluxio.security.login.impersonation.username").setDescription(String.format("When %s is set to SIMPLE or CUSTOM, user application uses this property to indicate the IMPERSONATED user requesting Alluxio service. If it is not set explicitly, or set to %s, impersonation will not be used. A special value of '%s' can be specified to impersonate the hadoop client user.", SECURITY_AUTHENTICATION_TYPE, "_NONE_", "_HDFS_USER_")).setDefaultValue("_HDFS_USER_").setConsistencyCheckLevel(ConsistencyCheckLevel.IGNORE).setScope(Scope.CLIENT).build();
    public static final PropertyKey SECURITY_LOGIN_USERNAME = new Builder("alluxio.security.login.username").setDescription("When alluxio.security.authentication.type is set to SIMPLE or CUSTOM, user application uses this property to indicate the user requesting Alluxio service. If it is not set explicitly, the OS login user will be used.").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.CLIENT).build();
    public static final PropertyKey AUTHENTICATION_INACTIVE_CHANNEL_REAUTHENTICATE_PERIOD = new Builder("alluxio.security.stale.channel.purge.interval").setDefaultValue("3day").setDescription("Interval for which client channels that have been inactive will be regarded as unauthenticated. Such channels will reauthenticate with their target master upon being used for new RPCs.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.ALL).build();
    public static final PropertyKey NETWORK_TLS_SSL_CONTEXT_PROVIDER_CLASSNAME = new Builder("alluxio.network.tls.ssl.context.provider.classname").setDescription("Full name of the class that will be instantiated for providing SSL contexts.").setDefaultValue("alluxio.util.network.tls.DefaultSslContextProvider").setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).setIsHidden(true).build();
    public static final PropertyKey NETWORK_TLS_ENABLED = new Builder("alluxio.network.tls.enabled").setDescription("If true, enables TLS on all network communication between all Alluxio clients, masters, and workers.").setDefaultValue(false).setConsistencyCheckLevel(ConsistencyCheckLevel.ENFORCE).setScope(Scope.ALL).setIsHidden(true).build();
    public static final PropertyKey INTEGRATION_MASTER_RESOURCE_CPU = new Builder("alluxio.integration.master.resource.cpu").setDefaultValue(1).setDescription("The number of CPUs to run an Alluxio master for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_MASTER_RESOURCE_MEM = new Builder("alluxio.integration.master.resource.mem").setDefaultValue("1024MB").setDescription("The amount of memory to run an Alluxio master for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_WORKER_RESOURCE_CPU = new Builder("alluxio.integration.worker.resource.cpu").setDefaultValue(1).setDescription("The number of CPUs to run an Alluxio worker for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_WORKER_RESOURCE_MEM = new Builder("alluxio.integration.worker.resource.mem").setDefaultValue("1024MB").setDescription("The amount of memory to run an Alluxio worker for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey INTEGRATION_YARN_WORKERS_PER_HOST_MAX = new Builder("alluxio.integration.yarn.workers.per.host.max").setDefaultValue(1).setDescription("The number of workers to run on an Alluxio host for YARN framework.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.NONE).build();
    public static final PropertyKey UNDERFS_VERSION = new Builder("alluxio.underfs.version").setDefaultValue("3.3.0").setIsHidden(true).build();
    public static final PropertyKey JOB_MASTER_CLIENT_THREADS = new Builder("alluxio.job.master.client.threads").setDescription("The number of threads the Alluxio master uses to make requests to the job master.").setDefaultValue(1024).setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_FINISHED_JOB_PURGE_COUNT = new Builder("alluxio.job.master.finished.job.purge.count").setDescription("The maximum amount of jobs to purge at any single time when the job master reaches its maximum capacity. It is recommended to set this value when setting the capacity of the job master to a large ( > 10M) value. Default is -1 denoting an unlimited value").setDefaultValue("-1").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_FINISHED_JOB_RETENTION_TIME = new Builder("alluxio.job.master.finished.job.retention.time").setDescription("The length of time the Alluxio Job Master should save information about completed jobs before they are discarded.").setDefaultValue("60sec").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_JOB_CAPACITY = new Builder("alluxio.job.master.job.capacity").setDescription("The total possible number of available job statuses in the job master. This value includes running and finished jobs which are have completed within alluxio.job.master.finished.job.retention.time.").setDefaultValue(100000).setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_WORKER_HEARTBEAT_INTERVAL = new Builder("alluxio.job.master.worker.heartbeat.interval").setDescription("The amount of time that the Alluxio job worker should wait in between heartbeats to the Job Master.").setDefaultValue("1sec").setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_MASTER_WORKER_TIMEOUT = new Builder("alluxio.job.master.worker.timeout").setDescription("The time period after which the job master will mark a worker as lost without a subsequent heartbeat.").setDefaultValue("60sec").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_BIND_HOST = new Builder("alluxio.job.master.bind.host").setDescription("The host that the Alluxio job master will bind to.").setDefaultValue("0.0.0.0").setScope(Scope.ALL).build();
    public static final PropertyKey JOB_MASTER_HOSTNAME = new Builder("alluxio.job.master.hostname").setDescription("The hostname of the Alluxio job master.").setDefaultValue(String.format("${%s}", "alluxio.master.hostname")).setScope(Scope.ALL).build();
    public static final PropertyKey JOB_MASTER_LOST_WORKER_INTERVAL = new Builder("alluxio.job.master.lost.worker.interval").setDescription("The time interval the job master waits between checks for lost workers.").setDefaultValue("1sec").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_RPC_PORT = new Builder("alluxio.job.master.rpc.port").setDescription("The port for Alluxio job master's RPC service.").setDefaultValue(20001).setScope(Scope.ALL).build();
    public static final PropertyKey JOB_MASTER_WEB_BIND_HOST = new Builder("alluxio.job.master.web.bind.host").setDescription("The host that the job master web server binds to.").setDefaultValue("0.0.0.0").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_WEB_HOSTNAME = new Builder("alluxio.job.master.web.hostname").setDescription("The hostname of the job master web server.").setDefaultValue("${alluxio.job.master.hostname}").setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_MASTER_WEB_PORT = new Builder("alluxio.job.master.web.port").setDescription("The port the job master web server uses.").setDefaultValue(20002).setScope(Scope.MASTER).build();
    public static final PropertyKey JOB_WORKER_BIND_HOST = new Builder("alluxio.job.worker.bind.host").setDescription("The host that the Alluxio job worker will bind to.").setDefaultValue("0.0.0.0").setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_DATA_PORT = new Builder("alluxio.job.worker.data.port").setDescription("The port the Alluxio Job worker uses to send data.").setDefaultValue(30002).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_HOSTNAME = new Builder("alluxio.job.worker.hostname").setDescription("The hostname of the Alluxio job worker.").setDefaultValue(String.format("${%s}", "alluxio.worker.hostname")).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_RPC_PORT = new Builder("alluxio.job.worker.rpc.port").setDescription("The port for Alluxio job worker's RPC service.").setDefaultValue(30001).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_THREADPOOL_SIZE = new Builder("alluxio.job.worker.threadpool.size").setDescription("Number of threads in the thread pool for job worker. This may be adjusted to a lower value to alleviate resource saturation on the job worker nodes (CPU + IO).").setDefaultValue(10).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_THROTTLING = new Builder("alluxio.job.worker.throttling").setDescription("Whether the job worker should throttle itself based on whether the resources are saturated.").setScope(Scope.WORKER).setDefaultValue(false).build();
    public static final PropertyKey JOB_WORKER_WEB_BIND_HOST = new Builder("alluxio.job.worker.web.bind.host").setDescription("The host the job worker web server binds to.").setDefaultValue("0.0.0.0").setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_WORKER_WEB_PORT = new Builder("alluxio.job.worker.web.port").setDescription("The port the Alluxio job worker web server uses.").setDefaultValue(30003).setScope(Scope.WORKER).build();
    public static final PropertyKey JOB_MASTER_RPC_ADDRESSES = new Builder("alluxio.job.master.rpc.addresses").setDescription(String.format("The list of RPC addresses to use for the job service configured in non-zookeeper HA mode. If this property is not specifically defined, it will first fall back to using %s, replacing those address ports with the port defined by %s. Otherwise the addresses are inherited from %s using the port defined in %s", "alluxio.master.rpc.addresses", "alluxio.job.master.rpc.port", "alluxio.job.master.embedded.journal.addresses", "alluxio.job.master.rpc.port")).setScope(Scope.ALL).build();
    public static final PropertyKey JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES = new Builder("alluxio.job.master.embedded.journal.addresses").setDescription(String.format("A comma-separated list of journal addresses for all job masters in the cluster. The format is 'hostname1:port1,hostname2:port2,...'. Defaults to the journal addresses set for the Alluxio masters (%s), but with the job master embedded journal port.", "alluxio.master.embedded.journal.addresses")).setScope(Scope.ALL).build();
    public static final PropertyKey JOB_MASTER_EMBEDDED_JOURNAL_PORT = new Builder("alluxio.job.master.embedded.journal.port").setDescription("The port to use for embedded journal communication with other job masters.").setDefaultValue(20003).setScope(Scope.ALL).build();
    public static final PropertyKey ZOOKEEPER_JOB_ELECTION_PATH = new Builder("alluxio.zookeeper.job.election.path").setDefaultValue("/alluxio/job_election").build();
    public static final PropertyKey ZOOKEEPER_JOB_LEADER_PATH = new Builder("alluxio.zookeeper.job.leader.path").setDefaultValue("/alluxio/job_leader").build();
    public static final PropertyKey JVM_MONITOR_WARN_THRESHOLD_MS = new Builder("alluxio.jvm.monitor.warn.threshold").setDefaultValue("10sec").setDescription("When the JVM pauses for anything longer than this, log a WARN message.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey JVM_MONITOR_INFO_THRESHOLD_MS = new Builder("alluxio.jvm.monitor.info.threshold").setDefaultValue("1sec").setDescription("When the JVM pauses for anything longer than this, log an INFO message.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey JVM_MONITOR_SLEEP_INTERVAL_MS = new Builder("alluxio.jvm.monitor.sleep.interval").setDefaultValue("1sec").setDescription("The time for the JVM monitor thread to sleep.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.SERVER).build();
    public static final PropertyKey MASTER_JVM_MONITOR_ENABLED = new Builder("alluxio.master.jvm.monitor.enabled").setDefaultValue(true).setDescription("Whether to enable start JVM monitor thread on the master. This will start a thread to detect JVM-wide pauses induced by GC or other reasons.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey WORKER_JVM_MONITOR_ENABLED = new Builder("alluxio.worker.jvm.monitor.enabled").setDefaultValue(true).setDescription("Whether to enable start JVM monitor thread on the worker. This will start a thread to detect JVM-wide pauses induced by GC or other reasons.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.WORKER).build();
    public static final PropertyKey TABLE_ENABLED = new Builder("alluxio.table.enabled").setDefaultValue(true).setDescription("(Experimental) Enables the table service.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_CATALOG_PATH = new Builder("alluxio.table.catalog.path").setDefaultValue("/catalog").setDescription("The Alluxio file path for the table catalog metadata.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_CATALOG_UDB_SYNC_TIMEOUT = new Builder("alluxio.table.catalog.udb.sync.timeout").setDefaultValue("1h").setDescription("The timeout period for a db sync to finish in the catalog. If a synctakes longer than this timeout, the sync will be terminated.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_JOURNAL_PARTITIONS_CHUNK_SIZE = new Builder("alluxio.table.journal.partitions.chunk.size").setDefaultValue(500).setDescription("The maximum table partitions number in a single journal entry.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_TRANSFORM_MANAGER_JOB_MONITOR_INTERVAL = new Builder("alluxio.table.transform.manager.job.monitor.interval").setDefaultValue(10000).setDescription("Job monitor is a heartbeat thread in the transform manager, this is the time interval in milliseconds the job monitor heartbeat is run to check the status of the transformation jobs and update table and partition locations after transformation.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_TRANSFORM_MANAGER_JOB_HISTORY_RETENTION_TIME = new Builder("alluxio.table.transform.manager.job.history.retention.time").setDefaultValue("300sec").setDescription("The length of time the Alluxio Table Master should keep information about finished transformation jobs before they are discarded.").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_UDB_HIVE_CLIENTPOOL_MIN = new Builder("alluxio.table.udb.hive.clientpool.min").setDefaultValue("16").setDescription("The minimum capacity of the hive client pool per hive metastore").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    public static final PropertyKey TABLE_UDB_HIVE_CLIENTPOOL_MAX = new Builder("alluxio.table.udb.hive.clientpool.MAX").setDefaultValue("256").setDescription("The maximum capacity of the hive client pool per hive metastore").setConsistencyCheckLevel(ConsistencyCheckLevel.WARN).setScope(Scope.MASTER).build();
    @Deprecated(message="This key is used only for testing. It is always deprecated")
    public static final PropertyKey TEST_DEPRECATED_KEY = new Builder("alluxio.test.deprecated.key").build();
    private static final String[] CUSTOM_CREDENTIAL_NAME_SUBSTR = new String[]{"accessKeyId", "secretKey"};
    private final String mName;
    private final String mDescription;
    private final DefaultSupplier mDefaultSupplier;
    private final String[] mAliases;
    private final boolean mIgnoredSiteProperty;
    private final boolean mIsBuiltIn;
    private final boolean mIsHidden;
    private final ConsistencyCheckLevel mConsistencyCheckLevel;
    private final Scope mScope;
    private final DisplayType mDisplayType;
    private final boolean mDynamic;
    private static final DeprecatedKeyChecker DEPRECATED_CHECKER = new DeprecatedKeyChecker();

    private static String javadocLink(String fullyQualifiedClassname) {
        String javadocPath = fullyQualifiedClassname.replace(".", "/") + ".html";
        return String.format("<a href=\"%s\">%s</a>", PathUtils.concatPath((Object)RuntimeConstants.ALLUXIO_JAVADOC_URL, (Object)javadocPath), fullyQualifiedClassname);
    }

    public static boolean isValid(String input) {
        if (DEFAULT_KEYS_MAP.containsKey(input) || DEFAULT_ALIAS_MAP.containsKey(input)) {
            return true;
        }
        Boolean result = (Boolean)REGEXP_CACHE.getIfPresent((Object)input);
        if (result != null) {
            return result;
        }
        result = false;
        for (Template template : Template.values()) {
            if (!template.matches(input)) continue;
            result = true;
            break;
        }
        REGEXP_CACHE.put((Object)input, (Object)result);
        return result;
    }

    public static PropertyKey fromString(String input) {
        PropertyKey key = DEFAULT_KEYS_MAP.get(input);
        if (key != null) {
            return key;
        }
        key = DEFAULT_ALIAS_MAP.get(input);
        if (key != null) {
            return key;
        }
        for (Template template : Template.values()) {
            key = template.getPropertyKey(input);
            if (key == null) continue;
            return key;
        }
        if (PropertyKey.isRemoved(input)) {
            String errorMsg = String.format("%s is no longer a valid property. %s", input, PropertyKey.getRemovalMessage(input));
            LOG.error(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        throw new IllegalArgumentException(ExceptionMessage.INVALID_CONFIGURATION_KEY.getMessage(input));
    }

    public static Collection<? extends PropertyKey> defaultKeys() {
        return Sets.newHashSet(DEFAULT_KEYS_MAP.values());
    }

    private PropertyKey(String name, String description, DefaultSupplier defaultSupplier, String[] aliases, boolean ignoredSiteProperty, boolean isHidden, ConsistencyCheckLevel consistencyCheckLevel, Scope scope, DisplayType displayType, boolean isBuiltIn, boolean dynamic) {
        this.mName = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.mDescription = Strings.isNullOrEmpty((String)description) ? "N/A" : description;
        this.mDefaultSupplier = defaultSupplier;
        this.mAliases = aliases;
        this.mIgnoredSiteProperty = ignoredSiteProperty;
        this.mIsHidden = isHidden;
        this.mConsistencyCheckLevel = consistencyCheckLevel;
        this.mScope = scope;
        this.mDisplayType = displayType;
        this.mIsBuiltIn = isBuiltIn;
        this.mDynamic = dynamic;
    }

    private PropertyKey(String name) {
        this(name, null, new DefaultSupplier(() -> null, "null"), null, false, false, ConsistencyCheckLevel.IGNORE, Scope.ALL, DisplayType.DEFAULT, true, true);
    }

    @VisibleForTesting
    public static boolean register(PropertyKey key) {
        String name = key.getName();
        String[] aliases = key.getAliases();
        if (DEFAULT_KEYS_MAP.containsKey(name) && (DEFAULT_KEYS_MAP.get(name).isBuiltIn() || !key.isBuiltIn())) {
            return false;
        }
        DEFAULT_KEYS_MAP.put(name, key);
        if (aliases != null) {
            for (String alias : aliases) {
                DEFAULT_ALIAS_MAP.put(alias, key);
            }
        }
        return true;
    }

    @VisibleForTesting
    public static void unregister(PropertyKey key) {
        String name = key.getName();
        DEFAULT_KEYS_MAP.remove(name);
        DEFAULT_ALIAS_MAP.remove(name);
    }

    public static PropertyKey getOrBuildCustom(String name) {
        return DEFAULT_KEYS_MAP.computeIfAbsent(name, key -> {
            Builder propertyKeyBuilder = new Builder((String)key).setIsBuiltIn(false);
            for (String customCredentialName : CUSTOM_CREDENTIAL_NAME_SUBSTR) {
                if (!name.contains(customCredentialName)) continue;
                propertyKeyBuilder.setDisplayType(DisplayType.CREDENTIALS);
            }
            return propertyKeyBuilder.buildUnregistered();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyKey)) {
            return false;
        }
        PropertyKey that = (PropertyKey)o;
        return Objects.equal((Object)this.mName, (Object)that.mName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName});
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int compareTo(PropertyKey o) {
        return this.mName.compareTo(o.mName);
    }

    public int length() {
        return this.mName.length();
    }

    public boolean isNested(String key) {
        return key.length() > this.length() + 1 && key.startsWith(this.mName) && key.charAt(this.length()) == '.';
    }

    public String getName() {
        return this.mName;
    }

    public String[] getAliases() {
        return this.mAliases;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public String getDefaultValue() {
        Object defaultValue = this.mDefaultSupplier.get();
        return defaultValue == null ? null : defaultValue.toString();
    }

    public DefaultSupplier getDefaultSupplier() {
        return this.mDefaultSupplier;
    }

    public boolean isIgnoredSiteProperty() {
        return this.mIgnoredSiteProperty;
    }

    public boolean isBuiltIn() {
        return this.mIsBuiltIn;
    }

    public boolean isDynamic() {
        return this.mDynamic;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public ConsistencyCheckLevel getConsistencyLevel() {
        return this.mConsistencyCheckLevel;
    }

    public Scope getScope() {
        return this.mScope;
    }

    public DisplayType getDisplayType() {
        return this.mDisplayType;
    }

    public static boolean isDeprecated(PropertyKey key) {
        return DEPRECATED_CHECKER.hasAnnotation(key);
    }

    public static boolean isDeprecated(String name) {
        return PropertyKey.isDeprecated(PropertyKey.fromString(name));
    }

    public static boolean isRemoved(String key) {
        return RemovedKey.isRemoved(key);
    }

    public static String getDeprecationMessage(PropertyKey key) {
        Deprecated annotation;
        if (PropertyKey.isDeprecated(key) && (annotation = DEPRECATED_CHECKER.getAnnotation(key)) != null) {
            return annotation.message();
        }
        return "";
    }

    public static String getRemovalMessage(String key) {
        String msg = RemovedKey.getMessage(key);
        return msg == null ? "" : msg;
    }

    @ThreadSafe
    public static enum Template {
        LOCALITY_TIER("alluxio.locality.%s", "alluxio\\.locality\\.(\\w+)"),
        MASTER_IMPERSONATION_GROUPS_OPTION("alluxio.master.security.impersonation.%s.groups", "alluxio\\.master\\.security\\.impersonation\\.([a-zA-Z_0-9-\\.@]+)\\.groups"),
        MASTER_IMPERSONATION_USERS_OPTION("alluxio.master.security.impersonation.%s.users", "alluxio\\.master\\.security\\.impersonation\\.([a-zA-Z_0-9-\\.@]+)\\.users"),
        MASTER_JOURNAL_UFS_OPTION("alluxio.master.journal.ufs.option", "alluxio\\.master\\.journal\\.ufs\\.option"),
        MASTER_JOURNAL_UFS_OPTION_PROPERTY("alluxio.master.journal.ufs.option.%s", "alluxio\\.master\\.journal\\.ufs\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$200()),
        MASTER_MOUNT_TABLE_ALLUXIO("alluxio.master.mount.table.%s.alluxio", "alluxio\\.master\\.mount\\.table.(\\w+)\\.alluxio"),
        MASTER_MOUNT_TABLE_OPTION("alluxio.master.mount.table.%s.option", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.option"),
        MASTER_MOUNT_TABLE_OPTION_PROPERTY("alluxio.master.mount.table.%s.option.%s", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$300()),
        MASTER_MOUNT_TABLE_READONLY("alluxio.master.mount.table.%s.readonly", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.readonly"),
        MASTER_MOUNT_TABLE_SHARED("alluxio.master.mount.table.%s.shared", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.shared"),
        MASTER_MOUNT_TABLE_UFS("alluxio.master.mount.table.%s.ufs", "alluxio\\.master\\.mount\\.table\\.(\\w+)\\.ufs"),
        MASTER_MOUNT_TABLE_ROOT_OPTION_PROPERTY("alluxio.master.mount.table.root.option.%s", "alluxio\\.master\\.mount\\.table\\.root\\.option\\.(?<nested>(\\w+\\.)*+\\w+)", PropertyCreators.access$300()),
        MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS("alluxio.master.tieredstore.global.level%d.alias", "alluxio\\.master\\.tieredstore\\.global\\.level(\\d+)\\.alias"),
        UNDERFS_ABFS_ACCOUNT_KEY("fs.azure.account.key.%s.dfs.core.windows.net", "fs\\.azure\\.account\\.key\\.(\\w+)\\.dfs\\.core\\.window\\.net", PropertyCreators.access$400(new Builder("fs.azure.account.key.%s.dfs.core.windows.net").setDisplayType(DisplayType.CREDENTIALS))),
        UNDERFS_AZURE_ACCOUNT_KEY("fs.azure.account.key.%s.blob.core.windows.net", "fs\\.azure\\.account\\.key\\.(\\w+)\\.blob\\.core\\.windows\\.net", PropertyCreators.access$400(new Builder("fs.azure.account.key.%s.blob.core.windows.net").setDisplayType(DisplayType.CREDENTIALS))),
        UNDERFS_AZURE_CLIENT_ID("fs.adl.account.%s.oauth2.client.id", "fs\\.adl\\.account\\.(\\w+)\\.oauth2\\.client\\.id"),
        UNDERFS_AZURE_CLIENT_SECRET("fs.adl.account.%s.oauth2.credential", "fs\\.adl\\.account\\.(\\w+)\\.oauth2\\.credential", PropertyCreators.access$400(new Builder("fs.adl.account.%s.oauth2.credential").setDisplayType(DisplayType.CREDENTIALS))),
        UNDERFS_AZURE_REFRESH_URL("fs.adl.account.%s.oauth2.refresh.url", "fs\\.adl\\.account\\.(\\w+)\\.oauth2\\.refresh\\.url"),
        WORKER_TIERED_STORE_LEVEL_ALIAS("alluxio.worker.tieredstore.level%d.alias", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.alias"),
        WORKER_TIERED_STORE_LEVEL_DIRS_PATH("alluxio.worker.tieredstore.level%d.dirs.path", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.path"),
        WORKER_TIERED_STORE_LEVEL_DIRS_MEDIUMTYPE("alluxio.worker.tieredstore.level%d.dirs.mediumtype", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.mediumtype"),
        WORKER_TIERED_STORE_LEVEL_DIRS_QUOTA("alluxio.worker.tieredstore.level%d.dirs.quota", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.dirs\\.quota"),
        WORKER_TIERED_STORE_LEVEL_HIGH_WATERMARK_RATIO("alluxio.worker.tieredstore.level%d.watermark.high.ratio", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.watermark\\.high\\.ratio"),
        WORKER_TIERED_STORE_LEVEL_LOW_WATERMARK_RATIO("alluxio.worker.tieredstore.level%d.watermark.low.ratio", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.watermark\\.low\\.ratio"),
        USER_NETWORK_KEEPALIVE_TIME_MS("alluxio.user.network.%s.keepalive.time", "alluxio\\.user\\.network\\.(\\w+)\\.keepalive\\.time"),
        USER_NETWORK_KEEPALIVE_TIMEOUT_MS("alluxio.user.network.%s.keepalive.timeout", "alluxio\\.user\\.network\\.(\\w+)\\.keepalive\\.timeout"),
        USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE("alluxio.user.network.%s.max.inbound.message.size", "alluxio\\.user\\.network\\.(\\w+)\\.max\\.inbound\\.message\\.size"),
        USER_NETWORK_FLOWCONTROL_WINDOW("alluxio.user.network.%s.flowcontrol.window", "alluxio\\.user\\.network\\.(\\w+)\\.flowcontrol\\.window"),
        USER_NETWORK_NETTY_CHANNEL("alluxio.user.network.%s.netty.channel", "alluxio\\.user\\.network\\.(\\w+)\\.netty\\.channel"),
        USER_NETWORK_NETTY_WORKER_THREADS("alluxio.user.network.%s.netty.worker.threads", "alluxio\\.user\\.network\\.(\\w+)\\.netty\\.worker\\.threads"),
        USER_NETWORK_MAX_CONNECTIONS("alluxio.user.network.%s.max.connections", "alluxio\\.user\\.network\\.(\\w+)\\.max\\.connections"),
        TEST_DEPRECATED_TEMPLATE("alluxio.test.%s.format.deprecated.template", "alluxio\\.test\\.(\\w+)\\.format\\.deprecated\\.template");

        private static final String NESTED_GROUP = "nested";
        private final String mFormat;
        private final Pattern mPattern;
        private BiFunction<String, PropertyKey, PropertyKey> mPropertyCreator = PropertyCreators.access$500();

        private Template(String format, String re) {
            this.mFormat = format;
            this.mPattern = Pattern.compile(re);
        }

        private Template(String format, String re, BiFunction<String, PropertyKey, PropertyKey> propertyCreator) {
            this(format, re);
            this.mPropertyCreator = propertyCreator;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("format", (Object)this.mFormat).add("pattern", (Object)this.mPattern).toString();
        }

        public PropertyKey format(Object ... params) {
            return new PropertyKey(String.format(this.mFormat, params));
        }

        public boolean matches(String input) {
            Matcher matcher = this.mPattern.matcher(input);
            return matcher.matches();
        }

        public Matcher match(String input) {
            return this.mPattern.matcher(input);
        }

        @Nullable
        private PropertyKey getPropertyKey(String propertyName) {
            Matcher matcher = this.match(propertyName);
            if (!matcher.matches()) {
                return null;
            }
            String nestedKeyName = null;
            try {
                nestedKeyName = matcher.group(NESTED_GROUP);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            PropertyKey nestedProperty = null;
            if (nestedKeyName != null && PropertyKey.isValid(nestedKeyName)) {
                nestedProperty = PropertyKey.fromString(nestedKeyName);
            }
            return this.mPropertyCreator.apply(propertyName, nestedProperty);
        }

        private static class PropertyCreators {
            private static final BiFunction<String, PropertyKey, PropertyKey> DEFAULT_PROPERTY_CREATOR = PropertyCreators.fromBuilder(new Builder(""));
            private static final BiFunction<String, PropertyKey, PropertyKey> NESTED_UFS_PROPERTY_CREATOR = PropertyCreators.createNestedPropertyCreator(Scope.SERVER, ConsistencyCheckLevel.ENFORCE);
            private static final BiFunction<String, PropertyKey, PropertyKey> NESTED_JOURNAL_PROPERTY_CREATOR = PropertyCreators.createNestedPropertyCreator(Scope.MASTER, ConsistencyCheckLevel.ENFORCE);

            private PropertyCreators() {
            }

            private static BiFunction<String, PropertyKey, PropertyKey> fromBuilder(Builder builder) {
                return (name, baseProperty) -> builder.setName((String)name).buildUnregistered();
            }

            private static BiFunction<String, PropertyKey, PropertyKey> createNestedPropertyCreator(Scope scope, ConsistencyCheckLevel consistencyCheckLevel) {
                return (name, baseProperty) -> {
                    Builder builder = new Builder((String)name).setScope(scope).setConsistencyCheckLevel(consistencyCheckLevel);
                    if (baseProperty != null) {
                        builder.setDisplayType(baseProperty.getDisplayType());
                        builder.setDefaultSupplier(baseProperty.getDefaultSupplier());
                    }
                    return builder.buildUnregistered();
                };
            }

            static /* synthetic */ BiFunction access$200() {
                return NESTED_JOURNAL_PROPERTY_CREATOR;
            }

            static /* synthetic */ BiFunction access$300() {
                return NESTED_UFS_PROPERTY_CREATOR;
            }

            static /* synthetic */ BiFunction access$400(Builder x0) {
                return PropertyCreators.fromBuilder(x0);
            }

            static /* synthetic */ BiFunction access$500() {
                return DEFAULT_PROPERTY_CREATOR;
            }
        }
    }

    @ThreadSafe
    public static final class Name {
        public static final String CONF_DIR = "alluxio.conf.dir";
        public static final String CONF_DYNAMIC_UPDATE_ENABLED = "alluxio.conf.dynamic.update.enabled";
        public static final String CONF_VALIDATION_ENABLED = "alluxio.conf.validation.enabled";
        public static final String DEBUG = "alluxio.debug";
        public static final String EXTENSIONS_DIR = "alluxio.extensions.dir";
        public static final String HOME = "alluxio.home";
        public static final String INTEGRATION_MASTER_RESOURCE_CPU = "alluxio.integration.master.resource.cpu";
        public static final String INTEGRATION_MASTER_RESOURCE_MEM = "alluxio.integration.master.resource.mem";
        public static final String INTEGRATION_WORKER_RESOURCE_CPU = "alluxio.integration.worker.resource.cpu";
        public static final String INTEGRATION_WORKER_RESOURCE_MEM = "alluxio.integration.worker.resource.mem";
        public static final String INTEGRATION_YARN_WORKERS_PER_HOST_MAX = "alluxio.integration.yarn.workers.per.host.max";
        public static final String LOGGER_TYPE = "alluxio.logger.type";
        public static final String LOGS_DIR = "alluxio.logs.dir";
        public static final String METRICS_CONF_FILE = "alluxio.metrics.conf.file";
        public static final String METRICS_CONTEXT_SHUTDOWN_TIMEOUT = "alluxio.metrics.context.shutdown.timeout";
        public static final String NETWORK_CONNECTION_AUTH_TIMEOUT = "alluxio.network.connection.auth.timeout";
        public static final String NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT = "alluxio.network.connection.health.check.timeout";
        public static final String NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT = "alluxio.network.connection.server.shutdown.timeout";
        public static final String NETWORK_CONNECTION_SHUTDOWN_GRACEFUL_TIMEOUT = "alluxio.network.connection.shutdown.graceful.timeout";
        public static final String NETWORK_CONNECTION_SHUTDOWN_TIMEOUT = "alluxio.network.connection.shutdown.timeout";
        public static final String NETWORK_HOST_RESOLUTION_TIMEOUT_MS = "alluxio.network.host.resolution.timeout";
        public static final String NETWORK_IP_ADDRESS_USED = "alluxio.network.ip.address.used";
        public static final String SITE_CONF_DIR = "alluxio.site.conf.dir";
        public static final String TEST_MODE = "alluxio.test.mode";
        public static final String TMP_DIRS = "alluxio.tmp.dirs";
        public static final String USER_LOGS_DIR = "alluxio.user.logs.dir";
        public static final String VERSION = "alluxio.version";
        public static final String WEB_FILE_INFO_ENABLED = "alluxio.web.file.info.enabled";
        public static final String WEB_RESOURCES = "alluxio.web.resources";
        public static final String WEB_THREADS = "alluxio.web.threads";
        public static final String WEB_CORS_ENABLED = "alluxio.web.cors.enabled";
        public static final String WEB_REFRESH_INTERVAL = "alluxio.web.refresh.interval";
        public static final String WEB_UI_ENABLED = "alluxio.web.ui.enabled";
        public static final String WORK_DIR = "alluxio.work.dir";
        public static final String ZOOKEEPER_ADDRESS = "alluxio.zookeeper.address";
        public static final String ZOOKEEPER_CONNECTION_TIMEOUT = "alluxio.zookeeper.connection.timeout";
        public static final String ZOOKEEPER_ELECTION_PATH = "alluxio.zookeeper.election.path";
        public static final String ZOOKEEPER_ENABLED = "alluxio.zookeeper.enabled";
        public static final String ZOOKEEPER_LEADER_INQUIRY_RETRY_COUNT = "alluxio.zookeeper.leader.inquiry.retry";
        public static final String ZOOKEEPER_LEADER_PATH = "alluxio.zookeeper.leader.path";
        public static final String ZOOKEEPER_SESSION_TIMEOUT = "alluxio.zookeeper.session.timeout";
        public static final String ZOOKEEPER_AUTH_ENABLED = "alluxio.zookeeper.auth.enabled";
        public static final String ZOOKEEPER_LEADER_CONNECTION_ERROR_POLICY = "alluxio.zookeeper.leader.connection.error.policy";
        public static final String UNDERFS_ALLOW_SET_OWNER_FAILURE = "alluxio.underfs.allow.set.owner.failure";
        public static final String UNDERFS_CLEANUP_ENABLED = "alluxio.underfs.cleanup.enabled";
        public static final String UNDERFS_CLEANUP_INTERVAL = "alluxio.underfs.cleanup.interval";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_BASE_SLEEP_MS = "alluxio.underfs.eventual.consistency.retry.base.sleep";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_NUM = "alluxio.underfs.eventual.consistency.retry.max.num";
        public static final String UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_SLEEP_MS = "alluxio.underfs.eventual.consistency.retry.max.sleep";
        public static final String UNDERFS_LISTING_LENGTH = "alluxio.underfs.listing.length";
        public static final String UNDERFS_LOGGING_THRESHOLD = "alluxio.underfs.logging.threshold";
        public static final String UNDERFS_GCS_DEFAULT_MODE = "alluxio.underfs.gcs.default.mode";
        public static final String UNDERFS_GCS_DIRECTORY_SUFFIX = "alluxio.underfs.gcs.directory.suffix";
        public static final String UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.gcs.owner.id.to.username.mapping";
        public static final String UNDERFS_GCS_RETRY_INITIAL_DELAY_MS = "alluxio.underfs.gcs.retry.initial.delay";
        public static final String UNDERFS_GCS_RETRY_MAX_DELAY_MS = "alluxio.underfs.gcs.retry.max.delay";
        public static final String UNDERFS_GCS_RETRY_DELAY_MULTIPLIER = "alluxio.underfs.gcs.retry.delay.multiplier";
        public static final String UNDERFS_GCS_RETRY_JITTER = "alluxio.underfs.gcs.retry.jitter";
        public static final String UNDERFS_GCS_RETRY_TOTAL_DURATION_MS = "alluxio.underfs.gcs.retry.total.duration";
        public static final String UNDERFS_GCS_RETRY_MAX = "alluxio.underfs.gcs.retry.max";
        public static final String UNDERFS_GCS_VERSION = "alluxio.underfs.gcs.version";
        public static final String UNDERFS_HDFS_CONFIGURATION = "alluxio.underfs.hdfs.configuration";
        public static final String UNDERFS_HDFS_IMPL = "alluxio.underfs.hdfs.impl";
        public static final String UNDERFS_HDFS_PREFIXES = "alluxio.underfs.hdfs.prefixes";
        public static final String UNDERFS_HDFS_REMOTE = "alluxio.underfs.hdfs.remote";
        public static final String UNDERFS_LOCAL_SKIP_BROKEN_SYMLINKS = "alluxio.underfs.local.skip.broken.symlinks";
        public static final String UNDERFS_WEB_HEADER_LAST_MODIFIED = "alluxio.underfs.web.header.last.modified";
        public static final String UNDERFS_WEB_CONNECTION_TIMEOUT = "alluxio.underfs.web.connnection.timeout";
        public static final String UNDERFS_WEB_PARENT_NAMES = "alluxio.underfs.web.parent.names";
        public static final String UNDERFS_WEB_TITLES = "alluxio.underfs.web.titles";
        public static final String UNDERFS_VERSION = "alluxio.underfs.version";
        public static final String UNDERFS_OBJECT_STORE_BREADCRUMBS_ENABLED = "alluxio.underfs.object.store.breadcrumbs.enabled";
        public static final String UNDERFS_OBJECT_STORE_SERVICE_THREADS = "alluxio.underfs.object.store.service.threads";
        public static final String UNDERFS_OBJECT_STORE_SKIP_PARENT_DIRECTORY_CREATION = "alluxio.underfs.object.store.skip.parent.directory.creation";
        public static final String UNDERFS_OBJECT_STORE_MOUNT_SHARED_PUBLICLY = "alluxio.underfs.object.store.mount.shared.publicly";
        public static final String UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE = "alluxio.underfs.object.store.multi.range.chunk.size";
        public static final String UNDERFS_OSS_CONNECT_MAX = "alluxio.underfs.oss.connection.max";
        public static final String UNDERFS_OSS_CONNECT_TIMEOUT = "alluxio.underfs.oss.connection.timeout";
        public static final String UNDERFS_OSS_CONNECT_TTL = "alluxio.underfs.oss.connection.ttl";
        public static final String UNDERFS_OSS_SOCKET_TIMEOUT = "alluxio.underfs.oss.socket.timeout";
        public static final String UNDERFS_S3_BULK_DELETE_ENABLED = "alluxio.underfs.s3.bulk.delete.enabled";
        public static final String UNDERFS_S3_DEFAULT_MODE = "alluxio.underfs.s3.default.mode";
        public static final String UNDERFS_S3_DIRECTORY_SUFFIX = "alluxio.underfs.s3.directory.suffix";
        public static final String UNDERFS_S3_INHERIT_ACL = "alluxio.underfs.s3.inherit.acl";
        public static final String UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE = "alluxio.underfs.s3.intermediate.upload.clean.age";
        public static final String UNDERFS_S3_LIST_OBJECTS_V1 = "alluxio.underfs.s3.list.objects.v1";
        public static final String UNDERFS_S3_MAX_ERROR_RETRY = "alluxio.underfs.s3.max.error.retry";
        public static final String UNDERFS_S3_REQUEST_TIMEOUT = "alluxio.underfs.s3.request.timeout";
        public static final String UNDERFS_S3_SECURE_HTTP_ENABLED = "alluxio.underfs.s3.secure.http.enabled";
        public static final String UNDERFS_S3_SERVER_SIDE_ENCRYPTION_ENABLED = "alluxio.underfs.s3.server.side.encryption.enabled";
        public static final String UNDERFS_S3_SIGNER_ALGORITHM = "alluxio.underfs.s3.signer.algorithm";
        public static final String UNDERFS_S3_CONNECT_TTL = "alluxio.underfs.s3.connection.ttl";
        public static final String UNDERFS_S3_SOCKET_TIMEOUT = "alluxio.underfs.s3.socket.timeout";
        public static final String UNDERFS_S3_STREAMING_UPLOAD_ENABLED = "alluxio.underfs.s3.streaming.upload.enabled";
        public static final String UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE = "alluxio.underfs.s3.streaming.upload.partition.size";
        public static final String UNDERFS_S3_ADMIN_THREADS_MAX = "alluxio.underfs.s3.admin.threads.max";
        public static final String UNDERFS_S3_DISABLE_DNS_BUCKETS = "alluxio.underfs.s3.disable.dns.buckets";
        public static final String UNDERFS_S3_ENDPOINT = "alluxio.underfs.s3.endpoint";
        public static final String UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING = "alluxio.underfs.s3.owner.id.to.username.mapping";
        public static final String UNDERFS_S3_PROXY_HOST = "alluxio.underfs.s3.proxy.host";
        public static final String UNDERFS_S3_PROXY_PORT = "alluxio.underfs.s3.proxy.port";
        public static final String UNDERFS_S3_THREADS_MAX = "alluxio.underfs.s3.threads.max";
        public static final String UNDERFS_S3_UPLOAD_THREADS_MAX = "alluxio.underfs.s3.upload.threads.max";
        public static final String KODO_ENDPOINT = "alluxio.underfs.kodo.endpoint";
        public static final String KODO_DOWNLOAD_HOST = "alluxio.underfs.kodo.downloadhost";
        public static final String UNDERFS_KODO_CONNECT_TIMEOUT = "alluxio.underfs.kodo.connect.timeout";
        public static final String UNDERFS_KODO_REQUESTS_MAX = "alluxio.underfs.kodo.requests.max";
        public static final String UNDERFS_CEPHFS_AUTH_ID = "alluxio.underfs.cephfs.auth.id";
        public static final String UNDERFS_CEPHFS_CONF_FILE = "alluxio.underfs.cephfs.conf.file";
        public static final String UNDERFS_CEPHFS_CONF_OPTS = "alluxio.underfs.cephfs.conf.options";
        public static final String UNDERFS_CEPHFS_AUTH_KEY = "alluxio.underfs.cephfs.auth.key";
        public static final String UNDERFS_CEPHFS_AUTH_KEYFILE = "alluxio.underfs.cephfs.auth.keyfile";
        public static final String UNDERFS_CEPHFS_AUTH_KEYRING = "alluxio.underfs.cephfs.auth.keyring";
        public static final String UNDERFS_CEPHFS_MON_HOST = "alluxio.underfs.cephfs.mon.host";
        public static final String UNDERFS_CEPHFS_MDS_NAMESPACE = "alluxio.underfs.cephfs.mds.namespace";
        public static final String UNDERFS_CEPHFS_MOUNT_UID = "alluxio.underfs.cephfs.mount.uid";
        public static final String UNDERFS_CEPHFS_MOUNT_GID = "alluxio.underfs.cephfs.mount.gid";
        public static final String UNDERFS_CEPHFS_MOUNT_POINT = "alluxio.underfs.cephfs.mount.point";
        public static final String UNDERFS_CEPHFS_LOCALIZE_READS = "alluxio.underfs.cephfs.localize.reads";
        public static final String ABFS_CLIENT_ENDPOINT = "fs.azure.account.oauth2.client.endpoint";
        public static final String ABFS_CLIENT_ID = "fs.azure.account.oauth2.client.id";
        public static final String ABFS_CLIENT_SECRET = "fs.azure.account.oauth2.client.secret";
        public static final String COS_ACCESS_KEY = "fs.cos.access.key";
        public static final String COS_APP_ID = "fs.cos.app.id";
        public static final String COS_CONNECTION_MAX = "fs.cos.connection.max";
        public static final String COS_CONNECTION_TIMEOUT = "fs.cos.connection.timeout";
        public static final String COS_REGION = "fs.cos.region";
        public static final String COS_SECRET_KEY = "fs.cos.secret.key";
        public static final String COS_SOCKET_TIMEOUT = "fs.cos.socket.timeout";
        public static final String GCS_ACCESS_KEY = "fs.gcs.accessKeyId";
        public static final String GCS_SECRET_KEY = "fs.gcs.secretAccessKey";
        public static final String GCS_CREDENTIAL_PATH = "fs.gcs.credential.path";
        public static final String OSS_ACCESS_KEY = "fs.oss.accessKeyId";
        public static final String OSS_ENDPOINT_KEY = "fs.oss.endpoint";
        public static final String OSS_SECRET_KEY = "fs.oss.accessKeySecret";
        public static final String S3A_ACCESS_KEY = "aws.accessKeyId";
        public static final String S3A_SECRET_KEY = "aws.secretKey";
        public static final String SWIFT_AUTH_METHOD_KEY = "fs.swift.auth.method";
        public static final String SWIFT_AUTH_URL_KEY = "fs.swift.auth.url";
        public static final String SWIFT_PASSWORD_KEY = "fs.swift.password";
        public static final String SWIFT_REGION_KEY = "fs.swift.region";
        public static final String SWIFT_SIMULATION = "fs.swift.simulation";
        public static final String SWIFT_TENANT_KEY = "fs.swift.tenant";
        public static final String SWIFT_USER_KEY = "fs.swift.user";
        public static final String KODO_ACCESS_KEY = "fs.kodo.accesskey";
        public static final String KODO_SECRET_KEY = "fs.kodo.secretkey";
        public static final String MASTER_ASYNC_PERSIST_SIZE_VALIDATION = "alluxio.master.async.persist.size.validation";
        public static final String MASTER_AUDIT_LOGGING_ENABLED = "alluxio.master.audit.logging.enabled";
        public static final String MASTER_AUDIT_LOGGING_QUEUE_CAPACITY = "alluxio.master.audit.logging.queue.capacity";
        public static final String MASTER_BACKUP_DIRECTORY = "alluxio.master.backup.directory";
        public static final String MASTER_BACKUP_ENTRY_BUFFER_COUNT = "alluxio.master.backup.entry.buffer.count";
        public static final String MASTER_BACKUP_DELEGATION_ENABLED = "alluxio.master.backup.delegation.enabled";
        public static final String MASTER_BACKUP_TRANSPORT_TIMEOUT = "alluxio.master.backup.transport.timeout";
        public static final String MASTER_BACKUP_HEARTBEAT_INTERVAL = "alluxio.master.backup.heartbeat.interval";
        public static final String MASTER_BACKUP_CONNECT_INTERVAL_MIN = "alluxio.master.backup.connect.interval.min";
        public static final String MASTER_BACKUP_CONNECT_INTERVAL_MAX = "alluxio.master.backup.connect.interval.max";
        public static final String MASTER_BACKUP_ABANDON_TIMEOUT = "alluxio.master.backup.abandon.timeout";
        public static final String MASTER_BACKUP_STATE_LOCK_EXCLUSIVE_DURATION = "alluxio.master.backup.state.lock.exclusive.duration";
        public static final String MASTER_BACKUP_STATE_LOCK_INTERRUPT_CYCLE_ENABLED = "alluxio.master.backup.state.lock.interrupt.cycle.enabled";
        public static final String MASTER_BACKUP_STATE_LOCK_FORCED_DURATION = "alluxio.master.backup.state.lock.forced.duration";
        public static final String MASTER_BACKUP_STATE_LOCK_INTERRUPT_CYCLE_INTERVAL = "alluxio.master.backup.state.lock.interrupt.cycle.interval";
        public static final String MASTER_BACKUP_SUSPEND_TIMEOUT = "alluxio.master.backup.suspend.timeout";
        public static final String MASTER_SHELL_BACKUP_STATE_LOCK_GRACE_MODE = "alluxio.master.shell.backup.state.lock.grace.mode";
        public static final String MASTER_SHELL_BACKUP_STATE_LOCK_TRY_DURATION = "alluxio.master.shell.backup.state.lock.try.duration";
        public static final String MASTER_SHELL_BACKUP_STATE_LOCK_SLEEP_DURATION = "alluxio.master.shell.backup.state.lock.sleep.duration";
        public static final String MASTER_SHELL_BACKUP_STATE_LOCK_TIMEOUT = "alluxio.master.shell.backup.state.lock.timeout";
        public static final String MASTER_DAILY_BACKUP_ENABLED = "alluxio.master.daily.backup.enabled";
        public static final String MASTER_DAILY_BACKUP_FILES_RETAINED = "alluxio.master.daily.backup.files.retained";
        public static final String MASTER_DAILY_BACKUP_TIME = "alluxio.master.daily.backup.time";
        public static final String MASTER_DAILY_BACKUP_STATE_LOCK_GRACE_MODE = "alluxio.master.daily.backup.state.lock.grace.mode";
        public static final String MASTER_DAILY_BACKUP_STATE_LOCK_TRY_DURATION = "alluxio.master.daily.backup.state.lock.try.duration";
        public static final String MASTER_DAILY_BACKUP_STATE_LOCK_SLEEP_DURATION = "alluxio.master.daily.backup.state.lock.sleep.duration";
        public static final String MASTER_DAILY_BACKUP_STATE_LOCK_TIMEOUT = "alluxio.master.daily.backup.state.lock.timeout";
        public static final String MASTER_BIND_HOST = "alluxio.master.bind.host";
        public static final String MASTER_CLUSTER_METRICS_UPDATE_INTERVAL = "alluxio.master.cluster.metrics.update.interval";
        public static final String MASTER_FILE_ACCESS_TIME_JOURNAL_FLUSH_INTERVAL = "alluxio.master.file.access.time.journal.flush.interval";
        public static final String MASTER_FILE_ACCESS_TIME_UPDATE_PRECISION = "alluxio.master.file.access.time.update.precision";
        public static final String MASTER_FILE_ACCESS_TIME_UPDATER_SHUTDOWN_TIMEOUT = "alluxio.master.file.access.time.updater.shutdown.timeout";
        public static final String MASTER_FORMAT_FILE_PREFIX = "alluxio.master.format.file.prefix";
        public static final String MASTER_STANDBY_HEARTBEAT_INTERVAL = "alluxio.master.standby.heartbeat.interval";
        public static final String MASTER_LOST_WORKER_DETECTION_INTERVAL = "alluxio.master.lost.worker.detection.interval";
        public static final String MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL = "alluxio.master.lost.worker.file.detection.interval";
        public static final String MASTER_HEARTBEAT_TIMEOUT = "alluxio.master.heartbeat.timeout";
        public static final String MASTER_HOSTNAME = "alluxio.master.hostname";
        public static final String MASTER_LOCK_POOL_INITSIZE = "alluxio.master.lock.pool.initsize";
        public static final String MASTER_LOCK_POOL_LOW_WATERMARK = "alluxio.master.lock.pool.low.watermark";
        public static final String MASTER_LOCK_POOL_HIGH_WATERMARK = "alluxio.master.lock.pool.high.watermark";
        public static final String MASTER_LOCK_POOL_CONCURRENCY_LEVEL = "alluxio.master.lock.pool.concurrency.level";
        public static final String MASTER_JOURNAL_CATCHUP_PROTECT_ENABLED = "alluxio.master.journal.catchup.protect.enabled";
        public static final String MASTER_JOURNAL_EXIT_ON_DEMOTION = "alluxio.master.journal.exit.on.demotion";
        public static final String MASTER_JOURNAL_FLUSH_BATCH_TIME_MS = "alluxio.master.journal.flush.batch.time";
        public static final String MASTER_JOURNAL_FLUSH_TIMEOUT_MS = "alluxio.master.journal.flush.timeout";
        public static final String MASTER_JOURNAL_FLUSH_RETRY_INTERVAL = "alluxio.master.journal.retry.interval";
        public static final String MASTER_JOURNAL_FOLDER = "alluxio.master.journal.folder";
        public static final String MASTER_JOURNAL_INIT_FROM_BACKUP = "alluxio.master.journal.init.from.backup";
        public static final String MASTER_JOURNAL_SPACE_MONITOR_INTERVAL = "alluxio.master.journal.space.monitor.interval";
        public static final String MASTER_JOURNAL_SPACE_MONITOR_PERCENT_FREE_THRESHOLD = "alluxio.master.journal.space.monitor.percent.free.threshold";
        public static final String MASTER_JOURNAL_TOLERATE_CORRUPTION = "alluxio.master.journal.tolerate.corruption";
        public static final String MASTER_JOURNAL_TYPE = "alluxio.master.journal.type";
        public static final String MASTER_JOURNAL_LOG_SIZE_BYTES_MAX = "alluxio.master.journal.log.size.bytes.max";
        public static final String MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS = "alluxio.master.journal.tailer.shutdown.quiet.wait.time";
        public static final String MASTER_JOURNAL_TAILER_SLEEP_TIME_MS = "alluxio.master.journal.tailer.sleep.time";
        public static final String MASTER_RPC_ADDRESSES = "alluxio.master.rpc.addresses";
        public static final String MASTER_EMBEDDED_JOURNAL_PROXY_HOST = "alluxio.master.embedded.journal.bind.host";
        public static final String MASTER_EMBEDDED_JOURNAL_ADDRESSES = "alluxio.master.embedded.journal.addresses";
        public static final String MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT = "alluxio.master.embedded.journal.election.timeout.max";
        public static final String MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT = "alluxio.master.embedded.journal.election.timeout.min";
        public static final String MASTER_EMBEDDED_JOURNAL_CATCHUP_RETRY_WAIT = "alluxio.master.embedded.journal.catchup.retry.wait";
        public static final String MASTER_EMBEDDED_JOURNAL_ENTRY_SIZE_MAX = "alluxio.master.embedded.journal.entry.size.max";
        public static final String MASTER_EMBEDDED_JOURNAL_FLUSH_SIZE_MAX = "alluxio.master.embedded.journal.flush.size.max";
        public static final String MASTER_EMBEDDED_JOURNAL_PORT = "alluxio.master.embedded.journal.port";
        public static final String MASTER_EMBEDDED_JOURNAL_RETRY_CACHE_EXPIRY_TIME = "alluxio.master.embedded.journal.retry.cache.expiry.time";
        public static final String MASTER_EMBEDDED_JOURNAL_WRITE_LOCAL_FIRST_ENABLED = "alluxio.master.embedded.journal.write.local.first.enabled";
        public static final String MASTER_EMBEDDED_JOURNAL_WRITE_REMOTE_ENABLED = "alluxio.master.embedded.journal.write.remote.enabled";
        public static final String MASTER_EMBEDDED_JOURNAL_WRITE_TIMEOUT = "alluxio.master.embedded.journal.write.timeout";
        public static final String MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_CHUNK_SIZE = "alluxio.master.embedded.journal.snapshot.replication.chunk.size";
        public static final String MASTER_EMBEDDED_JOURNAL_TRANSPORT_REQUEST_TIMEOUT_MS = "alluxio.master.embedded.journal.transport.request.timeout.ms";
        public static final String MASTER_EMBEDDED_JOURNAL_TRANSPORT_MAX_INBOUND_MESSAGE_SIZE = "alluxio.master.embedded.journal.transport.max.inbound.message.size";
        public static final String MASTER_KEYTAB_KEY_FILE = "alluxio.master.keytab.file";
        public static final String MASTER_METADATA_SYNC_CONCURRENCY_LEVEL = "alluxio.master.metadata.sync.concurrency.level";
        public static final String MASTER_METADATA_SYNC_EXECUTOR_POOL_SIZE = "alluxio.master.metadata.sync.executor.pool.size";
        public static final String MASTER_METADATA_SYNC_REPORT_FAILURE = "alluxio.master.metadata.sync.report.failure";
        public static final String MASTER_METADATA_SYNC_UFS_PREFETCH_POOL_SIZE = "alluxio.master.metadata.sync.ufs.prefetch.pool.size";
        public static final String MASTER_METASTORE = "alluxio.master.metastore";
        public static final String MASTER_METASTORE_DIR = "alluxio.master.metastore.dir";
        public static final String MASTER_METASTORE_INODE_CACHE_EVICT_BATCH_SIZE = "alluxio.master.metastore.inode.cache.evict.batch.size";
        public static final String MASTER_METASTORE_INODE_CACHE_HIGH_WATER_MARK_RATIO = "alluxio.master.metastore.inode.cache.high.water.mark.ratio";
        public static final String MASTER_METASTORE_INODE_CACHE_LOW_WATER_MARK_RATIO = "alluxio.master.metastore.inode.cache.low.water.mark.ratio";
        public static final String MASTER_METASTORE_INODE_CACHE_MAX_SIZE = "alluxio.master.metastore.inode.cache.max.size";
        public static final String MASTER_METASTORE_INODE_ITERATION_CRAWLER_COUNT = "alluxio.master.metastore.inode.iteration.crawler.count";
        public static final String MASTER_METASTORE_INODE_ENUMERATOR_BUFFER_COUNT = "alluxio.master.metastore.inode.enumerator.buffer.count";
        public static final String MASTER_METASTORE_ITERATOR_READAHEAD_SIZE = "alluxio.master.metastore.iterator.readahead.size";
        public static final String MASTER_METASTORE_INODE_INHERIT_OWNER_AND_GROUP = "alluxio.master.metastore.inode.inherit.owner.and.group";
        public static final String MASTER_PERSISTENCE_CHECKER_INTERVAL_MS = "alluxio.master.persistence.checker.interval";
        public static final String MASTER_METRICS_HEAP_ENABLED = "alluxio.master.metrics.heap.enabled";
        public static final String MASTER_METRICS_SERVICE_THREADS = "alluxio.master.metrics.service.threads";
        public static final String MASTER_METRICS_TIME_SERIES_INTERVAL = "alluxio.master.metrics.time.series.interval";
        public static final String MASTER_METRICS_FILE_SIZE_DISTRIBUTION_BUCKETS = "alluxio.master.metrics.file.size.distribution.buckets";
        public static final String MASTER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = "alluxio.master.network.max.inbound.message.size";
        public static final String MASTER_PERSISTENCE_INITIAL_INTERVAL_MS = "alluxio.master.persistence.initial.interval";
        public static final String MASTER_PERSISTENCE_MAX_TOTAL_WAIT_TIME_MS = "alluxio.master.persistence.max.total.wait.time";
        public static final String MASTER_PERSISTENCE_MAX_INTERVAL_MS = "alluxio.master.persistence.max.interval";
        public static final String MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS = "alluxio.master.persistence.scheduler.interval";
        public static final String MASTER_PERSISTENCE_BLACKLIST = "alluxio.master.persistence.blacklist";
        public static final String MASTER_LOG_CONFIG_REPORT_HEARTBEAT_INTERVAL = "alluxio.master.log.config.report.heartbeat.interval";
        public static final String MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_REPAIR = "alluxio.master.periodic.block.integrity.check.repair";
        public static final String MASTER_PERIODIC_BLOCK_INTEGRITY_CHECK_INTERVAL = "alluxio.master.periodic.block.integrity.check.interval";
        public static final String MASTER_PRINCIPAL = "alluxio.master.principal";
        public static final String MASTER_REPLICATION_CHECK_INTERVAL_MS = "alluxio.master.replication.check.interval";
        public static final String MASTER_RPC_PORT = "alluxio.master.rpc.port";
        public static final String MASTER_RPC_EXECUTOR_PARALLELISM = "alluxio.master.rpc.executor.parallelism";
        public static final String MASTER_RPC_EXECUTOR_MIN_RUNNABLE = "alluxio.master.rpc.executor.min.runnable";
        public static final String MASTER_RPC_EXECUTOR_CORE_POOL_SIZE = "alluxio.master.rpc.executor.core.pool.size";
        public static final String MASTER_RPC_EXECUTOR_MAX_POOL_SIZE = "alluxio.master.rpc.executor.max.pool.size";
        public static final String MASTER_RPC_EXECUTOR_KEEPALIVE = "alluxio.master.rpc.executor.keepalive";
        public static final String MASTER_SERVING_THREAD_TIMEOUT = "alluxio.master.serving.thread.timeout";
        public static final String MASTER_SKIP_ROOT_ACL_CHECK = "alluxio.master.skip.root.acl.check";
        public static final String MASTER_STARTUP_BLOCK_INTEGRITY_CHECK_ENABLED = "alluxio.master.startup.block.integrity.check.enabled";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL0_ALIAS = "alluxio.master.tieredstore.global.level0.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL1_ALIAS = "alluxio.master.tieredstore.global.level1.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVEL2_ALIAS = "alluxio.master.tieredstore.global.level2.alias";
        public static final String MASTER_TIERED_STORE_GLOBAL_LEVELS = "alluxio.master.tieredstore.global.levels";
        public static final String MASTER_TIERED_STORE_GLOBAL_MEDIUMTYPE = "alluxio.master.tieredstore.global.mediumtype";
        public static final String MASTER_TTL_CHECKER_INTERVAL_MS = "alluxio.master.ttl.checker.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_INTERVAL = "alluxio.master.ufs.active.sync.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_MAX_ACTIVITIES = "alluxio.master.ufs.active.sync.max.activities";
        public static final String MASTER_UFS_ACTIVE_SYNC_THREAD_POOL_SIZE = "alluxio.master.ufs.active.sync.thread.pool.size";
        public static final String MASTER_UFS_ACTIVE_SYNC_POLL_TIMEOUT = "alluxio.master.ufs.active.sync.poll.timeout";
        public static final String MASTER_UFS_ACTIVE_SYNC_EVENT_RATE_INTERVAL = "alluxio.master.ufs.active.sync.event.rate.interval";
        public static final String MASTER_UFS_ACTIVE_SYNC_MAX_AGE = "alluxio.master.ufs.active.sync.max.age";
        public static final String MASTER_UFS_ACTIVE_SYNC_INITIAL_SYNC_ENABLED = "alluxio.master.ufs.active.sync.initial.sync.enabled";
        public static final String MASTER_UFS_ACTIVE_SYNC_RETRY_TIMEOUT = "alluxio.master.ufs.active.sync.retry.timeout";
        public static final String MASTER_UFS_ACTIVE_SYNC_POLL_BATCH_SIZE = "alluxio.master.ufs.active.sync.poll.batch.size";
        public static final String MASTER_UFS_BLOCK_LOCATION_CACHE_CAPACITY = "alluxio.master.ufs.block.location.cache.capacity";
        public static final String MASTER_UFS_JOURNAL_MAX_CATCHUP_TIME = "alluxio.master.ufs.journal.max.catchup.time";
        public static final String MASTER_UFS_MANAGED_BLOCKING_ENABLED = "alluxio.master.ufs.managed.blocking.enabled";
        public static final String MASTER_UFS_PATH_CACHE_CAPACITY = "alluxio.master.ufs.path.cache.capacity";
        public static final String MASTER_UFS_PATH_CACHE_THREADS = "alluxio.master.ufs.path.cache.threads";
        public static final String MASTER_UNSAFE_DIRECT_PERSIST_OBJECT_ENABLED = "alluxio.master.unsafe.direct.persist.object.enabled";
        public static final String MASTER_UPDATE_CHECK_ENABLED = "alluxio.master.update.check.enabled";
        public static final String MASTER_UPDATE_CHECK_INTERVAL = "alluxio.master.update.check.interval";
        public static final String MASTER_WEB_BIND_HOST = "alluxio.master.web.bind.host";
        public static final String MASTER_WEB_HOSTNAME = "alluxio.master.web.hostname";
        public static final String MASTER_WEB_PORT = "alluxio.master.web.port";
        public static final String MASTER_WEB_JOURNAL_CHECKPOINT_WARNING_THRESHOLD_TIME = "alluxio.master.journal.checkpoint.warning.threshold.time";
        public static final String MASTER_WHITELIST = "alluxio.master.whitelist";
        public static final String MASTER_WORKER_CONNECT_WAIT_TIME = "alluxio.master.worker.connect.wait.time";
        public static final String MASTER_WORKER_INFO_CACHE_REFRESH_TIME = "alluxio.master.worker.info.cache.refresh.time";
        public static final String MASTER_WORKER_TIMEOUT_MS = "alluxio.master.worker.timeout";
        public static final String MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES = "alluxio.master.journal.checkpoint.period.entries";
        public static final String MASTER_JOURNAL_GC_PERIOD_MS = "alluxio.master.journal.gc.period";
        public static final String MASTER_JOURNAL_GC_THRESHOLD_MS = "alluxio.master.journal.gc.threshold";
        public static final String MASTER_JOURNAL_TEMPORARY_FILE_GC_THRESHOLD_MS = "alluxio.master.journal.temporary.file.gc.threshold";
        public static final String MASTER_FILE_SYSTEM_LISTSTATUS_RESULTS_PER_MESSAGE = "alluxio.master.filesystem.liststatus.result.message.length";
        public static final String SECONDARY_MASTER_METASTORE_DIR = "alluxio.secondary.master.metastore.dir";
        public static final String WORKER_ALLOCATOR_CLASS = "alluxio.worker.allocator.class";
        public static final String WORKER_BIND_HOST = "alluxio.worker.bind.host";
        public static final String WORKER_BLOCK_HEARTBEAT_INTERVAL_MS = "alluxio.worker.block.heartbeat.interval";
        public static final String WORKER_BLOCK_HEARTBEAT_TIMEOUT_MS = "alluxio.worker.block.heartbeat.timeout";
        public static final String WORKER_CONTAINER_HOSTNAME = "alluxio.worker.container.hostname";
        public static final String WORKER_DATA_FOLDER = "alluxio.worker.data.folder";
        public static final String WORKER_DATA_FOLDER_PERMISSIONS = "alluxio.worker.data.folder.permissions";
        public static final String WORKER_DATA_SERVER_DOMAIN_SOCKET_ADDRESS = "alluxio.worker.data.server.domain.socket.address";
        public static final String WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID = "alluxio.worker.data.server.domain.socket.as.uuid";
        public static final String WORKER_DATA_TMP_FOLDER = "alluxio.worker.data.folder.tmp";
        public static final String WORKER_DATA_TMP_SUBDIR_MAX = "alluxio.worker.data.tmp.subdir.max";
        public static final String WORKER_EVICTOR_CLASS = "alluxio.worker.evictor.class";
        public static final String WORKER_BLOCK_ANNOTATOR_CLASS = "alluxio.worker.block.annotator.class";
        public static final String WORKER_BLOCK_ANNOTATOR_LRFU_ATTENUATION_FACTOR = "alluxio.worker.block.annotator.lrfu.attenuation.factor";
        public static final String WORKER_BLOCK_ANNOTATOR_LRFU_STEP_FACTOR = "alluxio.worker.block.annotator.lrfu.step.factor";
        public static final String WORKER_FUSE_ENABLED = "alluxio.worker.fuse.enabled";
        public static final String WORKER_FUSE_MOUNT_ALLUXIO_PATH = "alluxio.worker.fuse.mount.alluxio.path";
        public static final String WORKER_FUSE_MOUNT_OPTIONS = "alluxio.worker.fuse.mount.options";
        public static final String WORKER_FUSE_MOUNT_POINT = "alluxio.worker.fuse.mount.point";
        public static final String WORKER_MANAGEMENT_TIER_ALIGN_RESERVED_BYTES = "alluxio.worker.management.tier.align.reserved.bytes";
        public static final String WORKER_MANAGEMENT_BACKOFF_STRATEGY = "alluxio.worker.management.backoff.strategy";
        public static final String WORKER_MANAGEMENT_LOAD_DETECTION_COOL_DOWN_TIME = "alluxio.worker.management.load.detection.cool.down.time";
        public static final String WORKER_MANAGEMENT_TASK_THREAD_COUNT = "alluxio.worker.management.task.thread.count";
        public static final String WORKER_MANAGEMENT_BLOCK_TRANSFER_CONCURRENCY_LIMIT = "alluxio.worker.management.block.transfer.concurrency.limit";
        public static final String WORKER_MANAGEMENT_TIER_ALIGN_ENABLED = "alluxio.worker.management.tier.align.enabled";
        public static final String WORKER_MANAGEMENT_TIER_PROMOTE_ENABLED = "alluxio.worker.management.tier.promote.enabled";
        public static final String WORKER_MANAGEMENT_TIER_SWAP_RESTORE_ENABLED = "alluxio.worker.management.tier.swap.restore.enabled";
        public static final String WORKER_MANAGEMENT_TIER_ALIGN_RANGE = "alluxio.worker.management.tier.align.range";
        public static final String WORKER_MANAGEMENT_TIER_PROMOTE_RANGE = "alluxio.worker.management.tier.promote.range";
        public static final String WORKER_MANAGEMENT_TIER_PROMOTE_QUOTA_PERCENT = "alluxio.worker.management.tier.promote.quota.percent";
        public static final String WORKER_FREE_SPACE_TIMEOUT = "alluxio.worker.free.space.timeout";
        public static final String WORKER_HOSTNAME = "alluxio.worker.hostname";
        public static final String WORKER_KEYTAB_FILE = "alluxio.worker.keytab.file";
        public static final String WORKER_MASTER_CONNECT_RETRY_TIMEOUT = "alluxio.worker.master.connect.retry.timeout";
        public static final String WORKER_MASTER_PERIODICAL_RPC_TIMEOUT = "alluxio.worker.master.periodical.rpc.timeout";
        public static final String WORKER_MEMORY_SIZE = "alluxio.worker.memory.size";
        public static final String WORKER_NETWORK_ASYNC_CACHE_MANAGER_THREADS_MAX = "alluxio.worker.network.async.cache.manager.threads.max";
        public static final String WORKER_NETWORK_ASYNC_CACHE_MANAGER_QUEUE_MAX = "alluxio.worker.network.async.cache.manager.queue.max";
        public static final String WORKER_NETWORK_BLOCK_READER_THREADS_MAX = "alluxio.worker.network.block.reader.threads.max";
        public static final String WORKER_NETWORK_BLOCK_WRITER_THREADS_MAX = "alluxio.worker.network.block.writer.threads.max";
        public static final String WORKER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = "alluxio.worker.network.writer.buffer.size.messages";
        public static final String WORKER_NETWORK_FLOWCONTROL_WINDOW = "alluxio.worker.network.flowcontrol.window";
        public static final String WORKER_NETWORK_KEEPALIVE_TIME_MS = "alluxio.worker.network.keepalive.time";
        public static final String WORKER_NETWORK_KEEPALIVE_TIMEOUT_MS = "alluxio.worker.network.keepalive.timeout";
        public static final String WORKER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = "alluxio.worker.network.max.inbound.message.size";
        public static final String WORKER_NETWORK_NETTY_BOSS_THREADS = "alluxio.worker.network.netty.boss.threads";
        public static final String WORKER_NETWORK_NETTY_CHANNEL = "alluxio.worker.network.netty.channel";
        public static final String WORKER_NETWORK_NETTY_SHUTDOWN_QUIET_PERIOD = "alluxio.worker.network.netty.shutdown.quiet.period";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_HIGH = "alluxio.worker.network.netty.watermark.high";
        public static final String WORKER_NETWORK_NETTY_WATERMARK_LOW = "alluxio.worker.network.netty.watermark.low";
        public static final String WORKER_NETWORK_NETTY_WORKER_THREADS = "alluxio.worker.network.netty.worker.threads";
        public static final String WORKER_NETWORK_READER_BUFFER_SIZE_BYTES = "alluxio.worker.network.reader.buffer.size";
        public static final String WORKER_NETWORK_READER_MAX_CHUNK_SIZE_BYTES = "alluxio.worker.network.reader.max.chunk.size.bytes";
        public static final String WORKER_NETWORK_SHUTDOWN_TIMEOUT = "alluxio.worker.network.shutdown.timeout";
        public static final String WORKER_NETWORK_ZEROCOPY_ENABLED = "alluxio.worker.network.zerocopy.enabled";
        public static final String WORKER_REMOTE_IO_SLOW_THRESHOLD = "alluxio.worker.remote.io.slow.threshold";
        public static final String WORKER_BLOCK_MASTER_CLIENT_POOL_SIZE = "alluxio.worker.block.master.client.pool.size";
        public static final String WORKER_PRINCIPAL = "alluxio.worker.principal";
        public static final String WORKER_RAMDISK_SIZE = "alluxio.worker.ramdisk.size";
        public static final String WORKER_REVIEWER_PROBABILISTIC_HARDLIMIT_BYTES = "alluxio.worker.reviewer.probabilistic.hardlimit.bytes";
        public static final String WORKER_REVIEWER_PROBABILISTIC_SOFTLIMIT_BYTES = "alluxio.worker.reviewer.probabilistic.softlimit.bytes";
        public static final String WORKER_REVIEWER_CLASS = "alluxio.worker.reviewer.class";
        public static final String WORKER_RPC_PORT = "alluxio.worker.rpc.port";
        public static final String WORKER_SESSION_TIMEOUT_MS = "alluxio.worker.session.timeout";
        public static final String WORKER_STORAGE_CHECKER_ENABLED = "alluxio.worker.storage.checker.enabled";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCK_READERS = "alluxio.worker.tieredstore.block.lock.readers";
        public static final String WORKER_TIERED_STORE_BLOCK_LOCKS = "alluxio.worker.tieredstore.block.locks";
        public static final String WORKER_TIERED_STORE_FREE_AHEAD_BYTES = "alluxio.worker.tieredstore.free.ahead.bytes";
        public static final String WORKER_TIERED_STORE_LEVELS = "alluxio.worker.tieredstore.levels";
        public static final String WORKER_WEB_BIND_HOST = "alluxio.worker.web.bind.host";
        public static final String WORKER_WEB_HOSTNAME = "alluxio.worker.web.hostname";
        public static final String WORKER_WEB_PORT = "alluxio.worker.web.port";
        public static final String WORKER_UFS_BLOCK_OPEN_TIMEOUT_MS = "alluxio.worker.ufs.block.open.timeout";
        public static final String WORKER_UFS_INSTREAM_CACHE_EXPIRATION_TIME = "alluxio.worker.ufs.instream.cache.expiration.time";
        public static final String WORKER_UFS_INSTREAM_CACHE_ENABLED = "alluxio.worker.ufs.instream.cache.enabled";
        public static final String WORKER_UFS_INSTREAM_CACHE_MAX_SIZE = "alluxio.worker.ufs.instream.cache.max.size";
        public static final String PROXY_S3_WRITE_TYPE = "alluxio.proxy.s3.writetype";
        public static final String PROXY_S3_DELETE_TYPE = "alluxio.proxy.s3.deletetype";
        public static final String PROXY_S3_MULTIPART_TEMPORARY_DIR_SUFFIX = "alluxio.proxy.s3.multipart.temporary.dir.suffix";
        public static final String PROXY_STREAM_CACHE_TIMEOUT_MS = "alluxio.proxy.stream.cache.timeout";
        public static final String PROXY_WEB_BIND_HOST = "alluxio.proxy.web.bind.host";
        public static final String PROXY_WEB_HOSTNAME = "alluxio.proxy.web.hostname";
        public static final String PROXY_WEB_PORT = "alluxio.proxy.web.port";
        public static final String LOCALITY_ORDER = "alluxio.locality.order";
        public static final String LOCALITY_SCRIPT = "alluxio.locality.script";
        public static final String LOCALITY_COMPARE_NODE_IP = "alluxio.locality.compare.node.ip";
        public static final String LOGSERVER_HOSTNAME = "alluxio.logserver.hostname";
        public static final String LOGSERVER_LOGS_DIR = "alluxio.logserver.logs.dir";
        public static final String LOGSERVER_PORT = "alluxio.logserver.port";
        public static final String LOGSERVER_THREADS_MAX = "alluxio.logserver.threads.max";
        public static final String LOGSERVER_THREADS_MIN = "alluxio.logserver.threads.min";
        public static final String USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES = "alluxio.user.block.avoid.eviction.policy.reserved.size.bytes";
        public static final String USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MIN = "alluxio.user.block.master.client.pool.size.min";
        public static final String USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX = "alluxio.user.block.master.client.pool.size.max";
        public static final String USER_BLOCK_MASTER_CLIENT_POOL_GC_INTERVAL_MS = "alluxio.user.block.master.client.pool.gc.interval";
        public static final String USER_BLOCK_MASTER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.block.master.client.pool.gc.threshold";
        public static final String USER_BLOCK_READ_METRICS_ENABLED = "alluxio.user.block.read.metrics.enabled";
        public static final String USER_BLOCK_REMOTE_READ_BUFFER_SIZE_BYTES = "alluxio.user.block.remote.read.buffer.size.bytes";
        public static final String USER_BLOCK_SIZE_BYTES_DEFAULT = "alluxio.user.block.size.bytes.default";
        public static final String USER_BLOCK_READ_RETRY_SLEEP_MIN = "alluxio.user.block.read.retry.sleep.base";
        public static final String USER_BLOCK_READ_RETRY_SLEEP_MAX = "alluxio.user.block.read.retry.sleep.max";
        public static final String USER_BLOCK_READ_RETRY_MAX_DURATION = "alluxio.user.block.read.retry.max.duration";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.block.worker.client.pool.gc.threshold";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_MIN = "alluxio.user.block.worker.client.pool.min";
        public static final String USER_BLOCK_WORKER_CLIENT_POOL_MAX = "alluxio.user.block.worker.client.pool.max";
        public static final String USER_BLOCK_WRITE_LOCATION_POLICY = "alluxio.user.block.write.location.policy.class";
        public static final String USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED = "alluxio.user.client.cache.async.restore.enabled";
        public static final String USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED = "alluxio.user.client.cache.async.write.enabled";
        public static final String USER_CLIENT_CACHE_ASYNC_WRITE_THREADS = "alluxio.user.client.cache.async.write.threads";
        public static final String USER_CLIENT_CACHE_ENABLED = "alluxio.user.client.cache.enabled";
        public static final String USER_CLIENT_CACHE_FILTER_CLASS = "alluxio.user.client.cache.filter.class";
        public static final String USER_CLIENT_CACHE_FILTER_CONFIG_FILE = "alluxio.user.client.cache.filter.config-file";
        public static final String USER_CLIENT_CACHE_EVICTION_RETRIES = "alluxio.user.client.cache.eviction.retries";
        public static final String USER_CLIENT_CACHE_EVICTOR_CLASS = "alluxio.user.client.cache.evictor.class";
        public static final String USER_CLIENT_CACHE_EVICTOR_LFU_LOGBASE = "alluxio.user.client.cache.evictor.lfu.logbase";
        public static final String USER_CLIENT_CACHE_EVICTOR_NONDETERMINISTIC_ENABLED = "alluxio.user.client.cache.evictor.nondeterministic.enabled";
        public static final String USER_CLIENT_CACHE_SCOPED_METRICS_COLLECTING_TYPE = "alluxio.user.client.cache.metrics.breakdown.collecting.type";
        public static final String USER_CLIENT_CACHE_SHADOW_ENABLED = "alluxio.user.client.cache.shadow.enabled";
        public static final String USER_CLIENT_CACHE_SHADOW_METRICS_BREAKDOWN_ENABLED = "alluxio.user.client.cache.shadow.metrics.breakdown.enabled";
        public static final String USER_CLIENT_CACHE_SHADOW_WINDOW = "alluxio.user.client.cache.shadow.window";
        public static final String USER_CLIENT_CACHE_SHADOW_MEMORY_OVERHEAD = "alluxio.user.client.cache.shadow.memory.overhead";
        public static final String USER_CLIENT_CACHE_SHADOW_BLOOMFILTER_NUM = "alluxio.user.client.cache.shadow.bloomfilter.num";
        public static final String USER_CLIENT_CACHE_DIR = "alluxio.user.client.cache.dir";
        public static final String USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS = "alluxio.user.client.cache.local.store.file.buckets";
        public static final String USER_CLIENT_CACHE_PAGE_SIZE = "alluxio.user.client.cache.page.size";
        public static final String USER_CLIENT_CACHE_QUOTA_ENABLED = "alluxio.user.client.cache.quota.enabled";
        public static final String USER_CLIENT_CACHE_SIZE = "alluxio.user.client.cache.size";
        public static final String USER_CLIENT_CACHE_STORE_OVERHEAD = "alluxio.user.client.cache.store.overhead";
        public static final String USER_CLIENT_CACHE_STORE_TYPE = "alluxio.user.client.cache.store.type";
        public static final String USER_CLIENT_CACHE_TIMEOUT_DURATION = "alluxio.user.client.cache.timeout.duration";
        public static final String USER_CLIENT_CACHE_TIMEOUT_THREADS = "alluxio.user.client.cache.timeout.threads";
        public static final String USER_CONF_CLUSTER_DEFAULT_ENABLED = "alluxio.user.conf.cluster.default.enabled";
        public static final String USER_CONF_SYNC_INTERVAL = "alluxio.user.conf.sync.interval";
        public static final String USER_DATE_FORMAT_PATTERN = "alluxio.user.date.format.pattern";
        public static final String USER_FILE_BUFFER_BYTES = "alluxio.user.file.buffer.bytes";
        public static final String USER_FILE_RESERVED_BYTES = "alluxio.user.file.reserved.bytes";
        public static final String USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY = "alluxio.user.file.copyfromlocal.block.location.policy.class";
        public static final String USER_FILE_DELETE_UNCHECKED = "alluxio.user.file.delete.unchecked";
        public static final String USER_FILE_MASTER_CLIENT_POOL_SIZE_MIN = "alluxio.user.file.master.client.pool.size.min";
        public static final String USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX = "alluxio.user.file.master.client.pool.size.max";
        public static final String USER_FILE_MASTER_CLIENT_POOL_GC_INTERVAL_MS = "alluxio.user.file.master.client.pool.gc.interval";
        public static final String USER_FILE_MASTER_CLIENT_POOL_GC_THRESHOLD_MS = "alluxio.user.file.master.client.pool.gc.threshold";
        public static final String USER_FILE_METADATA_LOAD_TYPE = "alluxio.user.file.metadata.load.type";
        public static final String USER_FILE_METADATA_SYNC_INTERVAL = "alluxio.user.file.metadata.sync.interval";
        public static final String USER_FILE_PASSIVE_CACHE_ENABLED = "alluxio.user.file.passive.cache.enabled";
        public static final String USER_FILE_READ_TYPE_DEFAULT = "alluxio.user.file.readtype.default";
        public static final String USER_FILE_PERSIST_ON_RENAME = "alluxio.user.file.persist.on.rename";
        public static final String USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME = "alluxio.user.file.persistence.initial.wait.time";
        public static final String USER_FILE_REPLICATION_MAX = "alluxio.user.file.replication.max";
        public static final String USER_FILE_REPLICATION_MIN = "alluxio.user.file.replication.min";
        public static final String USER_FILE_TARGET_MEDIA = "alluxio.user.file.target.media";
        public static final String USER_FILE_REPLICATION_DURABLE = "alluxio.user.file.replication.durable";
        public static final String USER_FILE_SEQUENTIAL_PREAD_THRESHOLD = "alluxio.user.file.sequential.pread.threshold";
        public static final String USER_FILE_UFS_TIER_ENABLED = "alluxio.user.file.ufs.tier.enabled";
        public static final String USER_FILE_WAITCOMPLETED_POLL_MS = "alluxio.user.file.waitcompleted.poll";
        public static final String USER_FILE_CREATE_TTL = "alluxio.user.file.create.ttl";
        public static final String USER_FILE_CREATE_TTL_ACTION = "alluxio.user.file.create.ttl.action";
        public static final String USER_FILE_WRITE_TYPE_DEFAULT = "alluxio.user.file.writetype.default";
        public static final String USER_FILE_WRITE_TIER_DEFAULT = "alluxio.user.file.write.tier.default";
        public static final String USER_HOSTNAME = "alluxio.user.hostname";
        public static final String USER_LOCAL_READER_CHUNK_SIZE_BYTES = "alluxio.user.local.reader.chunk.size.bytes";
        public static final String USER_LOCAL_WRITER_CHUNK_SIZE_BYTES = "alluxio.user.local.writer.chunk.size.bytes";
        public static final String USER_LOGGING_THRESHOLD = "alluxio.user.logging.threshold";
        public static final String USER_MASTER_POLLING_TIMEOUT = "alluxio.user.master.polling.timeout";
        public static final String USER_METADATA_CACHE_ENABLED = "alluxio.user.metadata.cache.enabled";
        public static final String USER_METADATA_CACHE_MAX_SIZE = "alluxio.user.metadata.cache.max.size";
        public static final String USER_METADATA_CACHE_EXPIRATION_TIME = "alluxio.user.metadata.cache.expiration.time";
        public static final String USER_METRICS_COLLECTION_ENABLED = "alluxio.user.metrics.collection.enabled";
        public static final String USER_METRICS_HEARTBEAT_INTERVAL_MS = "alluxio.user.metrics.heartbeat.interval";
        public static final String USER_APP_ID = "alluxio.user.app.id";
        public static final String USER_NETWORK_DATA_TIMEOUT = "alluxio.user.network.data.timeout";
        public static final String USER_NETWORK_READER_BUFFER_SIZE_MESSAGES = "alluxio.user.network.reader.buffer.size.messages";
        public static final String USER_NETWORK_READER_CHUNK_SIZE_BYTES = "alluxio.user.network.reader.chunk.size.bytes";
        public static final String USER_NETWORK_WRITER_BUFFER_SIZE_MESSAGES = "alluxio.user.network.writer.buffer.size.messages";
        public static final String USER_NETWORK_WRITER_CHUNK_SIZE_BYTES = "alluxio.user.network.writer.chunk.size.bytes";
        public static final String USER_NETWORK_WRITER_CLOSE_TIMEOUT = "alluxio.user.network.writer.close.timeout";
        public static final String USER_NETWORK_WRITER_FLUSH_TIMEOUT = "alluxio.user.network.writer.flush.timeout";
        public static final String USER_NETWORK_ZEROCOPY_ENABLED = "alluxio.user.network.zerocopy.enabled";
        public static final String USER_SKIP_AUTHORITY_CHECK = "alluxio.user.skip.authority.check";
        public static final String USER_STREAMING_DATA_TIMEOUT = "alluxio.user.streaming.data.timeout";
        public static final String USER_STREAMING_DATA_READ_TIMEOUT = "alluxio.user.streaming.data.read.timeout";
        public static final String USER_STREAMING_DATA_WRITE_TIMEOUT = "alluxio.user.streaming.data.write.timeout";
        public static final String USER_STREAMING_READER_BUFFER_SIZE_MESSAGES = "alluxio.user.streaming.reader.buffer.size.messages";
        public static final String USER_STREAMING_READER_CHUNK_SIZE_BYTES = "alluxio.user.streaming.reader.chunk.size.bytes";
        public static final String USER_STREAMING_READER_CLOSE_TIMEOUT = "alluxio.user.streaming.reader.close.timeout";
        public static final String USER_STREAMING_WRITER_BUFFER_SIZE_MESSAGES = "alluxio.user.streaming.writer.buffer.size.messages";
        public static final String USER_STREAMING_WRITER_CHUNK_SIZE_BYTES = "alluxio.user.streaming.writer.chunk.size.bytes";
        public static final String USER_STREAMING_WRITER_CLOSE_TIMEOUT = "alluxio.user.streaming.writer.close.timeout";
        public static final String USER_STREAMING_WRITER_FLUSH_TIMEOUT = "alluxio.user.streaming.writer.flush.timeout";
        public static final String USER_STREAMING_ZEROCOPY_ENABLED = "alluxio.user.streaming.zerocopy.enabled";
        public static final String USER_NETWORK_FLOWCONTROL_WINDOW = "alluxio.user.network.flowcontrol.window";
        public static final String USER_NETWORK_KEEPALIVE_TIME = "alluxio.user.network.keepalive.time";
        public static final String USER_NETWORK_KEEPALIVE_TIMEOUT = "alluxio.user.network.keepalive.timeout";
        public static final String USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE = "alluxio.user.network.max.inbound.message.size";
        public static final String USER_NETWORK_NETTY_CHANNEL = "alluxio.user.network.netty.channel";
        public static final String USER_NETWORK_NETTY_WORKER_THREADS = "alluxio.user.network.netty.worker.threads";
        public static final String USER_NETWORK_RPC_FLOWCONTROL_WINDOW = "alluxio.user.network.rpc.flowcontrol.window";
        public static final String USER_NETWORK_RPC_KEEPALIVE_TIME = "alluxio.user.network.rpc.keepalive.time";
        public static final String USER_NETWORK_RPC_KEEPALIVE_TIMEOUT = "alluxio.user.network.rpc.keepalive.timeout";
        public static final String USER_NETWORK_RPC_MAX_INBOUND_MESSAGE_SIZE = "alluxio.user.network.rpc.max.inbound.message.size";
        public static final String USER_NETWORK_RPC_NETTY_CHANNEL = "alluxio.user.network.rpc.netty.channel";
        public static final String USER_NETWORK_RPC_NETTY_WORKER_THREADS = "alluxio.user.network.rpc.netty.worker.threads";
        public static final String USER_NETWORK_RPC_MAX_CONNECTIONS = "alluxio.user.network.rpc.max.connections";
        public static final String USER_NETWORK_STREAMING_FLOWCONTROL_WINDOW = "alluxio.user.network.streaming.flowcontrol.window";
        public static final String USER_NETWORK_STREAMING_KEEPALIVE_TIME = "alluxio.user.network.streaming.keepalive.time";
        public static final String USER_NETWORK_STREAMING_KEEPALIVE_TIMEOUT = "alluxio.user.network.streaming.keepalive.timeout";
        public static final String USER_NETWORK_STREAMING_MAX_INBOUND_MESSAGE_SIZE = "alluxio.user.network.streaming.max.inbound.message.size";
        public static final String USER_NETWORK_STREAMING_NETTY_CHANNEL = "alluxio.user.network.streaming.netty.channel";
        public static final String USER_NETWORK_STREAMING_NETTY_WORKER_THREADS = "alluxio.user.network.streaming.netty.worker.threads";
        public static final String USER_NETWORK_STREAMING_MAX_CONNECTIONS = "alluxio.user.network.streaming.max.connections";
        public static final String USER_RPC_RETRY_BASE_SLEEP_MS = "alluxio.user.rpc.retry.base.sleep";
        public static final String USER_RPC_RETRY_MAX_DURATION = "alluxio.user.rpc.retry.max.duration";
        public static final String USER_RPC_RETRY_MAX_SLEEP_MS = "alluxio.user.rpc.retry.max.sleep";
        public static final String USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED = "alluxio.user.ufs.block.location.all.fallback.enabled";
        public static final String USER_UFS_BLOCK_READ_LOCATION_POLICY = "alluxio.user.ufs.block.read.location.policy";
        public static final String USER_UFS_BLOCK_READ_LOCATION_POLICY_DETERMINISTIC_HASH_SHARDS = "alluxio.user.ufs.block.read.location.policy.deterministic.hash.shards";
        public static final String USER_UFS_BLOCK_READ_CONCURRENCY_MAX = "alluxio.user.ufs.block.read.concurrency.max";
        public static final String USER_UNSAFE_DIRECT_LOCAL_IO_ENABLED = "alluxio.user.unsafe.direct.local.io.enabled";
        public static final String USER_UPDATE_FILE_ACCESSTIME_DISABLED = "alluxio.user.update.file.accesstime.disabled";
        public static final String USER_SHORT_CIRCUIT_ENABLED = "alluxio.user.short.circuit.enabled";
        public static final String USER_SHORT_CIRCUIT_PREFERRED = "alluxio.user.short.circuit.preferred";
        public static final String USER_WORKER_LIST_REFRESH_INTERVAL = "alluxio.user.worker.list.refresh.interval";
        public static final String FUSE_AUTH_POLICY_CLASS = "alluxio.fuse.auth.policy.class";
        public static final String FUSE_AUTH_POLICY_CUSTOM_USER = "alluxio.fuse.auth.policy.custom.user";
        public static final String FUSE_AUTH_POLICY_CUSTOM_GROUP = "alluxio.fuse.auth.policy.custom.group";
        public static final String FUSE_CACHED_PATHS_MAX = "alluxio.fuse.cached.paths.max";
        public static final String FUSE_DEBUG_ENABLED = "alluxio.fuse.debug.enabled";
        public static final String FUSE_FS_NAME = "alluxio.fuse.fs.name";
        public static final String FUSE_JNIFUSE_ENABLED = "alluxio.fuse.jnifuse.enabled";
        public static final String FUSE_SHARED_CACHING_READER_ENABLED = "alluxio.fuse.shared.caching.reader.enabled";
        public static final String FUSE_LOGGING_THRESHOLD = "alluxio.fuse.logging.threshold";
        public static final String FUSE_MAXWRITE_BYTES = "alluxio.fuse.maxwrite.bytes";
        public static final String FUSE_UMOUNT_TIMEOUT = "alluxio.fuse.umount.timeout";
        public static final String FUSE_USER_GROUP_TRANSLATION_ENABLED = "alluxio.fuse.user.group.translation.enabled";
        public static final String FUSE_WEB_ENABLED = "alluxio.fuse.web.enabled";
        public static final String FUSE_WEB_BIND_HOST = "alluxio.fuse.web.bind.host";
        public static final String FUSE_WEB_HOSTNAME = "alluxio.fuse.web.hostname";
        public static final String FUSE_WEB_PORT = "alluxio.fuse.web.port";
        public static final String SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS = "alluxio.security.authentication.custom.provider.class";
        public static final String SECURITY_AUTHENTICATION_TYPE = "alluxio.security.authentication.type";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_ENABLED = "alluxio.security.authorization.permission.enabled";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP = "alluxio.security.authorization.permission.supergroup";
        public static final String SECURITY_AUTHORIZATION_PERMISSION_UMASK = "alluxio.security.authorization.permission.umask";
        public static final String SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS = "alluxio.security.group.mapping.cache.timeout";
        public static final String SECURITY_GROUP_MAPPING_CLASS = "alluxio.security.group.mapping.class";
        public static final String SECURITY_LOGIN_IMPERSONATION_USERNAME = "alluxio.security.login.impersonation.username";
        public static final String SECURITY_LOGIN_USERNAME = "alluxio.security.login.username";
        public static final String AUTHENTICATION_INACTIVE_CHANNEL_REAUTHENTICATE_PERIOD = "alluxio.security.stale.channel.purge.interval";
        public static final String NETWORK_TLS_SSL_CONTEXT_PROVIDER_CLASSNAME = "alluxio.network.tls.ssl.context.provider.classname";
        public static final String NETWORK_TLS_ENABLED = "alluxio.network.tls.enabled";
        public static final String JOB_MASTER_CLIENT_THREADS = "alluxio.job.master.client.threads";
        public static final String JOB_MASTER_FINISHED_JOB_PURGE_COUNT = "alluxio.job.master.finished.job.purge.count";
        public static final String JOB_MASTER_FINISHED_JOB_RETENTION_TIME = "alluxio.job.master.finished.job.retention.time";
        public static final String JOB_MASTER_JOB_CAPACITY = "alluxio.job.master.job.capacity";
        public static final String JOB_MASTER_WORKER_HEARTBEAT_INTERVAL = "alluxio.job.master.worker.heartbeat.interval";
        public static final String JOB_MASTER_WORKER_TIMEOUT = "alluxio.job.master.worker.timeout";
        public static final String JOB_MASTER_BIND_HOST = "alluxio.job.master.bind.host";
        public static final String JOB_MASTER_HOSTNAME = "alluxio.job.master.hostname";
        public static final String JOB_MASTER_LOST_WORKER_INTERVAL = "alluxio.job.master.lost.worker.interval";
        public static final String JOB_MASTER_RPC_PORT = "alluxio.job.master.rpc.port";
        public static final String JOB_MASTER_WEB_BIND_HOST = "alluxio.job.master.web.bind.host";
        public static final String JOB_MASTER_WEB_HOSTNAME = "alluxio.job.master.web.hostname";
        public static final String JOB_MASTER_WEB_PORT = "alluxio.job.master.web.port";
        public static final String JOB_MASTER_RPC_ADDRESSES = "alluxio.job.master.rpc.addresses";
        public static final String JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES = "alluxio.job.master.embedded.journal.addresses";
        public static final String JOB_MASTER_EMBEDDED_JOURNAL_PORT = "alluxio.job.master.embedded.journal.port";
        public static final String JOB_WORKER_BIND_HOST = "alluxio.job.worker.bind.host";
        public static final String JOB_WORKER_DATA_PORT = "alluxio.job.worker.data.port";
        public static final String JOB_WORKER_HOSTNAME = "alluxio.job.worker.hostname";
        public static final String JOB_WORKER_RPC_PORT = "alluxio.job.worker.rpc.port";
        public static final String JOB_WORKER_THREADPOOL_SIZE = "alluxio.job.worker.threadpool.size";
        public static final String JOB_WORKER_THROTTLING = "alluxio.job.worker.throttling";
        public static final String JOB_WORKER_WEB_BIND_HOST = "alluxio.job.worker.web.bind.host";
        public static final String JOB_WORKER_WEB_PORT = "alluxio.job.worker.web.port";
        public static final String ZOOKEEPER_JOB_ELECTION_PATH = "alluxio.zookeeper.job.election.path";
        public static final String ZOOKEEPER_JOB_LEADER_PATH = "alluxio.zookeeper.job.leader.path";
        public static final String JVM_MONITOR_WARN_THRESHOLD_MS = "alluxio.jvm.monitor.warn.threshold";
        public static final String JVM_MONITOR_INFO_THRESHOLD_MS = "alluxio.jvm.monitor.info.threshold";
        public static final String JVM_MONITOR_SLEEP_INTERVAL_MS = "alluxio.jvm.monitor.sleep.interval";
        public static final String MASTER_JVM_MONITOR_ENABLED = "alluxio.master.jvm.monitor.enabled";
        public static final String WORKER_JVM_MONITOR_ENABLED = "alluxio.worker.jvm.monitor.enabled";
        public static final String TABLE_ENABLED = "alluxio.table.enabled";
        public static final String TABLE_CATALOG_PATH = "alluxio.table.catalog.path";
        public static final String TABLE_CATALOG_UDB_SYNC_TIMEOUT = "alluxio.table.catalog.udb.sync.timeout";
        public static final String TABLE_JOURNAL_PARTITIONS_CHUNK_SIZE = "alluxio.table.journal.partitions.chunk.size";
        public static final String TABLE_TRANSFORM_MANAGER_JOB_MONITOR_INTERVAL = "alluxio.table.transform.manager.job.monitor.interval";
        public static final String TABLE_TRANSFORM_MANAGER_JOB_HISTORY_RETENTION_TIME = "alluxio.table.transform.manager.job.history.retention.time";
        public static final String TABLE_UDB_HIVE_CLIENTPOOL_MIN = "alluxio.table.udb.hive.clientpool.min";
        public static final String TABLE_UDB_HIVE_CLIENTPOOL_MAX = "alluxio.table.udb.hive.clientpool.MAX";

        private Name() {
        }
    }

    public static final class Builder {
        private String[] mAlias;
        private DefaultSupplier mDefaultSupplier;
        private Object mDefaultValue;
        private String mDescription;
        private String mName;
        private boolean mIgnoredSiteProperty;
        private boolean mIsBuiltIn = true;
        private boolean mIsHidden;
        private ConsistencyCheckLevel mConsistencyCheckLevel = ConsistencyCheckLevel.IGNORE;
        private Scope mScope = Scope.ALL;
        private DisplayType mDisplayType = DisplayType.DEFAULT;
        private boolean mIsDynamic = true;

        public Builder(String name) {
            this.mName = name;
        }

        public Builder(Template template, Object ... params) {
            this.mName = String.format(template.mFormat, params);
        }

        public Builder setAlias(String ... aliases) {
            this.mAlias = Arrays.copyOf(aliases, aliases.length);
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDefaultSupplier(DefaultSupplier defaultSupplier) {
            this.mDefaultSupplier = defaultSupplier;
            return this;
        }

        public Builder setDefaultSupplier(Supplier<Object> supplier, String description) {
            this.mDefaultSupplier = new DefaultSupplier(supplier, description);
            return this;
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.mDefaultValue = defaultValue;
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setIsBuiltIn(boolean isBuiltIn) {
            this.mIsBuiltIn = isBuiltIn;
            return this;
        }

        public Builder setIsHidden(boolean isHidden) {
            this.mIsHidden = isHidden;
            return this;
        }

        public Builder setIgnoredSiteProperty(boolean ignoredSiteProperty) {
            this.mIgnoredSiteProperty = ignoredSiteProperty;
            return this;
        }

        public Builder setConsistencyCheckLevel(ConsistencyCheckLevel consistencyCheckLevel) {
            this.mConsistencyCheckLevel = consistencyCheckLevel;
            return this;
        }

        public Builder setScope(Scope scope) {
            this.mScope = scope;
            return this;
        }

        public Builder setDisplayType(DisplayType displayType) {
            this.mDisplayType = displayType;
            return this;
        }

        public Builder setIsDynamic(boolean dynamic) {
            this.mIsDynamic = dynamic;
            return this;
        }

        public PropertyKey build() {
            PropertyKey key = this.buildUnregistered();
            Preconditions.checkState((boolean)PropertyKey.register(key), (String)"Cannot register existing key \"%s\"", (Object)this.mName);
            return key;
        }

        public PropertyKey buildUnregistered() {
            DefaultSupplier defaultSupplier = this.mDefaultSupplier;
            if (defaultSupplier == null) {
                String defaultString = String.valueOf(this.mDefaultValue);
                defaultSupplier = this.mDefaultValue == null ? new DefaultSupplier(() -> null, "null") : new DefaultSupplier(() -> defaultString, defaultString);
            }
            PropertyKey key = new PropertyKey(this.mName, this.mDescription, defaultSupplier, this.mAlias, this.mIgnoredSiteProperty, this.mIsHidden, this.mConsistencyCheckLevel, this.mScope, this.mDisplayType, this.mIsBuiltIn, this.mIsDynamic);
            return key;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("alias", (Object)this.mAlias).add("defaultValue", this.mDefaultValue).add("description", (Object)this.mDescription).add("name", (Object)this.mName).toString();
        }
    }

    public static enum DisplayType {
        DEFAULT,
        CREDENTIALS;

    }

    public static enum ConsistencyCheckLevel {
        IGNORE,
        WARN,
        ENFORCE;

    }
}

