/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.file.options.DescendantType;
import alluxio.grpc.BlockInfo;
import alluxio.grpc.BlockLocation;
import alluxio.grpc.CommandType;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FileBlockInfo;
import alluxio.grpc.FileInfo;
import alluxio.grpc.FileSystemCommand;
import alluxio.grpc.FileSystemCommandOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.LoadDescendantPType;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.LocalityTier;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.MountPointInfo;
import alluxio.grpc.PAcl;
import alluxio.grpc.PAclAction;
import alluxio.grpc.PAclEntry;
import alluxio.grpc.PAclEntryType;
import alluxio.grpc.PersistCommandOptions;
import alluxio.grpc.PersistFile;
import alluxio.grpc.Scope;
import alluxio.grpc.TieredIdentity;
import alluxio.grpc.UfsInfo;
import alluxio.grpc.WorkerInfo;
import alluxio.grpc.WorkerNetAddress;
import alluxio.proto.journal.File;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.util.StreamUtils;
import alluxio.wire.LoadMetadataType;
import alluxio.wire.TieredIdentity;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GrpcUtils {
    private GrpcUtils() {
    }

    public static GetStatusPOptions toGetStatusOptions(ExistsPOptions existsOptions) {
        GetStatusPOptions.Builder getStatusOptionsBuilder = GetStatusPOptions.newBuilder();
        if (existsOptions.hasCommonOptions()) {
            getStatusOptionsBuilder.setCommonOptions(existsOptions.getCommonOptions());
        }
        if (existsOptions.hasLoadMetadataType()) {
            getStatusOptionsBuilder.setLoadMetadataType(existsOptions.getLoadMetadataType());
        }
        return getStatusOptionsBuilder.build();
    }

    public static MountPOptions fromMountEntry(File.AddMountPointEntry mountEntryPoint) {
        MountPOptions.Builder optionsBuilder = MountPOptions.newBuilder();
        if (mountEntryPoint != null) {
            if (mountEntryPoint.hasReadOnly()) {
                optionsBuilder.setReadOnly(mountEntryPoint.getReadOnly());
            }
            for (File.StringPairEntry entry : mountEntryPoint.getPropertiesList()) {
                optionsBuilder.putProperties(entry.getKey(), entry.getValue());
            }
            if (mountEntryPoint.hasShared()) {
                optionsBuilder.setShared(mountEntryPoint.getShared());
            }
        }
        return optionsBuilder.build();
    }

    public static AccessControlList fromProto(PAcl pAcl) {
        AccessControlList acl;
        if (pAcl.getIsDefault()) {
            acl = new DefaultAccessControlList();
            ((DefaultAccessControlList)acl).setEmpty(pAcl.getIsDefaultEmpty());
        } else {
            acl = new AccessControlList();
        }
        acl.setOwningUser(pAcl.getOwner());
        acl.setOwningGroup(pAcl.getOwningGroup());
        acl.setMode((short)pAcl.getMode());
        if (pAcl.getEntriesCount() > 0) {
            for (PAclEntry tEntry : pAcl.getEntriesList()) {
                acl.setEntry(GrpcUtils.fromProto(tEntry));
            }
        }
        return acl;
    }

    public static AclEntry fromProto(PAclEntry pAclEntry) {
        AclEntry.Builder builder = new AclEntry.Builder();
        builder.setType(GrpcUtils.fromProto(pAclEntry.getType()));
        builder.setSubject(pAclEntry.getSubject());
        builder.setIsDefault(pAclEntry.getIsDefault());
        if (pAclEntry.getActionsCount() > 0) {
            for (PAclAction pAclAction : pAclEntry.getActionsList()) {
                builder.addAction(GrpcUtils.fromProto(pAclAction));
            }
        }
        return builder.build();
    }

    public static AclAction fromProto(PAclAction pAction) {
        switch (pAction) {
            case Read: {
                return AclAction.READ;
            }
            case Write: {
                return AclAction.WRITE;
            }
            case Execute: {
                return AclAction.EXECUTE;
            }
        }
        throw new IllegalStateException("Unknown TAclACtion: " + pAction);
    }

    public static AclEntryType fromProto(PAclEntryType pAclEntryType) {
        switch (pAclEntryType) {
            case Owner: {
                return AclEntryType.OWNING_USER;
            }
            case NamedUser: {
                return AclEntryType.NAMED_USER;
            }
            case OwningGroup: {
                return AclEntryType.OWNING_GROUP;
            }
            case NamedGroup: {
                return AclEntryType.NAMED_GROUP;
            }
            case Mask: {
                return AclEntryType.MASK;
            }
            case Other: {
                return AclEntryType.OTHER;
            }
        }
        throw new IllegalStateException("Unknown TAclEntryType: " + pAclEntryType);
    }

    public static alluxio.wire.BlockLocation fromProto(BlockLocation blockPLocation) {
        alluxio.wire.BlockLocation blockLocation = new alluxio.wire.BlockLocation();
        blockLocation.setWorkerId(blockPLocation.getWorkerId());
        blockLocation.setWorkerAddress(GrpcUtils.fromProto(blockPLocation.getWorkerAddress()));
        blockLocation.setTierAlias(blockPLocation.getTierAlias());
        blockLocation.setMediumType(blockPLocation.getMediumType());
        return blockLocation;
    }

    public static alluxio.wire.BlockInfo fromProto(BlockInfo blockPInfo) {
        alluxio.wire.BlockInfo blockInfo = new alluxio.wire.BlockInfo();
        blockInfo.setBlockId(blockPInfo.getBlockId());
        blockInfo.setLength(blockPInfo.getLength());
        blockInfo.setLocations(StreamUtils.map(GrpcUtils::fromProto, blockPInfo.getLocationsList()));
        return blockInfo;
    }

    public static DescendantType fromProto(LoadDescendantPType pDescendantType) {
        switch (pDescendantType) {
            case NONE: {
                return DescendantType.NONE;
            }
            case ONE: {
                return DescendantType.ONE;
            }
            case ALL: {
                return DescendantType.ALL;
            }
        }
        throw new IllegalStateException("Unknown DescendantType: " + pDescendantType);
    }

    public static alluxio.wire.FileInfo fromProto(FileInfo pInfo) {
        alluxio.wire.FileInfo fileInfo = new alluxio.wire.FileInfo().setFileId(pInfo.getFileId()).setName(pInfo.getName()).setPath(pInfo.getPath()).setUfsPath(pInfo.getUfsPath()).setLength(pInfo.getLength()).setBlockSizeBytes(pInfo.getBlockSizeBytes()).setCreationTimeMs(pInfo.getCreationTimeMs()).setCompleted(pInfo.getCompleted()).setFolder(pInfo.getFolder()).setPinned(pInfo.getPinned()).setCacheable(pInfo.getCacheable()).setMediumTypes((Set<String>)ImmutableSet.copyOf((Collection)pInfo.getMediumTypeList())).setPersisted(pInfo.getPersisted()).setBlockIds(pInfo.getBlockIdsList()).setLastModificationTimeMs(pInfo.getLastModificationTimeMs()).setTtl(pInfo.getTtl()).setLastAccessTimeMs(pInfo.getLastAccessTimeMs()).setTtlAction(pInfo.getTtlAction()).setOwner(pInfo.getOwner()).setGroup(pInfo.getGroup()).setMode(pInfo.getMode()).setPersistenceState(pInfo.getPersistenceState()).setMountPoint(pInfo.getMountPoint()).setFileBlockInfos(StreamUtils.map(GrpcUtils::fromProto, pInfo.getFileBlockInfosList())).setMountId(pInfo.getMountId()).setInAlluxioPercentage(pInfo.getInAlluxioPercentage()).setInMemoryPercentage(pInfo.getInMemoryPercentage()).setUfsFingerprint(pInfo.hasUfsFingerprint() ? pInfo.getUfsFingerprint() : "").setAcl(pInfo.hasAcl() ? GrpcUtils.fromProto(pInfo.getAcl()) : AccessControlList.EMPTY_ACL).setDefaultAcl(pInfo.hasDefaultAcl() ? (DefaultAccessControlList)GrpcUtils.fromProto(pInfo.getDefaultAcl()) : DefaultAccessControlList.EMPTY_DEFAULT_ACL).setReplicationMax(pInfo.getReplicationMax()).setReplicationMin(pInfo.getReplicationMin()).setXAttr(pInfo.getXattrMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ByteString)e.getValue()).toByteArray())));
        return fileInfo;
    }

    public static alluxio.wire.FileBlockInfo fromProto(FileBlockInfo fileBlockPInfo) {
        return new alluxio.wire.FileBlockInfo().setBlockInfo(GrpcUtils.fromProto(fileBlockPInfo.getBlockInfo())).setOffset(fileBlockPInfo.getOffset()).setUfsLocations((List<String>)(fileBlockPInfo.getUfsLocationsCount() > 0 ? fileBlockPInfo.getUfsStringLocationsList() : StreamUtils.map(addr -> HostAndPort.fromParts((String)addr.getHost(), (int)addr.getDataPort()).toString(), fileBlockPInfo.getUfsLocationsList())));
    }

    public static alluxio.wire.TieredIdentity fromProto(TieredIdentity tieredPIdentity) {
        return new alluxio.wire.TieredIdentity(tieredPIdentity.getTiersList().stream().map(GrpcUtils::fromProto).collect(Collectors.toList()));
    }

    public static TieredIdentity.LocalityTier fromProto(LocalityTier localityPTier) {
        return new TieredIdentity.LocalityTier(localityPTier.getTierName(), localityPTier.hasValue() ? localityPTier.getValue() : null);
    }

    public static alluxio.wire.MountPointInfo fromProto(MountPointInfo mountPointPInfo) {
        return new alluxio.wire.MountPointInfo().setUfsUri(mountPointPInfo.getUfsUri()).setUfsType(mountPointPInfo.getUfsType()).setUfsCapacityBytes(mountPointPInfo.getUfsCapacityBytes()).setUfsUsedBytes(mountPointPInfo.getUfsUsedBytes()).setReadOnly(mountPointPInfo.getReadOnly()).setProperties(mountPointPInfo.getPropertiesMap()).setMountId(mountPointPInfo.getMountId()).setShared(mountPointPInfo.getShared());
    }

    public static alluxio.wire.WorkerInfo fromProto(WorkerInfo workerInfo) {
        return new alluxio.wire.WorkerInfo().setAddress(GrpcUtils.fromProto(workerInfo.getAddress())).setCapacityBytes(workerInfo.getCapacityBytes()).setCapacityBytesOnTiers(workerInfo.getCapacityBytesOnTiers()).setId(workerInfo.getId()).setLastContactSec(workerInfo.getLastContactSec()).setStartTimeMs(workerInfo.getStartTimeMs()).setState(workerInfo.getState()).setUsedBytes(workerInfo.getUsedBytes()).setUsedBytesOnTiers(workerInfo.getUsedBytesOnTiersMap());
    }

    public static alluxio.wire.WorkerNetAddress fromProto(WorkerNetAddress workerNetPAddress) {
        alluxio.wire.WorkerNetAddress workerNetAddress = new alluxio.wire.WorkerNetAddress();
        workerNetAddress.setHost(workerNetPAddress.getHost());
        workerNetAddress.setContainerHost(workerNetPAddress.getContainerHost());
        workerNetAddress.setRpcPort(workerNetPAddress.getRpcPort());
        workerNetAddress.setDataPort(workerNetPAddress.getDataPort());
        workerNetAddress.setWebPort(workerNetPAddress.getWebPort());
        workerNetAddress.setDomainSocketPath(workerNetPAddress.getDomainSocketPath());
        workerNetAddress.setTieredIdentity(GrpcUtils.fromProto(workerNetPAddress.getTieredIdentity()));
        return workerNetAddress;
    }

    public static PAcl toProto(AccessControlList acl) {
        PAcl.Builder pAcl = PAcl.newBuilder();
        pAcl.setOwner(acl.getOwningUser());
        pAcl.setOwningGroup(acl.getOwningGroup());
        pAcl.setMode((int)acl.getMode());
        if (acl.hasExtended()) {
            for (AclEntry entry : acl.getExtendedEntries().getEntries()) {
                pAcl.addEntries(GrpcUtils.toProto(entry));
            }
        }
        pAcl.setIsDefault(false);
        return pAcl.build();
    }

    public static PAcl toProto(DefaultAccessControlList defaultAcl) {
        PAcl.Builder pAcl = PAcl.newBuilder((PAcl)GrpcUtils.toProto((AccessControlList)defaultAcl));
        pAcl.setIsDefault(true);
        pAcl.setIsDefaultEmpty(defaultAcl.isEmpty());
        return pAcl.build();
    }

    public static PAclAction toProto(AclAction action) {
        switch (action) {
            case READ: {
                return PAclAction.Read;
            }
            case WRITE: {
                return PAclAction.Write;
            }
            case EXECUTE: {
                return PAclAction.Execute;
            }
        }
        throw new IllegalStateException("Unknown acl action: " + (Object)((Object)action));
    }

    public static PAclEntry toProto(AclEntry aclEntry) {
        PAclEntry.Builder pAclEntry = PAclEntry.newBuilder();
        pAclEntry.setType(GrpcUtils.toProto(aclEntry.getType()));
        pAclEntry.setSubject(aclEntry.getSubject());
        pAclEntry.setIsDefault(aclEntry.isDefault());
        for (AclAction action : aclEntry.getActions().getActions()) {
            pAclEntry.addActions(GrpcUtils.toProto(action));
        }
        return pAclEntry.build();
    }

    public static PAclEntryType toProto(AclEntryType aclEntryType) {
        switch (aclEntryType) {
            case OWNING_USER: {
                return PAclEntryType.Owner;
            }
            case NAMED_USER: {
                return PAclEntryType.NamedUser;
            }
            case OWNING_GROUP: {
                return PAclEntryType.OwningGroup;
            }
            case NAMED_GROUP: {
                return PAclEntryType.NamedGroup;
            }
            case MASK: {
                return PAclEntryType.Mask;
            }
            case OTHER: {
                return PAclEntryType.Other;
            }
        }
        throw new IllegalStateException("Unknown AclEntryType: " + (Object)((Object)aclEntryType));
    }

    public static BlockInfo toProto(alluxio.wire.BlockInfo blockInfo) {
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
        for (alluxio.wire.BlockLocation location : blockInfo.getLocations()) {
            locations.add(GrpcUtils.toProto(location));
        }
        return BlockInfo.newBuilder().setBlockId(blockInfo.getBlockId()).setLength(blockInfo.getLength()).addAllLocations(locations).build();
    }

    public static BlockLocation toProto(alluxio.wire.BlockLocation blockLocation) {
        return BlockLocation.newBuilder().setWorkerId(blockLocation.getWorkerId()).setWorkerAddress(GrpcUtils.toProto(blockLocation.getWorkerAddress())).setTierAlias(blockLocation.getTierAlias()).setMediumType(blockLocation.getMediumType()).build();
    }

    public static FileInfo toProto(alluxio.wire.FileInfo fileInfo) {
        ArrayList<FileBlockInfo> fileBlockInfos = new ArrayList<FileBlockInfo>();
        for (alluxio.wire.FileBlockInfo fileBlockInfo : fileInfo.getFileBlockInfos()) {
            fileBlockInfos.add(GrpcUtils.toProto(fileBlockInfo));
        }
        FileInfo.Builder builder = FileInfo.newBuilder().setFileId(fileInfo.getFileId()).setName(fileInfo.getName()).setPath(fileInfo.getPath()).setUfsPath(fileInfo.getUfsPath()).setLength(fileInfo.getLength()).setBlockSizeBytes(fileInfo.getBlockSizeBytes()).setCreationTimeMs(fileInfo.getCreationTimeMs()).setCompleted(fileInfo.isCompleted()).setFolder(fileInfo.isFolder()).setPinned(fileInfo.isPinned()).setCacheable(fileInfo.isCacheable()).setPersisted(fileInfo.isPersisted()).addAllBlockIds(fileInfo.getBlockIds()).setLastModificationTimeMs(fileInfo.getLastModificationTimeMs()).setTtl(fileInfo.getTtl()).setLastAccessTimeMs(fileInfo.getLastAccessTimeMs()).setOwner(fileInfo.getOwner()).setGroup(fileInfo.getGroup()).setMode(fileInfo.getMode()).setPersistenceState(fileInfo.getPersistenceState()).setMountPoint(fileInfo.isMountPoint()).addAllFileBlockInfos(fileBlockInfos).setTtlAction(fileInfo.getTtlAction()).setMountId(fileInfo.getMountId()).setInAlluxioPercentage(fileInfo.getInAlluxioPercentage()).setInMemoryPercentage(fileInfo.getInMemoryPercentage()).setUfsFingerprint(fileInfo.getUfsFingerprint()).setReplicationMax(fileInfo.getReplicationMax()).setReplicationMin(fileInfo.getReplicationMin());
        if (!fileInfo.getAcl().equals(AccessControlList.EMPTY_ACL)) {
            builder.setAcl(GrpcUtils.toProto(fileInfo.getAcl()));
        }
        if (!fileInfo.getDefaultAcl().equals(DefaultAccessControlList.EMPTY_DEFAULT_ACL)) {
            builder.setDefaultAcl(GrpcUtils.toProto(fileInfo.getDefaultAcl()));
        }
        if (fileInfo.getXAttr() != null) {
            for (Map.Entry<String, byte[]> entry : fileInfo.getXAttr().entrySet()) {
                builder.putXattr(entry.getKey(), ByteString.copyFrom((byte[])entry.getValue()));
            }
        }
        if (!fileInfo.getMediumTypes().isEmpty()) {
            builder.addAllMediumType(fileInfo.getMediumTypes());
        }
        return builder.build();
    }

    public static FileBlockInfo toProto(alluxio.wire.FileBlockInfo fileBlockInfo) {
        ArrayList<WorkerNetAddress> ufsLocations = new ArrayList<WorkerNetAddress>();
        for (String ufsLocation : fileBlockInfo.getUfsLocations()) {
            HostAndPort address = HostAndPort.fromString((String)ufsLocation);
            ufsLocations.add(WorkerNetAddress.newBuilder().setHost(address.getHost()).setDataPort(address.getPortOrDefault(-1)).build());
        }
        return FileBlockInfo.newBuilder().setBlockInfo(GrpcUtils.toProto(fileBlockInfo.getBlockInfo())).setOffset(fileBlockInfo.getOffset()).addAllUfsLocations(ufsLocations).addAllUfsStringLocations(fileBlockInfo.getUfsLocations()).build();
    }

    public static LoadMetadataPType toProto(LoadMetadataType loadMetadataType) {
        return LoadMetadataPType.forNumber((int)loadMetadataType.getValue());
    }

    public static LoadDescendantPType toProto(DescendantType loadDescendantType) {
        return LoadDescendantPType.valueOf((String)loadDescendantType.name());
    }

    public static LocalityTier toProto(TieredIdentity.LocalityTier localityTier) {
        LocalityTier.Builder tier = LocalityTier.newBuilder().setTierName(localityTier.getTierName());
        if (localityTier.getValue() != null) {
            tier.setValue(localityTier.getValue());
        }
        return tier.build();
    }

    public static MountPointInfo toProto(alluxio.wire.MountPointInfo info) {
        return MountPointInfo.newBuilder().setUfsUri(info.getUfsUri()).setUfsType(info.getUfsType()).setUfsCapacityBytes(info.getUfsCapacityBytes()).setReadOnly(info.getReadOnly()).putAllProperties(info.getProperties()).setShared(info.getShared()).setMountId(info.getMountId()).setUfsUsedBytes(info.getUfsUsedBytes()).build();
    }

    public static TieredIdentity toProto(alluxio.wire.TieredIdentity tieredIdentity) {
        return TieredIdentity.newBuilder().addAllTiers((Iterable)tieredIdentity.getTiers().stream().map(GrpcUtils::toProto).collect(Collectors.toList())).build();
    }

    public static WorkerInfo toProto(alluxio.wire.WorkerInfo workerInfo) {
        return WorkerInfo.newBuilder().setId(workerInfo.getId()).setAddress(GrpcUtils.toProto(workerInfo.getAddress())).setLastContactSec(workerInfo.getLastContactSec()).setState(workerInfo.getState()).setCapacityBytes(workerInfo.getCapacityBytes()).setUsedBytes(workerInfo.getUsedBytes()).setStartTimeMs(workerInfo.getStartTimeMs()).putAllCapacityBytesOnTiers(workerInfo.getCapacityBytesOnTiers()).putAllUsedBytesOnTiers(workerInfo.getUsedBytesOnTiers()).build();
    }

    public static WorkerNetAddress toProto(alluxio.wire.WorkerNetAddress workerNetAddress) {
        WorkerNetAddress.Builder address = WorkerNetAddress.newBuilder().setHost(workerNetAddress.getHost()).setContainerHost(workerNetAddress.getContainerHost()).setRpcPort(workerNetAddress.getRpcPort()).setDataPort(workerNetAddress.getDataPort()).setWebPort(workerNetAddress.getWebPort()).setDomainSocketPath(workerNetAddress.getDomainSocketPath());
        if (workerNetAddress.getTieredIdentity() != null) {
            address.setTieredIdentity(GrpcUtils.toProto(workerNetAddress.getTieredIdentity()));
        }
        return address.build();
    }

    public static CommandType toProto(alluxio.wire.CommandType commandType) {
        return CommandType.valueOf((String)commandType.name());
    }

    public static PersistFile toProto(alluxio.wire.PersistFile persistFile) {
        return PersistFile.newBuilder().setFileId(persistFile.getFileId()).addAllBlockIds(persistFile.getBlockIds()).build();
    }

    public static FileSystemCommand toProto(alluxio.wire.FileSystemCommand fsCommand) {
        return FileSystemCommand.newBuilder().setCommandType(GrpcUtils.toProto(fsCommand.getCommandType())).setCommandOptions(FileSystemCommandOptions.newBuilder().setPersistOptions(PersistCommandOptions.newBuilder().addAllPersistFiles((Iterable)fsCommand.getCommandOptions().getPersistOptions().getFilesToPersist().stream().map(GrpcUtils::toProto).collect(Collectors.toList())))).build();
    }

    public static UfsInfo toProto(alluxio.wire.UfsInfo ufsInfo) {
        return UfsInfo.newBuilder().setUri(ufsInfo.getUri().toString()).setProperties(ufsInfo.getMountOptions()).build();
    }

    public static boolean contains(Scope source, Scope target) {
        return (source.getNumber() | target.getNumber()) == source.getNumber();
    }

    public static Scope combine(Scope scope1, Scope scope2) {
        return Scope.forNumber((int)(scope1.getNumber() & scope2.getNumber()));
    }
}

