/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import alluxio.util.CommonUtils;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TimeoutRetry
implements RetryPolicy {
    private final long mRetryTimeoutMs;
    private final long mSleepMs;
    private long mStartMs = 0L;
    private int mAttemptCount = 0;

    public TimeoutRetry(long retryTimeoutMs, int sleepMs) {
        Preconditions.checkArgument((retryTimeoutMs > 0L ? 1 : 0) != 0, (Object)"Retry timeout must be a positive number");
        Preconditions.checkArgument((sleepMs >= 0 ? 1 : 0) != 0, (Object)"sleepMs cannot be negative");
        this.mRetryTimeoutMs = retryTimeoutMs;
        this.mSleepMs = sleepMs;
    }

    @Override
    public int getAttemptCount() {
        return this.mAttemptCount;
    }

    @Override
    public boolean attempt() {
        if (this.mAttemptCount == 0) {
            this.mStartMs = CommonUtils.getCurrentMs();
            ++this.mAttemptCount;
            return true;
        }
        if (this.mSleepMs > 0L) {
            CommonUtils.sleepMs(this.mSleepMs);
        }
        if (CommonUtils.getCurrentMs() - this.mStartMs <= this.mRetryTimeoutMs) {
            ++this.mAttemptCount;
            return true;
        }
        return false;
    }
}

