/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.Mode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class AclEntry
implements Serializable {
    private static final long serialVersionUID = -738692910777661243L;
    private static final String DEFAULT_KEYWORD = "default";
    private static final String DEFAULT_PREFIX = "default:";
    private AclEntryType mType;
    private boolean mIsDefault;
    private String mSubject;
    private AclActions mActions;

    private AclEntry(AclEntryType type, String subject, AclActions actions, boolean isDefault) {
        this.mType = type;
        this.mSubject = subject;
        this.mActions = actions;
        this.mIsDefault = isDefault;
    }

    public AclEntryType getType() {
        return this.mType;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public AclActions getActions() {
        return new AclActions(this.mActions);
    }

    public boolean isDefault() {
        return this.mIsDefault;
    }

    public void setDefault(boolean defaultEntry) {
        this.mIsDefault = defaultEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AclEntry)) {
            return false;
        }
        AclEntry that = (AclEntry)o;
        return Objects.equal((Object)((Object)this.mType), (Object)((Object)that.mType)) && Objects.equal((Object)this.mSubject, (Object)that.mSubject) && Objects.equal((Object)this.mActions, (Object)that.mActions) && Objects.equal((Object)this.mIsDefault, (Object)that.mIsDefault);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mType, this.mSubject, this.mActions, this.mIsDefault});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.mType).add("subject", (Object)this.mSubject).add("actions", (Object)this.mActions).add("isDefault", this.mIsDefault).toString();
    }

    public String toCliString() {
        StringBuilder sb = new StringBuilder();
        if (this.mIsDefault) {
            sb.append(DEFAULT_PREFIX);
        }
        sb.append(this.mType.toCliString());
        sb.append(":");
        if (this.mType == AclEntryType.NAMED_USER || this.mType == AclEntryType.NAMED_GROUP) {
            sb.append(this.mSubject);
        }
        sb.append(":");
        sb.append(this.mActions.toCliString());
        return sb.toString();
    }

    public static String toDefault(String stringEntry) {
        if (stringEntry == null) {
            throw new IllegalArgumentException("Input acl string is null");
        }
        List components = Arrays.stream(stringEntry.split(":")).map(String::trim).collect(Collectors.toList());
        if (components != null && components.size() > 0 && ((String)components.get(0)).equals(DEFAULT_KEYWORD)) {
            return stringEntry;
        }
        return DEFAULT_PREFIX + stringEntry;
    }

    public static AclEntry fromCliString(String stringEntry) {
        if (stringEntry == null) {
            throw new IllegalArgumentException("Input acl string is null");
        }
        List components = Arrays.stream(stringEntry.split(":")).map(String::trim).collect(Collectors.toList());
        if (!(components.size() == 3 && !((String)components.get(0)).equals(DEFAULT_KEYWORD) || components.size() == 4 && ((String)components.get(0)).equals(DEFAULT_KEYWORD))) {
            throw new IllegalArgumentException("Unexpected acl components: " + stringEntry);
        }
        Builder builder = new Builder();
        int startingIndex = 0;
        if (((String)components.get(0)).equals(DEFAULT_KEYWORD)) {
            startingIndex = 1;
            builder.setIsDefault(true);
        } else {
            builder.setIsDefault(false);
        }
        String type = (String)components.get(startingIndex + 0);
        String subject = (String)components.get(startingIndex + 1);
        String actions = (String)components.get(startingIndex + 2);
        if (type.isEmpty()) {
            throw new IllegalArgumentException("ACL entry type is empty: " + stringEntry);
        }
        switch (type) {
            case "user": {
                if (subject.isEmpty()) {
                    builder.setType(AclEntryType.OWNING_USER);
                    break;
                }
                builder.setType(AclEntryType.NAMED_USER);
                break;
            }
            case "group": {
                if (subject.isEmpty()) {
                    builder.setType(AclEntryType.OWNING_GROUP);
                    break;
                }
                builder.setType(AclEntryType.NAMED_GROUP);
                break;
            }
            case "mask": {
                if (!subject.isEmpty()) {
                    throw new IllegalArgumentException("Subject for acl mask type must be empty: " + stringEntry);
                }
                builder.setType(AclEntryType.MASK);
                break;
            }
            case "other": {
                if (!subject.isEmpty()) {
                    throw new IllegalArgumentException("Subject for acl other type must be empty: " + stringEntry);
                }
                builder.setType(AclEntryType.OTHER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected ACL entry type: " + stringEntry);
            }
        }
        builder.setSubject(subject);
        Mode.Bits bits = Mode.Bits.fromString(actions);
        for (AclAction action : bits.toAclActionSet()) {
            builder.addAction(action);
        }
        return builder.build();
    }

    public static AclEntry fromCliStringWithoutPermissions(String stringEntry) {
        String type;
        if (stringEntry == null) {
            throw new IllegalArgumentException("Input acl string is null");
        }
        List components = Arrays.stream(stringEntry.split(":")).map(String::trim).collect(Collectors.toList());
        if (components.size() < 1 || components.size() > 4 || components.size() == 4 && !((String)components.get(0)).equals(DEFAULT_KEYWORD)) {
            throw new IllegalArgumentException("Unexpected acl components: " + stringEntry);
        }
        Builder builder = new Builder();
        String subject = "";
        String actions = "";
        if (((String)components.get(0)).equals(DEFAULT_KEYWORD)) {
            type = (String)components.get(1);
            if (components.size() >= 3) {
                subject = (String)components.get(2);
            }
            if (components.size() >= 4) {
                actions = (String)components.get(3);
            }
            builder.setIsDefault(true);
        } else {
            type = (String)components.get(0);
            if (components.size() >= 2) {
                subject = (String)components.get(1);
            }
            if (components.size() >= 3) {
                actions = (String)components.get(2);
            }
            builder.setIsDefault(false);
        }
        if (!actions.isEmpty()) {
            throw new IllegalArgumentException("ACL permissions cannot be specified: " + stringEntry);
        }
        if (type.isEmpty()) {
            throw new IllegalArgumentException("ACL entry type is empty: " + stringEntry);
        }
        switch (type) {
            case "user": {
                if (subject.isEmpty()) {
                    throw new IllegalArgumentException("ACL entry must have subject: " + stringEntry);
                }
                builder.setType(AclEntryType.NAMED_USER);
                break;
            }
            case "group": {
                if (subject.isEmpty()) {
                    throw new IllegalArgumentException("ACL entry must have subject: " + stringEntry);
                }
                builder.setType(AclEntryType.NAMED_GROUP);
                break;
            }
            case "mask": {
                if (!subject.isEmpty()) {
                    throw new IllegalArgumentException("Subject for acl mask type must be empty: " + stringEntry);
                }
                builder.setType(AclEntryType.MASK);
                break;
            }
            case "other": {
                if (!subject.isEmpty()) {
                    throw new IllegalArgumentException("Subject for acl other type must be empty: " + stringEntry);
                }
                builder.setType(AclEntryType.OTHER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected ACL entry type: " + stringEntry);
            }
        }
        builder.setSubject(subject);
        return builder.build();
    }

    public static final class Builder {
        private AclEntryType mType;
        private String mSubject = "";
        private AclActions mActions = new AclActions();
        private boolean mIsDefault;

        public Builder setType(AclEntryType type) {
            this.mType = type;
            return this;
        }

        public Builder setSubject(String subject) {
            this.mSubject = subject;
            return this;
        }

        public Builder setActions(AclActions actions) {
            for (AclAction action : actions.getActions()) {
                this.mActions.add(action);
            }
            return this;
        }

        public Builder addAction(AclAction action) {
            this.mActions.add(action);
            return this;
        }

        public Builder setIsDefault(boolean isDefault) {
            this.mIsDefault = isDefault;
            return this;
        }

        public AclEntry build() {
            boolean subjectRequired;
            if (this.mType == null) {
                throw new IllegalStateException("Type cannot be null");
            }
            boolean bl = subjectRequired = this.mType.equals((Object)AclEntryType.NAMED_USER) || this.mType.equals((Object)AclEntryType.NAMED_GROUP);
            if (subjectRequired && this.mSubject.isEmpty()) {
                throw new IllegalStateException("Subject for type " + (Object)((Object)this.mType) + " cannot be empty");
            }
            return new AclEntry(this.mType, this.mSubject, this.mActions, this.mIsDefault);
        }
    }
}

