/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class UfsStatus {
    protected final boolean mIsDirectory;
    protected final Long mLastModifiedTimeMs;
    protected String mName;
    protected final String mOwner;
    protected final String mGroup;
    protected final short mMode;
    protected final Map<String, byte[]> mXAttr;

    protected UfsStatus(String name, boolean isDirectory, String owner, String group, short mode, Long lastModifiedTimeMs, @Nullable Map<String, byte[]> xAttrs) {
        this.mIsDirectory = isDirectory;
        this.mName = name;
        this.mOwner = owner;
        this.mGroup = group;
        this.mMode = mode;
        this.mLastModifiedTimeMs = lastModifiedTimeMs;
        this.mXAttr = xAttrs;
    }

    protected UfsStatus(UfsStatus status) {
        this.mIsDirectory = status.mIsDirectory;
        this.mName = status.mName;
        this.mOwner = status.mOwner;
        this.mGroup = status.mGroup;
        this.mMode = status.mMode;
        this.mLastModifiedTimeMs = status.mLastModifiedTimeMs;
        this.mXAttr = status.mXAttr == null ? null : new HashMap<String, byte[]>(status.mXAttr);
    }

    public abstract UfsStatus copy();

    @Nullable
    public static String[] convertToNames(UfsStatus[] children) {
        if (children == null) {
            return null;
        }
        String[] ret = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = children[i].getName();
        }
        return ret;
    }

    public boolean isDirectory() {
        return this.mIsDirectory;
    }

    public boolean isFile() {
        return !this.mIsDirectory;
    }

    public String getGroup() {
        return this.mGroup;
    }

    @Nullable
    public Long getLastModifiedTime() {
        return this.mLastModifiedTimeMs;
    }

    public short getMode() {
        return this.mMode;
    }

    public String getName() {
        return this.mName;
    }

    public String getOwner() {
        return this.mOwner;
    }

    @Nullable
    public Map<String, byte[]> getXAttr() {
        return this.mXAttr;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mIsDirectory, this.mOwner, this.mGroup, this.mMode, this.mXAttr});
    }

    public UfsStatus setName(String name) {
        this.mName = name;
        return this;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("isDirectory", this.mIsDirectory).add("lastModifiedTimeMs", (Object)this.mLastModifiedTimeMs).add("name", (Object)this.mName).add("owner", (Object)this.mOwner).add("group", (Object)this.mGroup).add("mode", (int)this.mMode).add("xAttr", this.mXAttr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UfsStatus)) {
            return false;
        }
        UfsStatus that = (UfsStatus)o;
        return Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mIsDirectory, (Object)that.mIsDirectory) && Objects.equal((Object)this.mOwner, (Object)that.mOwner) && Objects.equal((Object)this.mGroup, (Object)that.mGroup) && Objects.equal((Object)this.mMode, (Object)that.mMode) && Objects.equal(this.mXAttr, that.mXAttr);
    }
}

