/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class JvmPauseMonitor {
    private static final Log LOG = LogFactory.getLog(JvmPauseMonitor.class);
    private final long mGcSleepIntervalMs;
    private final long mWarnThresholdMs;
    private final long mInfoThresholdMs;
    private final AtomicLong mWarnTimeExceeded = new AtomicLong();
    private final AtomicLong mInfoTimeExceeded = new AtomicLong();
    private final AtomicLong mTotalExtraTimeMs = new AtomicLong();
    private Thread mJvmMonitorThread;

    public JvmPauseMonitor(long gcSleepIntervalMs, long warnThresholdMs, long infoThresholdMs) {
        Preconditions.checkArgument((gcSleepIntervalMs > 0L ? 1 : 0) != 0, (Object)"gc sleep interval must be > 0");
        Preconditions.checkArgument((warnThresholdMs > 0L ? 1 : 0) != 0, (Object)"warn threshold must be > 0");
        Preconditions.checkArgument((infoThresholdMs > 0L ? 1 : 0) != 0, (Object)"info threshold must be > 0");
        Preconditions.checkArgument((warnThresholdMs > infoThresholdMs ? 1 : 0) != 0, (Object)"gc warn threshold must be > gc info threshold");
        this.mGcSleepIntervalMs = gcSleepIntervalMs;
        this.mWarnThresholdMs = warnThresholdMs;
        this.mInfoThresholdMs = infoThresholdMs;
    }

    public void start() {
        Preconditions.checkState((this.mJvmMonitorThread == null ? 1 : 0) != 0, (Object)"JVM monitor thread already started");
        this.mJvmMonitorThread = new GcMonitor();
        this.mJvmMonitorThread.start();
    }

    public void stop() {
        if (this.mJvmMonitorThread == null) {
            return;
        }
        this.mJvmMonitorThread.interrupt();
        try {
            this.mJvmMonitorThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.mJvmMonitorThread = null;
    }

    public boolean isStarted() {
        return this.mJvmMonitorThread != null && this.mJvmMonitorThread.isAlive();
    }

    public long getWarnTimeExceeded() {
        return this.mWarnTimeExceeded.get();
    }

    public long getInfoTimeExceeded() {
        return this.mInfoTimeExceeded.get();
    }

    public long getTotalExtraTime() {
        return this.mTotalExtraTimeMs.get();
    }

    private String getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        return "max memory = " + runtime.maxMemory() / 0x100000L + "M total memory = " + runtime.totalMemory() / 0x100000L + "M free memory = " + runtime.freeMemory() / 0x100000L + "M";
    }

    private String formatLogString(long extraSleepTime, Map<String, GarbageCollectorMXBean> gcMXBeanMapBeforeSleep, Map<String, GarbageCollectorMXBean> gcMXBeanMapAfterSleep) {
        ArrayList beanDiffs = Lists.newArrayList();
        Sets.SetView nameSet = Sets.intersection(gcMXBeanMapBeforeSleep.keySet(), gcMXBeanMapAfterSleep.keySet());
        for (String name : nameSet) {
            GarbageCollectorMXBean oldBean = gcMXBeanMapBeforeSleep.get(name);
            GarbageCollectorMXBean newBean = gcMXBeanMapAfterSleep.get(name);
            if (oldBean == null) {
                beanDiffs.add("new GCBean created name= '" + newBean.getName() + " count=" + newBean.getCollectionCount() + " time=" + newBean.getCollectionTime() + "ms");
                continue;
            }
            if (newBean == null) {
                beanDiffs.add("old GCBean canceled name= '" + oldBean.getName() + " count=" + oldBean.getCollectionCount() + " time=" + oldBean.getCollectionTime() + "ms");
                continue;
            }
            if (oldBean.getCollectionTime() == newBean.getCollectionTime() && oldBean.getCollectionCount() == newBean.getCollectionCount()) continue;
            beanDiffs.add("GC name= '" + newBean.getName() + " count=" + newBean.getCollectionCount() + " time=" + newBean.getCollectionTime() + "ms");
        }
        StringBuilder ret = new StringBuilder().append("JVM paused ").append(extraSleepTime).append("ms\n");
        if (beanDiffs.isEmpty()) {
            ret.append("No GCs detected ");
        } else {
            ret.append("GC list:\n" + Joiner.on((String)"\n").join((Iterable)beanDiffs));
        }
        ret.append("\n").append(this.getMemoryInfo());
        return ret.toString();
    }

    private Map<String, GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        List<GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        HashMap<String, GarbageCollectorMXBean> gcBeanMap = new HashMap<String, GarbageCollectorMXBean>();
        for (GarbageCollectorMXBean gcBean : gcBeanList) {
            gcBeanMap.put(gcBean.getName(), gcBean);
        }
        return gcBeanMap;
    }

    @VisibleForTesting
    void sleepMillis(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    private class GcMonitor
    extends Thread {
        public GcMonitor() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Stopwatch sw = Stopwatch.createUnstarted();
            Map gcBeanMapBeforeSleep = JvmPauseMonitor.this.getGarbageCollectorMXBeans();
            while (!Thread.currentThread().isInterrupted()) {
                sw.reset().start();
                try {
                    JvmPauseMonitor.this.sleepMillis(JvmPauseMonitor.this.mGcSleepIntervalMs);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"JVM pause monitor interrupted during sleep.");
                    return;
                }
                long extraTime = sw.elapsed(TimeUnit.MILLISECONDS) - JvmPauseMonitor.this.mGcSleepIntervalMs;
                JvmPauseMonitor.this.mTotalExtraTimeMs.addAndGet(extraTime);
                Map gcBeanMapAfterSleep = JvmPauseMonitor.this.getGarbageCollectorMXBeans();
                if (extraTime > JvmPauseMonitor.this.mWarnThresholdMs) {
                    JvmPauseMonitor.this.mInfoTimeExceeded.incrementAndGet();
                    JvmPauseMonitor.this.mWarnTimeExceeded.incrementAndGet();
                    LOG.warn((Object)JvmPauseMonitor.this.formatLogString(extraTime, gcBeanMapBeforeSleep, gcBeanMapAfterSleep));
                } else if (extraTime > JvmPauseMonitor.this.mInfoThresholdMs) {
                    JvmPauseMonitor.this.mInfoTimeExceeded.incrementAndGet();
                    LOG.info((Object)JvmPauseMonitor.this.formatLogString(extraTime, gcBeanMapBeforeSleep, gcBeanMapAfterSleep));
                }
                gcBeanMapBeforeSleep = gcBeanMapAfterSleep;
            }
        }
    }
}

