/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();
    @GuardedBy(value="ThreadUtils.class")
    private static long sPreviousLogTime = 0L;

    public static String formatStackTrace(Thread thread) {
        Throwable t = new Throwable(String.format("Stack trace for thread %s (State: %s):", new Object[]{thread.getName(), thread.getState()}));
        t.setStackTrace(thread.getStackTrace());
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void logAllThreads() {
        ThreadUtils.logThreadInfo(LOG, "Dumping all threads:", 0L);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeoutMs) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeoutMs / 2L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeoutMs / 2L, TimeUnit.MILLISECONDS)) {
                    LOG.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            pool.shutdownNow();
        }
    }

    public static String getCurrentThreadIdentifier() {
        return ThreadUtils.getThreadIdentifier(Thread.currentThread());
    }

    public static String getThreadIdentifier(Thread thread) {
        return String.format("%d(%s)", thread.getId(), thread.getName());
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static synchronized void printThreadInfo(PrintStream stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = THREAD_BEAN.isThreadContentionMonitoringEnabled();
        long[] threadIds = THREAD_BEAN.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = THREAD_BEAN.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ThreadUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ThreadUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logThreadInfo(Logger log, String title, long minInterval) {
        boolean dumpStack = false;
        if (!log.isInfoEnabled()) return;
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            long now = System.nanoTime() / 1000000L;
            if (now - sPreviousLogTime >= minInterval * 1000L) {
                sPreviousLogTime = now;
                dumpStack = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!dumpStack) return;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ThreadUtils.printThreadInfo(new PrintStream((OutputStream)buffer, false, "UTF-8"), title);
                log.info(buffer.toString(Charset.defaultCharset().name()));
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return;
        }
    }

    private ThreadUtils() {
    }
}

