/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.AlluxioURI;
import alluxio.util.io.PathUtils;
import com.google.common.base.Joiner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class URIUtils {
    public static final char QUERY_SEPARATOR = '&';
    public static final char QUERY_KEY_VALUE_SEPARATOR = '=';
    private static final int TO_LOWER_OFFSET = 32;

    private URIUtils() {
    }

    public static URI appendPath(URI base, String path) throws URISyntaxException {
        return new URI(base.getScheme(), base.getAuthority(), PathUtils.concatPath((Object)base.getPath(), (Object)path), base.getQuery(), base.getFragment());
    }

    public static URI appendPathOrDie(URI base, String path) {
        try {
            return URIUtils.appendPath(base, path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String generateQueryString(Map<String, String> queryMap) {
        if (queryMap == null || queryMap.isEmpty()) {
            return null;
        }
        ArrayList<String> pairs = new ArrayList<String>(queryMap.size());
        try {
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                pairs.add(URLEncoder.encode(entry.getKey(), "UTF-8") + '=' + URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Joiner joiner = Joiner.on((char)'&');
        return joiner.join(pairs);
    }

    public static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return queryMap;
        }
        String[] entries = query.split(String.valueOf('&'));
        try {
            for (String entry : entries) {
                String key;
                String[] parts = entry.split(String.valueOf('='));
                if (parts.length == 0) continue;
                if (parts.length == 1) {
                    key = URLDecoder.decode(parts[0], "UTF-8");
                    queryMap.put(key, "");
                    continue;
                }
                key = URLDecoder.decode(parts[0], "UTF-8");
                String value = URLDecoder.decode(parts[1], "UTF-8");
                queryMap.put(key, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return queryMap;
    }

    public static boolean isLocalFilesystem(String uri) {
        return uri.startsWith("/") || uri.startsWith("file://") || AlluxioURI.hasWindowsDrive(uri, false);
    }

    public static int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            if (s1.length() != s2.length()) {
                return false;
            }
            if (s1.indexOf(37) < 0) {
                return s1.equals(s2);
            }
            int length = s1.length();
            for (int i = 0; i < length; ++i) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(i);
                if (c1 != '%') {
                    if (c1 == c2) continue;
                    return false;
                }
                if (c2 != '%') {
                    return false;
                }
                if (URIUtils.toLower(s1.charAt(++i)) != URIUtils.toLower(s2.charAt(i))) {
                    return false;
                }
                if (URIUtils.toLower(s1.charAt(++i)) == URIUtils.toLower(s2.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    public static boolean needsNormalization(String path) {
        int curr;
        int last = path.length() - 1;
        for (curr = 0; curr <= last && path.charAt(curr) == '/'; ++curr) {
        }
        if (curr > 1) {
            return true;
        }
        block1: while (curr <= last) {
            if (path.charAt(curr) == '.' && (curr == last || path.charAt(curr + 1) == '/')) {
                return true;
            }
            if (path.charAt(curr) == '.' && path.charAt(curr + 1) == '.' && (curr + 1 == last || path.charAt(curr + 2) == '/')) {
                return true;
            }
            while (curr <= last) {
                if (path.charAt(curr++) != '/') continue;
                if (path.charAt(curr) != '/') continue block1;
                return true;
            }
        }
        return false;
    }

    public static int hash(int hash, String s) {
        if (s == null) {
            return hash;
        }
        return s.indexOf(37) < 0 ? 31 * hash + s.hashCode() : URIUtils.normalizedHash(hash, s);
    }

    public static int hashIgnoreCase(int hash, String s) {
        if (s == null) {
            return hash;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + URIUtils.toLower(s.charAt(i));
        }
        return hash;
    }

    private static int normalizedHash(int hash, String s) {
        int nextHash = 0;
        for (int index = 0; index < s.length(); ++index) {
            char ch = s.charAt(index);
            nextHash = 31 * nextHash + ch;
            if (ch != '%') continue;
            nextHash = 31 * nextHash + URIUtils.toLower(s.charAt(++index));
            nextHash = 31 * nextHash + URIUtils.toLower(s.charAt(++index));
        }
        return hash * 31 + nextHash;
    }
}

