/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.AlluxioException;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.grpc.AsyncCacheRequest;
import alluxio.grpc.CacheRequest;
import alluxio.proto.dataserver.Protocol;
import alluxio.wire.BlockReadRequest;
import alluxio.wire.FileInfo;
import alluxio.worker.SessionCleanable;
import alluxio.worker.Worker;
import alluxio.worker.block.BlockHeartbeatReport;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.io.BlockReader;
import alluxio.worker.block.io.BlockWriter;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.TempBlockMeta;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public interface BlockWorker
extends Worker,
SessionCleanable {
    public static final long INVALID_LOCK_ID = -1L;

    public AtomicReference<Long> getWorkerId();

    public void abortBlock(long var1, long var3) throws BlockAlreadyExistsException, BlockDoesNotExistException, InvalidWorkerStateException, IOException;

    public void accessBlock(long var1, long var3) throws BlockDoesNotExistException;

    public void commitBlock(long var1, long var3, boolean var5) throws BlockAlreadyExistsException, BlockDoesNotExistException, InvalidWorkerStateException, IOException, WorkerOutOfSpaceException;

    public void commitBlockInUfs(long var1, long var3) throws IOException;

    public String createBlock(long var1, long var3, int var5, String var6, long var7) throws BlockAlreadyExistsException, WorkerOutOfSpaceException, IOException;

    @Nullable
    public TempBlockMeta getTempBlockMeta(long var1, long var3);

    public BlockWriter createBlockWriter(long var1, long var3) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, IOException;

    public BlockHeartbeatReport getReport();

    public BlockStoreMeta getStoreMeta();

    public BlockStoreMeta getStoreMetaFull();

    public BlockMeta getVolatileBlockMeta(long var1) throws BlockDoesNotExistException;

    public BlockMeta getBlockMeta(long var1, long var3, long var5) throws BlockDoesNotExistException, InvalidWorkerStateException;

    public boolean hasBlockMeta(long var1);

    public long lockBlock(long var1, long var3);

    public void moveBlock(long var1, long var3, int var5) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException;

    public void moveBlockToMedium(long var1, long var3, String var5) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException;

    public BlockReader createBlockReader(BlockReadRequest var1) throws BlockDoesNotExistException, IOException;

    public BlockReader createUfsBlockReader(long var1, long var3, long var5, boolean var7, Protocol.OpenUfsBlockOptions var8) throws BlockDoesNotExistException, IOException;

    public void removeBlock(long var1, long var3) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException;

    public void requestSpace(long var1, long var3, long var5) throws BlockDoesNotExistException, WorkerOutOfSpaceException, IOException;

    public void unlockBlock(long var1) throws BlockDoesNotExistException;

    @Deprecated
    public void asyncCache(AsyncCacheRequest var1);

    public void cache(CacheRequest var1) throws AlluxioException, IOException;

    public void updatePinList(Set<Long> var1);

    public FileInfo getFileInfo(long var1) throws IOException;

    public void clearMetrics();
}

