/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockClient.class);
    private static final AtomicInteger NEXT_CLIENT_ID = new AtomicInteger(0);
    private final int mClientId = NEXT_CLIENT_ID.getAndIncrement();
    private final Type mClientType;

    public BlockClient(Type clientType) {
        this.mClientType = clientType;
        LOG.debug("BlockClient created: {}.", (Object)this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Id", this.mClientId).add("Type", (Object)this.mClientType.name()).add("Class", (Object)this.getClass().getName()).toString();
    }

    @Override
    public void close() throws IOException {
        LOG.debug("BlockClient closed: {}.", (Object)this);
    }

    public static enum Type {
        READER,
        WRITER;

    }
}

