/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.worker.block.io.BlockReader;
import com.google.common.io.Closer;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class DelegatingBlockReader
extends BlockReader {
    private final BlockReader mBlockReader;
    private final Closer mCloser = Closer.create();

    public DelegatingBlockReader(BlockReader blockReader, Closeable closeable) {
        this.mBlockReader = (BlockReader)this.mCloser.register((Closeable)blockReader);
        this.mCloser.register(closeable);
    }

    public BlockReader getDelegate() {
        return this.mBlockReader;
    }

    @Override
    public ByteBuffer read(long offset, long length) throws IOException {
        return this.mBlockReader.read(offset, length);
    }

    @Override
    public long getLength() {
        return this.mBlockReader.getLength();
    }

    @Override
    public ReadableByteChannel getChannel() {
        return this.mBlockReader.getChannel();
    }

    @Override
    public int transferTo(ByteBuf buf) throws IOException {
        return this.mBlockReader.transferTo(buf);
    }

    @Override
    public boolean isClosed() {
        return this.mBlockReader.isClosed();
    }

    @Override
    public String getLocation() {
        return this.mBlockReader.getLocation();
    }

    @Override
    public String toString() {
        return this.mBlockReader.toString();
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

