/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import com.google.common.collect.EvictingQueue;

public class TimeSeries {
    private final String mName;
    private final EvictingQueue<DataPoint> mDataPoints;

    public TimeSeries(String name) {
        this.mName = name;
        this.mDataPoints = EvictingQueue.create((int)20);
    }

    public void record(double value) {
        this.mDataPoints.add((Object)new DataPoint(value));
    }

    public String getName() {
        return this.mName;
    }

    public EvictingQueue<DataPoint> getDataPoints() {
        return this.mDataPoints;
    }

    public final class DataPoint {
        private final long mTimestamp = System.currentTimeMillis();
        private final double mValue;

        public DataPoint(double value) {
            this.mValue = value;
        }

        public long getTimeStamp() {
            return this.mTimestamp;
        }

        public double getValue() {
            return this.mValue;
        }
    }
}

