/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JmxSink
implements Sink {
    private static final String DOMAIN = "org.alluxio";
    private JmxReporter mReporter;

    public JmxSink(Properties properties, MetricRegistry registry) {
        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)registry);
        String domain = properties.getProperty("domain");
        if (domain != null) {
            builder.inDomain(domain);
        } else {
            builder.inDomain(DOMAIN);
        }
        this.mReporter = builder.build();
    }

    @Override
    public void start() {
        this.mReporter.start();
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
    }
}

