/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.EncodedMessage;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.proto.dataserver.Protocol;
import alluxio.util.proto.ProtoMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RPCMessage
implements EncodedMessage {
    public abstract Type getType();

    public void validate() {
    }

    public boolean hasPayload() {
        return this.getPayloadDataBuffer() != null;
    }

    @Nullable
    public DataBuffer getPayloadDataBuffer() {
        return null;
    }

    public static ByteToMessageDecoder createFrameDecoder() {
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 8, -8, 8);
    }

    public static RPCMessage decodeMessage(Type type, ByteBuf in) {
        switch (type) {
            case RPC_READ_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.ReadRequest.getDefaultInstance()));
            }
            case RPC_WRITE_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.WriteRequest.getDefaultInstance()));
            }
            case RPC_RESPONSE: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.Response.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_OPEN_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockOpenRequest.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_OPEN_RESPONSE: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockOpenResponse.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_CLOSE_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockCloseRequest.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_CREATE_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockCreateRequest.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_CREATE_RESPONSE: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockCreateResponse.getDefaultInstance()));
            }
            case RPC_LOCAL_BLOCK_COMPLETE_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.LocalBlockCompleteRequest.getDefaultInstance()));
            }
            case RPC_ASYNC_CACHE_REQUEST: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.AsyncCacheRequest.getDefaultInstance()));
            }
            case RPC_HEARTBEAT: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.Heartbeat.getDefaultInstance()));
            }
            case RPC_READ_RESPONSE: {
                return RPCProtoMessage.decode(in, new ProtoMessage(Protocol.ReadResponse.getDefaultInstance()));
            }
        }
        throw new IllegalArgumentException("Unknown RPCMessage type. type: " + type);
    }

    public static enum Type implements EncodedMessage
    {
        RPC_READ_REQUEST(100),
        RPC_WRITE_REQUEST(101),
        RPC_RESPONSE(102),
        RPC_HEARTBEAT(104),
        RPC_LOCAL_BLOCK_OPEN_REQUEST(105),
        RPC_LOCAL_BLOCK_OPEN_RESPONSE(106),
        RPC_LOCAL_BLOCK_CLOSE_REQUEST(107),
        RPC_LOCAL_BLOCK_CREATE_REQUEST(108),
        RPC_LOCAL_BLOCK_CREATE_RESPONSE(109),
        RPC_LOCAL_BLOCK_COMPLETE_REQUEST(110),
        RPC_READ_RESPONSE(111),
        RPC_ASYNC_CACHE_REQUEST(112),
        RPC_UNKNOWN(1000);

        private final int mId;

        private Type(int id) {
            this.mId = id;
        }

        @Override
        public int getEncodedLength() {
            return 4;
        }

        @Override
        public void encode(ByteBuf out) {
            out.writeInt(this.mId);
        }

        public int getId() {
            return this.mId;
        }

        public static Type decode(ByteBuf in) {
            int id = in.readInt();
            switch (id) {
                case 100: {
                    return RPC_READ_REQUEST;
                }
                case 101: {
                    return RPC_WRITE_REQUEST;
                }
                case 102: {
                    return RPC_RESPONSE;
                }
                case 104: {
                    return RPC_HEARTBEAT;
                }
                case 105: {
                    return RPC_LOCAL_BLOCK_OPEN_REQUEST;
                }
                case 106: {
                    return RPC_LOCAL_BLOCK_OPEN_RESPONSE;
                }
                case 107: {
                    return RPC_LOCAL_BLOCK_CLOSE_REQUEST;
                }
                case 108: {
                    return RPC_LOCAL_BLOCK_CREATE_REQUEST;
                }
                case 109: {
                    return RPC_LOCAL_BLOCK_CREATE_RESPONSE;
                }
                case 110: {
                    return RPC_LOCAL_BLOCK_COMPLETE_REQUEST;
                }
                case 111: {
                    return RPC_READ_RESPONSE;
                }
                case 112: {
                    return RPC_ASYNC_CACHE_REQUEST;
                }
            }
            throw new IllegalArgumentException("Unknown RPCMessage type id. id: " + id);
        }
    }
}

