/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.network.ChannelType;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class NettyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    public static final ChannelType CHANNEL_TYPE = NettyUtils.getChannelType();
    private static Boolean sNettyEpollAvailable = null;

    private NettyUtils() {
    }

    public static EventLoopGroup createEventLoop(ChannelType type, int numThreads, String threadPrefix, boolean isDaemon) {
        ThreadFactory threadFactory = ThreadFactoryUtils.build(threadPrefix, isDaemon);
        switch (type) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)type));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(ChannelType workerChannelType, boolean isDomainSocket) {
        if (isDomainSocket) {
            Preconditions.checkState((workerChannelType == ChannelType.EPOLL ? 1 : 0) != 0, (Object)"Domain sockets are only supported with EPOLL channel type.");
            return EpollServerDomainSocketChannel.class;
        }
        switch (workerChannelType) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)workerChannelType));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(boolean isDomainSocket, AlluxioConfiguration conf) {
        ChannelType workerChannelType = NettyUtils.getWorkerChannel(conf);
        return NettyUtils.getServerChannelClass(workerChannelType, isDomainSocket);
    }

    public static boolean isDomainSocketAccessible(WorkerNetAddress workerNetAddress, AlluxioConfiguration conf) {
        if (!NettyUtils.isDomainSocketSupported(workerNetAddress) || NettyUtils.getUserChannel(conf) != ChannelType.EPOLL) {
            return false;
        }
        if (conf.getBoolean(PropertyKey.WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID)) {
            return FileUtils.exists(workerNetAddress.getDomainSocketPath());
        }
        return workerNetAddress.getHost().equals(NetworkAddressUtils.getClientHostName(conf));
    }

    public static void enableAutoRead(Channel channel) {
        if (!channel.config().isAutoRead()) {
            channel.config().setAutoRead(true);
            channel.read();
        }
    }

    public static void disableAutoRead(Channel channel) {
        channel.config().setAutoRead(false);
    }

    public static boolean isDomainSocketSupported(WorkerNetAddress workerNetAddress) {
        return !workerNetAddress.getDomainSocketPath().isEmpty();
    }

    public static synchronized boolean isNettyEpollAvailable() {
        if (sNettyEpollAvailable == null) {
            sNettyEpollAvailable = NettyUtils.checkNettyEpollAvailable();
        }
        return sNettyEpollAvailable;
    }

    private static boolean checkNettyEpollAvailable() {
        if (!Epoll.isAvailable()) {
            LOG.info("EPOLL is not available, will use NIO");
            return false;
        }
        try {
            EpollChannelOption.class.getField("EPOLL_MODE");
            LOG.info("EPOLL_MODE is available");
            return true;
        }
        catch (Throwable e) {
            LOG.warn("EPOLL_MODE is not supported in netty with version < 4.0.26.Final, will use NIO");
            return false;
        }
    }

    public static ChannelType getUserChannel(AlluxioConfiguration conf) {
        return NettyUtils.getChannelType(PropertyKey.USER_NETWORK_STREAMING_NETTY_CHANNEL, conf);
    }

    public static ChannelType getWorkerChannel(AlluxioConfiguration conf) {
        return NettyUtils.getChannelType(PropertyKey.WORKER_NETWORK_NETTY_CHANNEL, conf);
    }

    public static Class<? extends Channel> getClientChannelClass(boolean isDomainSocket) {
        return NettyUtils.getChannelClass(isDomainSocket, PropertyKey.USER_NETWORK_NETTY_CHANNEL, Configuration.global());
    }

    public static Class<? extends Channel> getChannelClass(boolean isDomainSocket, PropertyKey key, AlluxioConfiguration conf) {
        ChannelType channelType = NettyUtils.getChannelType(key, conf);
        if (isDomainSocket) {
            Preconditions.checkState((channelType == ChannelType.EPOLL ? 1 : 0) != 0, (Object)"Domain sockets are only supported with EPOLL channel type.");
            return EpollDomainSocketChannel.class;
        }
        switch (channelType) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)channelType));
    }

    private static ChannelType getChannelType() {
        return NettyUtils.getChannelType(PropertyKey.USER_NETWORK_NETTY_CHANNEL, Configuration.global());
    }

    public static ChannelType getChannelType(PropertyKey key, AlluxioConfiguration conf) {
        if (!NettyUtils.isNettyEpollAvailable()) {
            return ChannelType.NIO;
        }
        return conf.getEnum(key, ChannelType.class);
    }
}

