/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.ReadRequest;
import alluxio.proto.dataserver.Protocol;
import alluxio.util.IdUtils;
import com.google.common.base.MoreObjects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockReadRequest {
    private final Protocol.OpenUfsBlockOptions mOpenUfsBlockOptions;
    private final long mId;
    private final long mStart;
    private final long mEnd;
    private final long mChunkSize;
    private final long mSessionId;
    private final boolean mPromote;
    private final boolean mPositionShort;

    public static BlockReadRequest from(ReadRequest request) {
        return new BlockReadRequest(request.getBlockId(), request.getOffset(), request.getOffset() + request.getLength(), request.getChunkSize(), request.getPromote(), request.getPositionShort(), request.hasOpenUfsBlockOptions() ? request.getOpenUfsBlockOptions() : null);
    }

    private BlockReadRequest(long id, long start, long end, long chunkSize, boolean promote, boolean positionShort, Protocol.OpenUfsBlockOptions openUfsBlockOptions) {
        this.mId = id;
        this.mStart = start;
        this.mEnd = end;
        this.mChunkSize = chunkSize;
        this.mSessionId = IdUtils.createSessionId();
        this.mOpenUfsBlockOptions = openUfsBlockOptions;
        this.mPromote = promote;
        this.mPositionShort = positionShort;
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public long getId() {
        return this.mId;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public long getChunkSize() {
        return this.mChunkSize;
    }

    public boolean isPromote() {
        return this.mPromote;
    }

    public boolean isPositionShort() {
        return this.mPositionShort;
    }

    public Protocol.OpenUfsBlockOptions getOpenUfsBlockOptions() {
        return this.mOpenUfsBlockOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chunkSize", this.getChunkSize()).add("end", this.getEnd()).add("id", this.getId()).add("openUfsBlockOptions", (Object)this.mOpenUfsBlockOptions).add("promote", this.mPromote).add("sessionId", this.getSessionId()).add("start", this.getStart()).add("positionShort", this.isPositionShort()).toString();
    }
}

