/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.worker.block.io.BlockReader;
import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LocalFileBlockReader
extends BlockReader {
    private static final Counter BLOCKS_READ_LOCAL = MetricsSystem.counter(MetricKey.WORKER_BLOCKS_READ_LOCAL.getName());
    private final String mFilePath;
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();
    private final long mFileSize;
    private boolean mClosed;
    private int mUsageCount = 0;

    public LocalFileBlockReader(String path) throws IOException {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.mLocalFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(this.mFilePath, "r"));
        this.mFileSize = this.mLocalFile.length();
        this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)this.mLocalFile.getChannel());
    }

    @Override
    public ReadableByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public long getLength() {
        return this.mFileSize;
    }

    public void increaseUsageCount() {
        ++this.mUsageCount;
    }

    public void decreaseUsageCount() {
        Preconditions.checkState((this.mUsageCount > 0 ? 1 : 0) != 0);
        --this.mUsageCount;
    }

    public int getUsageCount() {
        return this.mUsageCount;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    @Override
    public ByteBuffer read(long offset, long length) throws IOException {
        Preconditions.checkArgument((offset + length <= this.mFileSize ? 1 : 0) != 0, (String)"offset=%s, length=%s, exceeding fileSize=%s", (Object)offset, (Object)length, (Object)this.mFileSize);
        return this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
    }

    @Override
    public int transferTo(ByteBuf buf) throws IOException {
        return buf.writeBytes((ScatteringByteChannel)this.mLocalFileChannel, buf.writableBytes());
    }

    @Override
    public void close() throws IOException {
        super.close();
        Preconditions.checkState((this.mUsageCount == 0 ? 1 : 0) != 0);
        if (this.mClosed) {
            return;
        }
        try {
            this.mCloser.close();
        }
        finally {
            this.mClosed = true;
            BLOCKS_READ_LOCAL.inc();
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public String getLocation() {
        return this.mFilePath;
    }
}

