/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MetricsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private Properties mProperties = new Properties();

    public MetricsConfig(String configFile) {
        if (Files.exists(Paths.get(configFile, new String[0]), new LinkOption[0])) {
            this.loadConfigFile(configFile);
        }
        this.removeInstancePrefix();
    }

    public MetricsConfig(Properties properties) {
        this.mProperties.putAll((Map<?, ?>)properties);
        this.removeInstancePrefix();
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public static Map<String, Properties> subProperties(Properties prop, String regex) {
        HashMap<String, Properties> subProperties = new HashMap<String, Properties>();
        Pattern pattern = Pattern.compile(regex);
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            Matcher m = pattern.matcher(entry.getKey().toString());
            if (!m.find()) continue;
            String prefix = m.group(1);
            String suffix = m.group(2);
            if (!subProperties.containsKey(prefix)) {
                subProperties.put(prefix, new Properties());
            }
            ((Properties)subProperties.get(prefix)).put(suffix, entry.getValue());
        }
        return subProperties;
    }

    private void loadConfigFile(String configFile) {
        try (FileInputStream is = new FileInputStream(configFile);){
            this.mProperties.load(is);
        }
        catch (Exception e) {
            LOG.error("Error loading metrics configuration file.", (Throwable)e);
        }
    }

    private void removeInstancePrefix() {
        Properties newProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.mProperties.entrySet()) {
            String key = entry.getKey().toString();
            if (key.startsWith("*") || key.startsWith("worker") || key.startsWith("master")) {
                String newKey = key.substring(key.indexOf(46) + 1);
                newProperties.put(newKey, entry.getValue());
                continue;
            }
            newProperties.put(key, entry.getValue());
        }
        this.mProperties = newProperties;
    }

    public String toString() {
        return this.mProperties.toString();
    }
}

