/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.netty;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.CancelledException;
import alluxio.exception.status.UnavailableException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.DynamicResourcePool;
import alluxio.util.CommonUtils;
import alluxio.util.ThreadFactoryUtils;
import com.codahale.metrics.Counter;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class NettyChannelPool
extends DynamicResourcePool<Channel> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyChannelPool.class);
    private static final Counter COUNTER = MetricsSystem.counter(MetricKey.NETTY_CHANNEL_COUNT.getName());
    private static final int NETTY_CHANNEL_POOL_GC_THREADPOOL_SIZE = 10;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(10, ThreadFactoryUtils.build("NettyChannelPoolGcThreads-%d", true));
    private static final boolean POOL_DISABLED = Configuration.getBoolean(PropertyKey.USER_NETWORK_NETTY_CHANNEL_POOL_DISABLED);
    private final Bootstrap mBootstrap;
    private final long mGcThresholdMs;

    public NettyChannelPool(Bootstrap bootstrap, int maxCapacity, long gcThresholdMs) {
        super(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        this.mBootstrap = bootstrap;
        this.mGcThresholdMs = gcThresholdMs;
    }

    @Override
    protected void closeResource(Channel channel) {
        LOG.info("Channel closed");
        CommonUtils.closeChannel(channel);
    }

    @Override
    protected Channel createNewResource() throws IOException {
        Bootstrap bs = this.mBootstrap.clone();
        try {
            ChannelFuture channelFuture = bs.connect().sync();
            if (channelFuture.isSuccess()) {
                LOG.info("Created netty channel with netty bootstrap {}.", (Object)this.mBootstrap);
                return channelFuture.channel();
            }
            LOG.error("Failed to create netty channel with netty bootstrap {} and error {}.", (Object)this.mBootstrap, (Object)channelFuture.cause().getMessage());
            throw new UnavailableException(channelFuture.cause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancelledException(e);
        }
    }

    @Override
    protected boolean isHealthy(Channel channel) {
        if (POOL_DISABLED) {
            return false;
        }
        return channel.isOpen() && channel.isActive();
    }

    @Override
    protected Counter getMetricCounter() {
        return COUNTER;
    }

    @Override
    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<Channel> channelResourceInternal) {
        return System.currentTimeMillis() - channelResourceInternal.getLastAccessTimeMs() > this.mGcThresholdMs;
    }
}

