/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.proto.dataserver.Protocol;
import alluxio.proto.status.Status;
import alluxio.util.proto.ProtoMessage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCProtoMessage
extends RPCMessage {
    private final ProtoMessage mMessage;
    private final byte[] mMessageEncoded;
    private final DataBuffer mData;

    public RPCProtoMessage(ProtoMessage message, DataBuffer data) {
        if (data != null) {
            Preconditions.checkArgument((data instanceof NettyDataBuffer || data instanceof DataFileChannel ? 1 : 0) != 0, (Object)"Only NettyDataBuffer and DataFileChannel are allowed.");
        }
        this.mMessage = message;
        this.mMessageEncoded = message.toByteArray();
        if (data != null && data.getLength() > 0L) {
            this.mData = data;
        } else if (data != null) {
            data.release();
            this.mData = null;
        } else {
            this.mData = null;
        }
    }

    public RPCProtoMessage(ProtoMessage message) {
        this(message, null);
    }

    public RPCProtoMessage(byte[] serialized, ProtoMessage prototype, DataBuffer data) {
        Preconditions.checkArgument((data instanceof NettyDataBuffer || data instanceof DataFileChannel ? 1 : 0) != 0, (Object)"Only NettyDataBuffer and DataFileChannel are allowed.");
        this.mMessage = ProtoMessage.parseFrom(serialized, prototype);
        this.mMessageEncoded = Arrays.copyOf(serialized, serialized.length);
        if (data != null && data.getLength() > 0L) {
            this.mData = data;
        } else if (data != null) {
            data.release();
            this.mData = null;
        } else {
            this.mData = null;
        }
    }

    @Override
    public int getEncodedLength() {
        return 4 + this.mMessageEncoded.length;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeInt(this.mMessageEncoded.length);
        out.writeBytes(this.mMessageEncoded);
    }

    public static RPCProtoMessage decode(ByteBuf in, ProtoMessage prototype) {
        int length = in.readInt();
        byte[] serialized = new byte[length];
        in.readBytes(serialized);
        in.retain();
        return new RPCProtoMessage(serialized, prototype, new NettyDataBuffer(in));
    }

    @Override
    public RPCMessage.Type getType() {
        if (this.mMessage.isReadRequest()) {
            return RPCMessage.Type.RPC_READ_REQUEST;
        }
        if (this.mMessage.isWriteRequest()) {
            return RPCMessage.Type.RPC_WRITE_REQUEST;
        }
        if (this.mMessage.isResponse()) {
            return RPCMessage.Type.RPC_RESPONSE;
        }
        if (this.mMessage.isLocalBlockOpenRequest()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_OPEN_REQUEST;
        }
        if (this.mMessage.isLocalBlockOpenResponse()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_OPEN_RESPONSE;
        }
        if (this.mMessage.isLocalBlockCloseRequest()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_CLOSE_REQUEST;
        }
        if (this.mMessage.isLocalBlockCreateRequest()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_CREATE_REQUEST;
        }
        if (this.mMessage.isLocalBlockCreateResponse()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_CREATE_RESPONSE;
        }
        if (this.mMessage.isLocalBlockCompleteRequest()) {
            return RPCMessage.Type.RPC_LOCAL_BLOCK_COMPLETE_REQUEST;
        }
        if (this.mMessage.isAsyncCacheRequest()) {
            return RPCMessage.Type.RPC_ASYNC_CACHE_REQUEST;
        }
        if (this.mMessage.isHeartbeat()) {
            return RPCMessage.Type.RPC_HEARTBEAT;
        }
        if (this.mMessage.isReadResponse()) {
            return RPCMessage.Type.RPC_READ_RESPONSE;
        }
        return RPCMessage.Type.RPC_UNKNOWN;
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean hasPayload() {
        return this.getPayloadDataBuffer() != null;
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public ProtoMessage getMessage() {
        return this.mMessage;
    }

    public static RPCProtoMessage createResponse(AlluxioStatusException se) {
        String message = se.getMessage() != null ? se.getMessage() : "";
        return RPCProtoMessage.createResponse(se.getStatus(), message, null);
    }

    public static RPCProtoMessage createResponse(Status status, String message, DataBuffer data) {
        Protocol.Response response = Protocol.Response.newBuilder().setStatus(RPCProtoMessage.toProto(status)).setMessage(message).build();
        return new RPCProtoMessage(new ProtoMessage(response), data);
    }

    public static RPCProtoMessage createOkResponse(DataBuffer data) {
        return RPCProtoMessage.createResponse(Status.OK, "", data);
    }

    public static RPCProtoMessage createCancelResponse() {
        return RPCProtoMessage.createResponse(Status.CANCELLED, "canceled", null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.mMessage).add("dataLength", this.mData == null ? 0L : this.mData.getLength()).toString();
    }

    public static Status.PStatus toProto(Status status) {
        switch (status.getCode()) {
            case ABORTED: {
                return Status.PStatus.ABORTED;
            }
            case ALREADY_EXISTS: {
                return Status.PStatus.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return Status.PStatus.CANCELLED;
            }
            case DATA_LOSS: {
                return Status.PStatus.DATA_LOSS;
            }
            case DEADLINE_EXCEEDED: {
                return Status.PStatus.DEADLINE_EXCEEDED;
            }
            case FAILED_PRECONDITION: {
                return Status.PStatus.FAILED_PRECONDITION;
            }
            case INTERNAL: {
                return Status.PStatus.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.PStatus.INVALID_ARGUMENT;
            }
            case NOT_FOUND: {
                return Status.PStatus.NOT_FOUND;
            }
            case OK: {
                return Status.PStatus.OK;
            }
            case OUT_OF_RANGE: {
                return Status.PStatus.OUT_OF_RANGE;
            }
            case PERMISSION_DENIED: {
                return Status.PStatus.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.PStatus.RESOURCE_EXHAUSTED;
            }
            case UNAUTHENTICATED: {
                return Status.PStatus.UNAUTHENTICATED;
            }
            case UNAVAILABLE: {
                return Status.PStatus.UNAVAILABLE;
            }
            case UNIMPLEMENTED: {
                return Status.PStatus.UNIMPLEMENTED;
            }
            case UNKNOWN: {
                return Status.PStatus.UNKNOWN;
            }
        }
        return Status.PStatus.UNKNOWN;
    }

    public static Status fromProto(Status.PStatus status) {
        switch (status) {
            case ABORTED: {
                return Status.ABORTED;
            }
            case ALREADY_EXISTS: {
                return Status.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return Status.CANCELLED;
            }
            case DATA_LOSS: {
                return Status.DATA_LOSS;
            }
            case DEADLINE_EXCEEDED: {
                return Status.DEADLINE_EXCEEDED;
            }
            case FAILED_PRECONDITION: {
                return Status.FAILED_PRECONDITION;
            }
            case INTERNAL: {
                return Status.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.INVALID_ARGUMENT;
            }
            case NOT_FOUND: {
                return Status.NOT_FOUND;
            }
            case OK: {
                return Status.OK;
            }
            case OUT_OF_RANGE: {
                return Status.OUT_OF_RANGE;
            }
            case PERMISSION_DENIED: {
                return Status.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.RESOURCE_EXHAUSTED;
            }
            case UNAUTHENTICATED: {
                return Status.UNAUTHENTICATED;
            }
            case UNAVAILABLE: {
                return Status.UNAVAILABLE;
            }
            case UNIMPLEMENTED: {
                return Status.UNIMPLEMENTED;
            }
            case UNKNOWN: {
                return Status.UNKNOWN;
            }
        }
        return Status.UNKNOWN;
    }
}

