/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.CloseableResource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class CloseableIterator<T>
extends CloseableResource<Iterator<T>>
implements Iterator<T> {
    Iterator<T> mIter;

    CloseableIterator(Iterator<T> iterator) {
        super(iterator);
        this.mIter = iterator;
    }

    private Iterator<T> getIterator() {
        return this.mIter;
    }

    @Override
    public boolean hasNext() {
        return this.mIter.hasNext();
    }

    @Override
    public T next() {
        return this.mIter.next();
    }

    public static <T> CloseableIterator<T> create(Iterator<? extends T> iterator, final Consumer<Void> closeAction) {
        return new CloseableIterator(iterator){

            @Override
            public void closeResource() {
                closeAction.accept(null);
            }
        };
    }

    public static <T> CloseableIterator<T> noopCloseable(Iterator<? extends T> iterator) {
        return new CloseableIterator(iterator){

            @Override
            public void closeResource() {
            }
        };
    }

    public static <T> CloseableIterator<T> concat(CloseableIterator<T> a, CloseableIterator<T> b) {
        return CloseableIterator.concat(Lists.newArrayList((Object[])new CloseableIterator[]{a, b}));
    }

    public static <T> CloseableIterator<T> concat(List<CloseableIterator<T>> iterators) {
        Iterator it = Iterators.concat(iterators.stream().map(CloseableIterator::getIterator).iterator());
        final Closer closer = Closer.create();
        iterators.forEach(arg_0 -> ((Closer)closer).register(arg_0));
        return new CloseableIterator<T>(it){

            @Override
            public void closeResource() {
                try {
                    closer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close iterator", e);
                }
            }
        };
    }

    @VisibleForTesting
    public static int size(CloseableIterator<?> iter) {
        try {
            int size;
            int n = size = Iterators.size(iter);
            return n;
        }
        finally {
            iter.close();
        }
    }
}

