/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell;

import java.util.Arrays;

public class CommandReturn {
    private int mExitCode;
    private String[] mCmd;
    private String mOutput;

    public CommandReturn(int code, String output) {
        this.mExitCode = code;
        this.mCmd = new String[0];
        this.mOutput = output;
    }

    public CommandReturn(int code, String[] cmd, String output) {
        this.mExitCode = code;
        this.mCmd = Arrays.copyOfRange(cmd, 0, cmd.length);
        this.mOutput = output;
    }

    public int getExitCode() {
        return this.mExitCode;
    }

    public String[] getCmd() {
        return this.mCmd;
    }

    public String getOutput() {
        return this.mOutput;
    }

    public String getFormattedOutput() {
        return String.format("ExitCode:%s%nCommand:%s%nOutput:%n%s", this.getExitCode(), Arrays.toString(this.getCmd()), this.getOutput());
    }
}

