/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

public final class HFSUtils {
    public static long getNumSector(String requestSize, String sectorSize) {
        Double memSize = Double.parseDouble(requestSize);
        Double sectorBytes = Double.parseDouble(sectorSize);
        Double nSectors = memSize / sectorBytes;
        Double memSizeKB = memSize / 1024.0;
        Double memSizeGB = memSize / 1.073741824E9;
        Double memSize100GB = memSizeGB / 100.0;
        Double allocBitmapSize = nSectors / 8.0;
        Double extOverflowFileSize = memSize100GB * 1024.0 * 1024.0 * 4.0;
        Double journalFileSize = memSize100GB * 1024.0 * 1024.0 * 8.0;
        Double catalogFileSize = memSizeKB * 10.0;
        Double hotFileSize = memSizeKB * 5.0;
        Double quotaUsersFileSize = (memSizeGB * 256.0 + 1.0) * 64.0;
        Double quotaGroupsFileSize = (memSizeGB * 32.0 + 1.0) * 64.0;
        Double metadataSize = allocBitmapSize + extOverflowFileSize + journalFileSize + catalogFileSize + hotFileSize + quotaUsersFileSize + quotaGroupsFileSize;
        Double allocSize = memSize + metadataSize;
        Double numSectors = allocSize / sectorBytes;
        System.out.println(numSectors.longValue() + 1L);
        return numSectors.longValue() + 1L;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.exit(-1);
        }
        String mem = args[0];
        String sector = args[1];
        try {
            HFSUtils.getNumSector(mem, sector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HFSUtils() {
    }
}

