/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.webui;

import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.wire.WorkerInfo;
import com.google.common.base.Objects;

public final class NodeInfo
implements Comparable<NodeInfo> {
    private final String mHost;
    private final int mWebPort;
    private final String mLastContactSec;
    private final String mWorkerState;
    private final long mCapacityBytes;
    private final long mUsedBytes;
    private final int mFreePercent;
    private final int mUsedPercent;
    private final String mUptimeClockTime;
    private final long mWorkerId;
    private final long mBlockCount;
    private final String mVersion;
    private final String mRevision;

    public NodeInfo(WorkerInfo workerInfo) {
        this.mHost = !workerInfo.getAddress().getContainerHost().equals("") ? String.format("%s (%s)", workerInfo.getAddress().getHost(), workerInfo.getAddress().getContainerHost()) : workerInfo.getAddress().getHost();
        this.mWebPort = workerInfo.getAddress().getWebPort();
        this.mLastContactSec = Integer.toString(workerInfo.getLastContactSec());
        this.mWorkerState = workerInfo.getState();
        this.mCapacityBytes = workerInfo.getCapacityBytes();
        this.mUsedBytes = workerInfo.getUsedBytes();
        this.mUsedPercent = this.mCapacityBytes != 0L ? (int)(100L * this.mUsedBytes / this.mCapacityBytes) : 0;
        this.mFreePercent = 100 - this.mUsedPercent;
        this.mUptimeClockTime = CommonUtils.convertMsToClockTime(System.currentTimeMillis() - workerInfo.getStartTimeMs());
        this.mWorkerId = workerInfo.getId();
        this.mBlockCount = workerInfo.getBlockCount();
        this.mVersion = workerInfo.getVersion();
        this.mRevision = workerInfo.getRevision();
    }

    public String getCapacity() {
        return FormatUtils.getSizeFromBytes(this.mCapacityBytes);
    }

    public int getFreeSpacePercent() {
        return this.mFreePercent;
    }

    public String getLastHeartbeat() {
        return this.mLastContactSec;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getWebPort() {
        return this.mWebPort;
    }

    public String getState() {
        return this.mWorkerState;
    }

    public String getUptimeClockTime() {
        return this.mUptimeClockTime;
    }

    public String getUsedMemory() {
        return FormatUtils.getSizeFromBytes(this.mUsedBytes);
    }

    public int getUsedSpacePercent() {
        return this.mUsedPercent;
    }

    public long getWorkerId() {
        return this.mWorkerId;
    }

    public long getBlockCount() {
        return this.mBlockCount;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getRevision() {
        return this.mRevision;
    }

    @Override
    public int compareTo(NodeInfo o) {
        if (o == null) {
            return 1;
        }
        return this.getHost().compareTo(o.getHost());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeInfo)) {
            return false;
        }
        return this.getHost().equals(((NodeInfo)o).getHost());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getHost()});
    }
}

