/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.Capacity;
import alluxio.wire.MountPointInfo;
import alluxio.wire.WorkerInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AlluxioMasterInfo {
    private Capacity mCapacity;
    private Map<String, Object> mConfiguration;
    private List<WorkerInfo> mLostWorkers;
    private Map<String, Long> mMetrics;
    private Map<String, MountPointInfo> mMountPoints;
    private String mRpcAddress;
    private long mStartTimeMs;
    private Map<String, Capacity> mTierCapacity;
    private Capacity mUfsCapacity;
    private long mUptimeMs;
    private String mVersion;
    private List<WorkerInfo> mWorkers;

    public Capacity getCapacity() {
        return this.mCapacity;
    }

    public Map<String, Object> getConfiguration() {
        return this.mConfiguration;
    }

    public List<WorkerInfo> getLostWorkers() {
        return this.mLostWorkers;
    }

    public Map<String, Long> getMetrics() {
        return this.mMetrics;
    }

    public Map<String, MountPointInfo> getMountPoints() {
        return this.mMountPoints;
    }

    public String getRpcAddress() {
        return this.mRpcAddress;
    }

    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    public Map<String, Capacity> getTierCapacity() {
        return this.mTierCapacity;
    }

    public Capacity getUfsCapacity() {
        return this.mUfsCapacity;
    }

    public long getUptimeMs() {
        return this.mUptimeMs;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public List<WorkerInfo> getWorkers() {
        return this.mWorkers;
    }

    public AlluxioMasterInfo setCapacity(Capacity capacity) {
        this.mCapacity = capacity;
        return this;
    }

    public AlluxioMasterInfo setConfiguration(Map<String, Object> configuration) {
        this.mConfiguration = configuration;
        return this;
    }

    public AlluxioMasterInfo setLostWorkers(List<WorkerInfo> lostWorkers) {
        this.mLostWorkers = lostWorkers;
        return this;
    }

    public AlluxioMasterInfo setMetrics(Map<String, Long> metrics) {
        this.mMetrics = metrics;
        return this;
    }

    public AlluxioMasterInfo setMountPoints(Map<String, MountPointInfo> mountPoints) {
        this.mMountPoints = mountPoints;
        return this;
    }

    public AlluxioMasterInfo setRpcAddress(String rpcAddress) {
        this.mRpcAddress = rpcAddress;
        return this;
    }

    public AlluxioMasterInfo setStartTimeMs(long startTimeMs) {
        this.mStartTimeMs = startTimeMs;
        return this;
    }

    public AlluxioMasterInfo setTierCapacity(Map<String, Capacity> tierCapacity) {
        this.mTierCapacity = tierCapacity;
        return this;
    }

    public AlluxioMasterInfo setUfsCapacity(Capacity ufsCapacity) {
        this.mUfsCapacity = ufsCapacity;
        return this;
    }

    public AlluxioMasterInfo setUptimeMs(long uptimeMs) {
        this.mUptimeMs = uptimeMs;
        return this;
    }

    public AlluxioMasterInfo setVersion(String version) {
        this.mVersion = version;
        return this;
    }

    public AlluxioMasterInfo setWorkers(List<WorkerInfo> workers) {
        this.mWorkers = workers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlluxioMasterInfo)) {
            return false;
        }
        AlluxioMasterInfo that = (AlluxioMasterInfo)o;
        return Objects.equal((Object)this.mCapacity, (Object)that.mCapacity) && Objects.equal(this.mConfiguration, that.mConfiguration) && Objects.equal(this.mLostWorkers, that.mLostWorkers) && Objects.equal(this.mMetrics, that.mMetrics) && Objects.equal(this.mMountPoints, that.mMountPoints) && Objects.equal((Object)this.mRpcAddress, (Object)that.mRpcAddress) && this.mStartTimeMs == that.mStartTimeMs && Objects.equal(this.mTierCapacity, that.mTierCapacity) && Objects.equal((Object)this.mUfsCapacity, (Object)that.mUfsCapacity) && this.mUptimeMs == that.mUptimeMs && Objects.equal((Object)this.mVersion, (Object)that.mVersion) && Objects.equal(this.mWorkers, that.mWorkers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mCapacity, this.mConfiguration, this.mLostWorkers, this.mMetrics, this.mMountPoints, this.mRpcAddress, this.mStartTimeMs, this.mTierCapacity, this.mUfsCapacity, this.mUptimeMs, this.mVersion, this.mWorkers});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capacity", (Object)this.mCapacity).add("configuration", this.mConfiguration).add("lost workers", this.mLostWorkers).add("metrics", this.mMetrics).add("mount points", this.mMountPoints).add("rpc address", (Object)this.mRpcAddress).add("start time", this.mStartTimeMs).add("tier capacity", this.mTierCapacity).add("ufs capacity", (Object)this.mUfsCapacity).add("uptime", this.mUptimeMs).add("version", (Object)this.mVersion).add("workers", this.mWorkers).toString();
    }
}

