/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.ConfigStatus;
import alluxio.grpc.InconsistentProperties;
import alluxio.grpc.Scope;
import alluxio.wire.InconsistentProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigCheckReport {
    private final Map<Scope, List<InconsistentProperty>> mConfigErrors;
    private final Map<Scope, List<InconsistentProperty>> mConfigWarns;
    private final ConfigStatus mConfigStatus;

    public ConfigCheckReport() {
        this.mConfigErrors = new HashMap<Scope, List<InconsistentProperty>>();
        this.mConfigWarns = new HashMap<Scope, List<InconsistentProperty>>();
        this.mConfigStatus = ConfigStatus.PASSED;
    }

    public ConfigCheckReport(Map<Scope, List<InconsistentProperty>> errors, Map<Scope, List<InconsistentProperty>> warns, ConfigStatus status) {
        this.mConfigErrors = errors;
        this.mConfigWarns = warns;
        this.mConfigStatus = status;
    }

    public ConfigCheckReport(alluxio.grpc.ConfigCheckReport configCheckReport) {
        this.mConfigErrors = new HashMap<Scope, List<InconsistentProperty>>();
        for (Map.Entry entry : configCheckReport.getErrorsMap().entrySet()) {
            this.mConfigErrors.put(Scope.valueOf((String)((String)entry.getKey())), ((InconsistentProperties)entry.getValue()).getPropertiesList().stream().map(InconsistentProperty::fromProto).collect(Collectors.toList()));
        }
        this.mConfigWarns = new HashMap<Scope, List<InconsistentProperty>>();
        for (Map.Entry entry : configCheckReport.getWarnsMap().entrySet()) {
            this.mConfigWarns.put(Scope.valueOf((String)((String)entry.getKey())), ((InconsistentProperties)entry.getValue()).getPropertiesList().stream().map(InconsistentProperty::fromProto).collect(Collectors.toList()));
        }
        this.mConfigStatus = configCheckReport.getStatus();
    }

    public static ConfigCheckReport fromProto(alluxio.grpc.ConfigCheckReport report) {
        return new ConfigCheckReport(report);
    }

    public Map<Scope, List<InconsistentProperty>> getConfigErrors() {
        return this.mConfigErrors;
    }

    public Map<Scope, List<InconsistentProperty>> getConfigWarns() {
        return this.mConfigWarns;
    }

    public ConfigStatus getConfigStatus() {
        return this.mConfigStatus;
    }

    public alluxio.grpc.ConfigCheckReport toProto() {
        HashMap<String, InconsistentProperties> protoErrors = new HashMap<String, InconsistentProperties>();
        for (Map.Entry<Scope, List<InconsistentProperty>> entry : this.mConfigErrors.entrySet()) {
            protoErrors.put(entry.getKey().name(), InconsistentProperties.newBuilder().addAllProperties((Iterable)entry.getValue().stream().map(InconsistentProperty::toProto).collect(Collectors.toList())).build());
        }
        HashMap<String, InconsistentProperties> protoWarns = new HashMap<String, InconsistentProperties>();
        for (Map.Entry<Scope, List<InconsistentProperty>> entry : this.mConfigWarns.entrySet()) {
            protoWarns.put(entry.getKey().name(), InconsistentProperties.newBuilder().addAllProperties((Iterable)entry.getValue().stream().map(InconsistentProperty::toProto).collect(Collectors.toList())).build());
        }
        return alluxio.grpc.ConfigCheckReport.newBuilder().putAllErrors(protoErrors).putAllWarns(protoWarns).setStatus(this.mConfigStatus).build();
    }
}

