/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.util.CommonUtils;
import alluxio.wire.Address;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MasterInfo {
    private Address mAddress;
    private long mId;
    private long mLastUpdatedTimeMs;

    public MasterInfo() {
    }

    public MasterInfo(long id, Address address, long lastUpdatedTimeMs) {
        this.mAddress = (Address)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.mId = id;
        this.mLastUpdatedTimeMs = lastUpdatedTimeMs;
    }

    public MasterInfo(long id, Address address) {
        this.mAddress = (Address)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.mId = id;
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public Address getAddress() {
        return this.mAddress;
    }

    public long getId() {
        return this.mId;
    }

    public long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public MasterInfo setAddress(Address address) {
        this.mAddress = address;
        return this;
    }

    public MasterInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public MasterInfo setLastUpdatedTimeMs(long lastUpdatedTimeMs) {
        this.mLastUpdatedTimeMs = lastUpdatedTimeMs;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add("address", (Object)this.mAddress).add("lastUpdatedTime", (Object)CommonUtils.convertMsToClockTime(this.mLastUpdatedTimeMs)).toString();
    }

    public void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MasterInfo)) {
            return false;
        }
        MasterInfo that = (MasterInfo)o;
        return this.mId == that.mId && Objects.equal((Object)this.mAddress, (Object)that.mAddress) && this.mLastUpdatedTimeMs == that.mLastUpdatedTimeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mAddress, this.mLastUpdatedTimeMs});
    }
}

