/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BlockReadableChannel
implements ReadableByteChannel {
    private final BlockReader mReader;
    private volatile boolean mClosed = false;

    public BlockReadableChannel(BlockReader reader) {
        this.mReader = (BlockReader)Preconditions.checkNotNull((Object)reader, (Object)"reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.mClosed) {
            throw new ClosedChannelException();
        }
        int maxReadable = dst.remaining();
        int position = dst.position();
        BlockReadableChannel blockReadableChannel = this;
        synchronized (blockReadableChannel) {
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)dst);
            buf.writerIndex(0);
            int bytesRead = this.mReader.transferTo(buf);
            Preconditions.checkState((bytesRead <= maxReadable ? 1 : 0) != 0, (Object)"buffer overflow");
            if (bytesRead > 0) {
                dst.position(position + bytesRead);
            }
            return bytesRead;
        }
    }

    @Override
    public boolean isOpen() {
        return !this.mClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
    }
}

