/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.AxisPolicyLocator;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.XMLUtils;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyUtil {
    public static String getSafeString(String unsafeString) {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = unsafeString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block6;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block6;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block6;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block6;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    public static PolicyReference createPolicyReference(Policy policy) {
        PolicyReference policyReference = new PolicyReference();
        String key = policy.getName();
        if (key == null) {
            key = policy.getId();
            if (key == null) {
                key = UIDGenerator.generateUID();
                policy.setId(key);
            }
            policyReference.setURI("#" + key);
        } else {
            policyReference.setURI(key);
        }
        return policyReference;
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent policyComponent, ExternalPolicySerializer externalPolicySerializer) throws XMLStreamException, FactoryConfigurationError {
        if (policyComponent instanceof Policy) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            externalPolicySerializer.serialize((Policy)policyComponent, baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return (OMElement)XMLUtils.toOM(bais);
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement elem = fac.createOMElement("PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
        elem.addAttribute("URI", ((PolicyReference)policyComponent).getURI(), null);
        return elem;
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent component) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        component.serialize(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (OMElement)XMLUtils.toOM(bais);
    }

    public static PolicyComponent getPolicyComponentFromOMElement(OMElement policyComponent) throws IllegalArgumentException {
        if (Constants.Q_ELEM_POLICY.equals(policyComponent.getQName())) {
            return PolicyEngine.getPolicy((OMElement)policyComponent);
        }
        if (policyComponent.getQName().equals(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) {
            return PolicyEngine.getPolicyReference((OMElement)policyComponent);
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static Policy getPolicyFromOMElement(OMElement policyElement) {
        if (Constants.Q_ELEM_POLICY.equals(policyElement.getQName())) {
            return PolicyEngine.getPolicy((OMElement)policyElement);
        }
        throw new IllegalArgumentException("argument is not a <wsp:Policy ..> element");
    }

    public static PolicyReference getPolicyReferenceFromOMElement(OMElement policyRefElement) {
        if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(policyRefElement.getNamespace().getNamespaceURI()) && "PolicyReference".equals(policyRefElement.getLocalName())) {
            return PolicyEngine.getPolicyReference((OMElement)policyRefElement);
        }
        throw new IllegalArgumentException("argument is not a <wsp:PolicyReference> element");
    }

    public static PolicyComponent getPolicyComponent(Element element) {
        if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI())) {
            if ("Policy".equals(element.getLocalName())) {
                return PolicyEngine.getPolicy((InputStream)PolicyUtil.nodeToStream(element));
            }
            if ("PolicyReference".equals(element.getLocalName())) {
                return PolicyEngine.getPolicyReferene((InputStream)PolicyUtil.nodeToStream(element));
            }
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    private static InputStream nodeToStream(Element element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String nodeString = DOM2Writer.nodeToString((Node)element);
            return new ByteArrayInputStream(nodeString.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to process policy");
        }
    }

    public static String policyComponentToString(PolicyComponent policyComponent) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        policyComponent.serialize(writer);
        writer.flush();
        return baos.toString();
    }

    public static String generateId(AxisDescription description) {
        PolicyInclude policyInclude = description.getPolicyInclude();
        String identifier = "-policy-1";
        if (description instanceof AxisMessage) {
            identifier = "msg-" + ((AxisMessage)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisOperation) {
            identifier = "op-" + ((AxisOperation)description).getName() + identifier;
            description = description.getParent();
        }
        if (description instanceof AxisService) {
            identifier = "service-" + ((AxisService)description).getName() + identifier;
        }
        int index = 49;
        while (policyInclude.getPolicy(identifier) != null) {
            identifier = identifier.replace((char)index, (char)(index + 1));
            ++index;
        }
        return identifier;
    }

    public static Policy getMergedPolicy(List policies, AxisDescription description) {
        Policy policy = null;
        for (Object policyElement : policies) {
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : policy.merge((Policy)policyElement);
                continue;
            }
            PolicyReference policyReference = (PolicyReference)policyElement;
            Policy policy2 = (Policy)policyReference.normalize((PolicyRegistry)new AxisPolicyLocator(description), false);
            policy = policy == null ? policy2 : policy.merge(policy2);
        }
        if (policy != null) {
            policy = (Policy)policy.normalize((PolicyRegistry)new AxisPolicyLocator(description), false);
        }
        return policy;
    }

    public static Policy getMergedPolicy(List policies, AxisService service) {
        Policy policy = null;
        for (Object policyElement : policies) {
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : policy.merge((Policy)policyElement);
                continue;
            }
            PolicyReference policyReference = (PolicyReference)policyElement;
            Policy policy2 = (Policy)policyReference.normalize((PolicyRegistry)new PolicyLocator(service), false);
            policy = policy == null ? policy2 : policy.merge(policy2);
        }
        if (policy != null) {
            policy = (Policy)policy.normalize((PolicyRegistry)new PolicyLocator(service), false);
        }
        return policy;
    }
}

