/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.mongodb.MongoDbIO;

final class AutoValue_MongoDbIO_Write
extends MongoDbIO.Write {
    private final String uri;
    private final boolean keepAlive;
    private final int maxConnectionIdleTime;
    private final String database;
    private final String collection;
    private final long batchSize;

    private AutoValue_MongoDbIO_Write(@Nullable String uri, boolean keepAlive, int maxConnectionIdleTime, @Nullable String database, @Nullable String collection, long batchSize) {
        this.uri = uri;
        this.keepAlive = keepAlive;
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        this.database = database;
        this.collection = collection;
        this.batchSize = batchSize;
    }

    @Override
    @Nullable
    String uri() {
        return this.uri;
    }

    @Override
    boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    int maxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    @Nullable
    String database() {
        return this.database;
    }

    @Override
    @Nullable
    String collection() {
        return this.collection;
    }

    @Override
    long batchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MongoDbIO.Write) {
            MongoDbIO.Write that = (MongoDbIO.Write)((Object)o);
            return (this.uri == null ? that.uri() == null : this.uri.equals(that.uri())) && this.keepAlive == that.keepAlive() && this.maxConnectionIdleTime == that.maxConnectionIdleTime() && (this.database == null ? that.database() == null : this.database.equals(that.database())) && (this.collection == null ? that.collection() == null : this.collection.equals(that.collection())) && this.batchSize == that.batchSize();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.uri == null ? 0 : this.uri.hashCode();
        h *= 1000003;
        h ^= this.keepAlive ? 1231 : 1237;
        h *= 1000003;
        h ^= this.maxConnectionIdleTime;
        h *= 1000003;
        h ^= this.database == null ? 0 : this.database.hashCode();
        h *= 1000003;
        h ^= this.collection == null ? 0 : this.collection.hashCode();
        h *= 1000003;
        return h ^= (int)(this.batchSize >>> 32 ^ this.batchSize);
    }

    @Override
    MongoDbIO.Write.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends MongoDbIO.Write.Builder {
        private String uri;
        private Boolean keepAlive;
        private Integer maxConnectionIdleTime;
        private String database;
        private String collection;
        private Long batchSize;

        Builder() {
        }

        private Builder(MongoDbIO.Write source) {
            this.uri = source.uri();
            this.keepAlive = source.keepAlive();
            this.maxConnectionIdleTime = source.maxConnectionIdleTime();
            this.database = source.database();
            this.collection = source.collection();
            this.batchSize = source.batchSize();
        }

        @Override
        MongoDbIO.Write.Builder setUri(@Nullable String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        MongoDbIO.Write.Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        @Override
        MongoDbIO.Write.Builder setMaxConnectionIdleTime(int maxConnectionIdleTime) {
            this.maxConnectionIdleTime = maxConnectionIdleTime;
            return this;
        }

        @Override
        MongoDbIO.Write.Builder setDatabase(@Nullable String database) {
            this.database = database;
            return this;
        }

        @Override
        MongoDbIO.Write.Builder setCollection(@Nullable String collection) {
            this.collection = collection;
            return this;
        }

        @Override
        MongoDbIO.Write.Builder setBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        MongoDbIO.Write build() {
            String missing = "";
            if (this.keepAlive == null) {
                missing = missing + " keepAlive";
            }
            if (this.maxConnectionIdleTime == null) {
                missing = missing + " maxConnectionIdleTime";
            }
            if (this.batchSize == null) {
                missing = missing + " batchSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MongoDbIO_Write(this.uri, this.keepAlive, this.maxConnectionIdleTime, this.database, this.collection, this.batchSize);
        }
    }
}

