/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.sns.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sns.MessageGroupIdStrategy;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.Sns2Endpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class Sns2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Sns2Producer.class);
    private transient String snsProducerToString;

    public Sns2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        PublishRequest.Builder request = PublishRequest.builder();
        request.topicArn(this.getConfiguration().getTopicArn());
        request.subject(this.determineSubject(exchange));
        request.messageStructure(this.determineMessageStructure(exchange));
        request.message((String)exchange.getIn().getBody(String.class));
        request.messageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.configureFifoAttributes(request, exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PublishResponse result = this.getEndpoint().getSNSClient().publish((PublishRequest)request.build());
        LOG.trace("Received result [{}]", (Object)result);
        Message message = Sns2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSnsMessageId", (Object)result.messageId());
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSnsSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    private String determineMessageStructure(Exchange exchange) {
        String structure = (String)exchange.getIn().getHeader("CamelAwsSnsMessageStructure", String.class);
        if (structure == null) {
            structure = this.getConfiguration().getMessageStructure();
        }
        return structure;
    }

    Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            MessageAttributeValue.Builder mav;
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            Object value = entry.getValue();
            if (value instanceof String && !((String)value).isEmpty()) {
                mav = MessageAttributeValue.builder();
                mav.dataType("String");
                mav.stringValue((String)value);
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof Number) {
                mav = MessageAttributeValue.builder();
                mav.dataType("String");
                mav.stringValue(value.toString());
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof ByteBuffer) {
                mav = MessageAttributeValue.builder();
                mav.dataType("Binary");
                mav.binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)((ByteBuffer)value)));
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof byte[]) {
                mav = MessageAttributeValue.builder();
                mav.dataType("Binary");
                mav.binaryValue(SdkBytes.fromByteArray((byte[])((byte[])value)));
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof Date) {
                mav = MessageAttributeValue.builder();
                mav.dataType("String");
                mav.stringValue(value.toString());
                result.put(entry.getKey(), (MessageAttributeValue)mav.build());
                continue;
            }
            if (value instanceof List) {
                String resultString = ((List)value).stream().map(o -> o instanceof String ? String.format("\"%s\"", o) : Objects.toString(o)).collect(Collectors.joining(", "));
                MessageAttributeValue.Builder mav2 = MessageAttributeValue.builder();
                mav2.dataType("String.Array");
                mav2.stringValue("[" + resultString + "]");
                result.put(entry.getKey(), (MessageAttributeValue)mav2.build());
                continue;
            }
            LOG.warn("Cannot put the message header key={}, value={} into Sns MessageAttribute", (Object)entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void configureFifoAttributes(PublishRequest.Builder request, Exchange exchange) {
        if (this.getEndpoint().getConfiguration().isFifoTopic()) {
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageGroupIdStrategy())) {
                MessageGroupIdStrategy messageGroupIdStrategy = this.getEndpoint().getConfiguration().getMessageGroupIdStrategy();
                String messageGroupId = messageGroupIdStrategy.getMessageGroupId(exchange);
                request.messageGroupId(messageGroupId);
            }
            if (ObjectHelper.isNotEmpty((Object)this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy())) {
                MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = this.getEndpoint().getConfiguration().getMessageDeduplicationIdStrategy();
                String messageDeduplicationId = messageDeduplicationIdStrategy.getMessageDeduplicationId(exchange);
                request.messageDeduplicationId(messageDeduplicationId);
            }
        }
    }

    protected Sns2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.snsProducerToString == null) {
            this.snsProducerToString = "SnsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.snsProducerToString;
    }

    public Sns2Endpoint getEndpoint() {
        return (Sns2Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

