/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IGetPageTyped;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class FhirLoadPage {
    private final IGenericClient client;

    public FhirLoadPage(IGenericClient client) {
        this.client = client;
    }

    public <T extends IBaseBundle> T next(T bundle, Map<ExtraParameters, Object> extraParameters) {
        IGetPageTyped getPageTyped = this.client.loadPage().next(bundle);
        ExtraParameters.process(extraParameters, getPageTyped);
        return (T)((IBaseBundle)getPageTyped.execute());
    }

    public <T extends IBaseBundle> T previous(T bundle, Map<ExtraParameters, Object> extraParameters) {
        IGetPageTyped getPageTyped = this.client.loadPage().previous(bundle);
        ExtraParameters.process(extraParameters, getPageTyped);
        return (T)((IBaseBundle)getPageTyped.execute());
    }

    public <T extends IBaseBundle> T byUrl(String url, Class<T> returnType, Map<ExtraParameters, Object> extraParameters) {
        IGetPageTyped getPageTyped = this.client.loadPage().byUrl(url).andReturnBundle(returnType);
        ExtraParameters.process(extraParameters, getPageTyped);
        return (T)((IBaseBundle)getPageTyped.execute());
    }
}

