/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet.utils.djl;

import ai.djl.modality.Classifications;
import java.util.List;
import net.sf.extjwnl.data.IndexWord;
import net.sf.extjwnl.data.POS;
import net.sf.extjwnl.data.PointerUtils;
import net.sf.extjwnl.data.Synset;
import net.sf.extjwnl.data.Word;
import net.sf.extjwnl.data.list.PointerTargetNodeList;
import net.sf.extjwnl.dictionary.Dictionary;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;

public class ImageNetUtil {
    public void extractClassName(Exchange exchange) {
        Classifications body = (Classifications)exchange.getMessage().getBody(Classifications.class);
        String className = body.best().getClassName().split(",")[0].split(" ", 2)[1];
        exchange.getMessage().setBody((Object)className);
    }

    public void addHypernym(Exchange exchange) throws Exception {
        String className = (String)exchange.getMessage().getBody(String.class);
        Dictionary dic = Dictionary.getDefaultResourceInstance();
        IndexWord word = dic.getIndexWord(POS.NOUN, className);
        if (word == null) {
            throw new RuntimeCamelException("Word not found: " + className);
        }
        PointerTargetNodeList hypernyms = PointerUtils.getDirectHypernyms((Synset)((Synset)word.getSenses().get(0)));
        String hypernym = hypernyms.stream().map(h -> ((Word)h.getSynset().getWords().get(0)).getLemma()).findFirst().orElse(className);
        exchange.getMessage().setBody(List.of(className, hypernym));
    }
}

