/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.util.ExchangeHelper;

public class MustacheEndpoint
extends ResourceEndpoint {
    private MustacheFactory mustacheFactory;
    private Mustache mustache;
    private String encoding;
    private String startDelimiter;
    private String endDelimiter;

    public MustacheEndpoint() {
    }

    public MustacheEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "mustache:" + this.getResourceUri();
    }

    public void clearContentCache() {
        this.mustache = null;
        super.clearContentCache();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String newResourceUri = (String)exchange.getIn().getHeader("MustacheResourceUri", String.class);
        if (newResourceUri == null) {
            Mustache newMustache;
            String newTemplate = (String)exchange.getIn().getHeader("MustacheTemplate", String.class);
            if (newTemplate == null) {
                newMustache = this.getOrCreateMustache();
            } else {
                newMustache = this.createMustache(new StringReader(newTemplate), "mustache:temp#" + newTemplate.hashCode());
                exchange.getIn().removeHeader("MustacheTemplate");
            }
            Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
            StringWriter writer = new StringWriter();
            newMustache.execute((Writer)writer, (Object)variableMap);
            writer.flush();
            Message out = exchange.getOut();
            out.setBody((Object)writer.toString());
            out.setHeaders(exchange.getIn().getHeaders());
            out.setAttachments(exchange.getIn().getAttachments());
        } else {
            exchange.getIn().removeHeader("MustacheResourceUri");
            MustacheEndpoint newEndpoint = (MustacheEndpoint)this.getCamelContext().getEndpoint("mustache:" + newResourceUri, MustacheEndpoint.class);
            newEndpoint.onExchange(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mustache createMustache(Reader resourceReader, String resourceUri) throws IOException {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            Mustache newMustache;
            ClassLoader apcl = this.getCamelContext().getApplicationContextClassLoader();
            if (apcl != null) {
                Thread.currentThread().setContextClassLoader(apcl);
            }
            if (this.startDelimiter != null && this.endDelimiter != null && this.mustacheFactory instanceof DefaultMustacheFactory) {
                DefaultMustacheFactory defaultMustacheFactory = (DefaultMustacheFactory)this.mustacheFactory;
                newMustache = defaultMustacheFactory.compile(resourceReader, resourceUri, this.startDelimiter, this.endDelimiter);
            } else {
                newMustache = this.mustacheFactory.compile(resourceReader, resourceUri);
            }
            Mustache mustache = newMustache;
            return mustache;
        }
        finally {
            resourceReader.close();
            if (oldcl != null) {
                Thread.currentThread().setContextClassLoader(oldcl);
            }
        }
    }

    private Mustache getOrCreateMustache() throws IOException {
        if (this.mustache == null) {
            this.mustache = this.createMustache(this.getResourceAsReader(), this.getResourceUri());
        }
        return this.mustache;
    }

    public String getResourceUri() {
        String uri = super.getResourceUri();
        if (uri != null && (uri.startsWith("/") || uri.startsWith("\\"))) {
            return uri.substring(1);
        }
        return uri;
    }

    public MustacheFactory getMustacheFactory() {
        return this.mustacheFactory;
    }

    public void setMustacheFactory(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private Reader getResourceAsReader() throws IOException {
        return this.encoding == null ? new InputStreamReader(this.getResourceAsInputStream()) : new InputStreamReader(this.getResourceAsInputStream(), this.encoding);
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }
}

