/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.TrustManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rabbitmq.ArgsConfigurer;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.component.rabbitmq.RabbitMQConnectionFactorySupport;
import org.apache.camel.component.rabbitmq.RabbitMQConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQDeclareSupport;
import org.apache.camel.component.rabbitmq.RabbitMQMessageConverter;
import org.apache.camel.component.rabbitmq.RabbitMQMessagePublisher;
import org.apache.camel.component.rabbitmq.RabbitMQProducer;
import org.apache.camel.component.rabbitmq.ReplyToType;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="rabbitmq", title="RabbitMQ", syntax="rabbitmq:hostname:portNumber/exchangeName", consumerClass=RabbitMQConsumer.class, label="messaging")
public class RabbitMQEndpoint
extends DefaultEndpoint {
    public static final String SERIALIZE_HEADER = "CamelSerialize";
    @UriPath
    @Metadata(required="true")
    private String hostname;
    @UriPath(defaultValue="5672")
    @Metadata(required="true")
    private int portNumber;
    @UriPath
    @Metadata(required="true")
    private String exchangeName;
    @UriParam(defaultValue="guest")
    private String username = "guest";
    @UriParam(defaultValue="guest")
    private String password = "guest";
    @UriParam(defaultValue="/")
    private String vhost = "/";
    @UriParam(label="consumer", defaultValue="10")
    private int threadPoolSize = 10;
    @UriParam(label="consumer", defaultValue="true")
    private boolean autoAck = true;
    @UriParam(defaultValue="true")
    private boolean autoDelete = true;
    @UriParam(defaultValue="true")
    private boolean durable = true;
    @UriParam(label="producer")
    private boolean bridgeEndpoint;
    @UriParam
    private String queue = String.valueOf(UUID.randomUUID().toString().hashCode());
    @UriParam(defaultValue="direct", enums="direct,fanout,headers,topic")
    private String exchangeType = "direct";
    @UriParam
    private String routingKey;
    @UriParam(label="producer")
    private boolean skipQueueDeclare;
    @UriParam
    private boolean skipExchangeDeclare;
    @UriParam
    private Address[] addresses;
    @UriParam(defaultValue="60000")
    private int connectionTimeout = 60000;
    @UriParam(defaultValue="0")
    private int requestedChannelMax = 0;
    @UriParam(defaultValue="0")
    private int requestedFrameMax = 0;
    @UriParam(defaultValue="60")
    private int requestedHeartbeat = 60;
    @UriParam
    private String sslProtocol;
    @UriParam
    private TrustManager trustManager;
    @UriParam
    private Map<String, Object> clientProperties;
    @UriParam
    private ConnectionFactory connectionFactory;
    @UriParam
    private Boolean automaticRecoveryEnabled;
    @UriParam
    private Integer networkRecoveryInterval;
    @UriParam
    private Boolean topologyRecoveryEnabled;
    @UriParam(label="consumer")
    private boolean prefetchEnabled;
    @UriParam(label="consumer")
    private int prefetchSize;
    @UriParam(label="consumer")
    private int prefetchCount;
    @UriParam(label="consumer")
    private boolean prefetchGlobal;
    @UriParam(label="consumer", defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="true")
    private boolean declare = true;
    @UriParam
    private String deadLetterExchange;
    @UriParam
    private String deadLetterRoutingKey;
    @UriParam
    private String deadLetterQueue;
    @UriParam(defaultValue="direct", enums="direct,fanout,headers,topic")
    private String deadLetterExchangeType = "direct";
    @UriParam(label="producer", defaultValue="10")
    private int channelPoolMaxSize = 10;
    @UriParam(label="producer", defaultValue="1000")
    private long channelPoolMaxWait = 1000L;
    @UriParam(label="producer")
    private boolean mandatory;
    @UriParam(label="producer")
    private boolean immediate;
    @UriParam
    private ArgsConfigurer queueArgsConfigurer;
    @UriParam
    private ArgsConfigurer exchangeArgsConfigurer;
    @UriParam
    private long requestTimeout = 20000L;
    @UriParam
    private long requestTimeoutCheckerInterval = 1000L;
    @UriParam
    private boolean transferException;
    @UriParam(label="producer")
    private boolean publisherAcknowledgements;
    @UriParam(label="producer")
    private long publisherAcknowledgementsTimeout;
    private boolean useMessageIDAsCorrelationID = true;
    private String replyToType = ReplyToType.Temporary.name();
    private String replyTo;
    private final RabbitMQMessageConverter messageConverter = new RabbitMQMessageConverter();
    private final RabbitMQConnectionFactorySupport factoryCreator = new RabbitMQConnectionFactorySupport();
    private final RabbitMQDeclareSupport declareSupport = new RabbitMQDeclareSupport(this);

    public RabbitMQEndpoint() {
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component, ConnectionFactory connectionFactory) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.connectionFactory = connectionFactory;
    }

    public Exchange createRabbitExchange(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        Exchange exchange = super.createExchange();
        this.messageConverter.populateRabbitExchange(exchange, envelope, properties, body, false);
        return exchange;
    }

    protected RabbitMQMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void publishExchangeToChannel(Exchange camelExchange, Channel channel, String routingKey) throws IOException {
        new RabbitMQMessagePublisher(camelExchange, channel, routingKey, this).publish();
    }

    protected String getExchangeName(Message msg) {
        String exchangeName = (String)msg.getHeader("rabbitmq.EXCHANGE_NAME", String.class);
        if (exchangeName == null || this.isBridgeEndpoint()) {
            exchangeName = this.getExchangeName();
        }
        return exchangeName;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RabbitMQConsumer consumer = new RabbitMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Connection connect(ExecutorService executor) throws IOException, TimeoutException {
        if (this.getAddresses() == null) {
            return this.getOrCreateConnectionFactory().newConnection(executor);
        }
        return this.getOrCreateConnectionFactory().newConnection(executor, this.getAddresses());
    }

    public void declareExchangeAndQueue(Channel channel) throws IOException {
        this.declareSupport.declareAndBindExchangesAndQueuesUsing(channel);
    }

    private ConnectionFactory getOrCreateConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.factoryCreator.createFactoryFor(this);
        }
        return this.connectionFactory;
    }

    public Producer createProducer() throws Exception {
        return new RabbitMQProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected ExecutorService createExecutor() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "RabbitMQConsumer", this.getThreadPoolSize());
        }
        return Executors.newFixedThreadPool(this.getThreadPoolSize());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setSkipQueueDeclare(boolean skipQueueDeclare) {
        this.skipQueueDeclare = skipQueueDeclare;
    }

    public boolean isSkipQueueDeclare() {
        return this.skipQueueDeclare;
    }

    public void setSkipExchangeDeclare(boolean skipExchangeDeclare) {
        this.skipExchangeDeclare = skipExchangeDeclare;
    }

    public boolean isSkipExchangeDeclare() {
        return this.skipExchangeDeclare;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setAddresses(String addresses) {
        Address[] addressArray = Address.parseAddresses((String)addresses);
        if (addressArray.length > 0) {
            this.addresses = addressArray;
        }
    }

    public Address[] getAddresses() {
        return this.addresses;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public Boolean getAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public void setAutomaticRecoveryEnabled(Boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public Boolean getTopologyRecoveryEnabled() {
        return this.topologyRecoveryEnabled;
    }

    public void setTopologyRecoveryEnabled(Boolean topologyRecoveryEnabled) {
        this.topologyRecoveryEnabled = topologyRecoveryEnabled;
    }

    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchGlobal(boolean prefetchGlobal) {
        this.prefetchGlobal = prefetchGlobal;
    }

    public boolean isPrefetchGlobal() {
        return this.prefetchGlobal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public boolean isDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean declare) {
        this.declare = declare;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public int getChannelPoolMaxSize() {
        return this.channelPoolMaxSize;
    }

    public void setChannelPoolMaxSize(int channelPoolMaxSize) {
        this.channelPoolMaxSize = channelPoolMaxSize;
    }

    public long getChannelPoolMaxWait() {
        return this.channelPoolMaxWait;
    }

    public void setChannelPoolMaxWait(long channelPoolMaxWait) {
        this.channelPoolMaxWait = channelPoolMaxWait;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public ArgsConfigurer getQueueArgsConfigurer() {
        return this.queueArgsConfigurer;
    }

    public void setQueueArgsConfigurer(ArgsConfigurer queueArgsConfigurer) {
        this.queueArgsConfigurer = queueArgsConfigurer;
    }

    public ArgsConfigurer getExchangeArgsConfigurer() {
        return this.exchangeArgsConfigurer;
    }

    public void setExchangeArgsConfigurer(ArgsConfigurer exchangeArgsConfigurer) {
        this.exchangeArgsConfigurer = exchangeArgsConfigurer;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.useMessageIDAsCorrelationID;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public boolean isPublisherAcknowledgements() {
        return this.publisherAcknowledgements;
    }

    public void setPublisherAcknowledgements(boolean publisherAcknowledgements) {
        this.publisherAcknowledgements = publisherAcknowledgements;
    }

    public long getPublisherAcknowledgementsTimeout() {
        return this.publisherAcknowledgementsTimeout;
    }

    public void setPublisherAcknowledgementsTimeout(long publisherAcknowledgementsTimeout) {
        this.publisherAcknowledgementsTimeout = publisherAcknowledgementsTimeout;
    }

    public String getReplyToType() {
        return this.replyToType;
    }

    public String getReplyTo() {
        return this.replyTo;
    }
}

