/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQComponent.class);

    public RabbitMQComponent() {
        super(RabbitMQEndpoint.class);
    }

    public RabbitMQComponent(CamelContext context) {
        super(context, RabbitMQEndpoint.class);
    }

    protected RabbitMQEndpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        URI host = new URI("http://" + remaining);
        String hostname = host.getHost();
        int portNumber = host.getPort();
        String exchangeName = "";
        if (host.getPath().trim().length() > 1) {
            exchangeName = host.getPath().substring(1);
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(params, "connectionFactory", ConnectionFactory.class);
        Map clientProperties = (Map)this.resolveAndRemoveReferenceParameter(params, "clientProperties", Map.class);
        TrustManager trustManager = (TrustManager)this.resolveAndRemoveReferenceParameter(params, "trustManager", TrustManager.class);
        RabbitMQEndpoint endpoint = connectionFactory == null ? new RabbitMQEndpoint(uri, this) : new RabbitMQEndpoint(uri, this, connectionFactory);
        endpoint.setHostname(hostname);
        endpoint.setPortNumber(portNumber);
        endpoint.setExchangeName(exchangeName);
        endpoint.setClientProperties(clientProperties);
        endpoint.setTrustManager(trustManager);
        this.setProperties((Object)endpoint, params);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RabbitMQEndpoint with host {}:{} and exchangeName: {}", new Object[]{endpoint.getHostname(), endpoint.getPortNumber(), endpoint.getExchangeName()});
        }
        return endpoint;
    }
}

