/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessageConverter {
    protected static final Logger LOG = LoggerFactory.getLogger(RabbitMQMessageConverter.class);

    public void mergeAmqpProperties(Exchange exchange, AMQP.BasicProperties properties) {
        if (properties.getType() != null) {
            exchange.getIn().setHeader("rabbitmq.TYPE", (Object)properties.getType());
        }
        if (properties.getAppId() != null) {
            exchange.getIn().setHeader("rabbitmq.APP_ID", (Object)properties.getAppId());
        }
        if (properties.getClusterId() != null) {
            exchange.getIn().setHeader("rabbitmq.CLUSTERID", (Object)properties.getClusterId());
        }
        if (properties.getContentEncoding() != null) {
            exchange.getIn().setHeader("rabbitmq.CONTENT_ENCODING", (Object)properties.getContentEncoding());
        }
        if (properties.getContentType() != null) {
            exchange.getIn().setHeader("rabbitmq.CONTENT_TYPE", (Object)properties.getContentType());
        }
        if (properties.getCorrelationId() != null) {
            exchange.getIn().setHeader("rabbitmq.CORRELATIONID", (Object)properties.getCorrelationId());
        }
        if (properties.getExpiration() != null) {
            exchange.getIn().setHeader("rabbitmq.EXPIRATION", (Object)properties.getExpiration());
        }
        if (properties.getMessageId() != null) {
            exchange.getIn().setHeader("rabbitmq.MESSAGE_ID", (Object)properties.getMessageId());
        }
        if (properties.getPriority() != null) {
            exchange.getIn().setHeader("rabbitmq.PRIORITY", (Object)properties.getPriority());
        }
        if (properties.getReplyTo() != null) {
            exchange.getIn().setHeader("rabbitmq.REPLY_TO", (Object)properties.getReplyTo());
        }
        if (properties.getTimestamp() != null) {
            exchange.getIn().setHeader("rabbitmq.TIMESTAMP", (Object)properties.getTimestamp());
        }
        if (properties.getUserId() != null) {
            exchange.getIn().setHeader("rabbitmq.USERID", (Object)properties.getUserId());
        }
    }

    public AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        Object contentType = msg.removeHeader("rabbitmq.CONTENT_TYPE");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = msg.removeHeader("rabbitmq.PRIORITY")) != null) {
            properties.priority(Integer.valueOf(Integer.parseInt(priority.toString())));
        }
        if ((messageId = msg.removeHeader("rabbitmq.MESSAGE_ID")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = msg.removeHeader("rabbitmq.CLUSTERID")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = msg.removeHeader("rabbitmq.REPLY_TO")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = msg.removeHeader("rabbitmq.CORRELATIONID")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = msg.removeHeader("rabbitmq.DELIVERY_MODE")) != null) {
            properties.deliveryMode(Integer.valueOf(Integer.parseInt(deliveryMode.toString())));
        }
        if ((userId = msg.removeHeader("rabbitmq.USERID")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = msg.removeHeader("rabbitmq.TYPE")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = msg.removeHeader("rabbitmq.CONTENT_ENCODING")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = msg.removeHeader("rabbitmq.EXPIRATION")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = msg.removeHeader("rabbitmq.APP_ID")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = msg.removeHeader("rabbitmq.TIMESTAMP")) != null) {
            properties.timestamp(this.convertTimestamp(timestamp));
        }
        Map headers = msg.getHeaders();
        HashMap filteredHeaders = new HashMap();
        for (Map.Entry header : headers.entrySet()) {
            Object value = this.getValidRabbitMQHeaderValue(header.getValue());
            if (value != null) {
                filteredHeaders.put(header.getKey(), header.getValue());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            if (header.getValue() == null) {
                LOG.debug("Ignoring header: {} with null value", header.getKey());
                continue;
            }
            LOG.debug("Ignoring header: {} of class: {} with value: {}", new Object[]{header.getKey(), ObjectHelper.classCanonicalName(header.getValue()), header.getValue()});
        }
        properties.headers(filteredHeaders);
        return properties;
    }

    private Date convertTimestamp(Object timestamp) {
        if (timestamp instanceof Date) {
            return (Date)timestamp;
        }
        return new Date(Long.parseLong(timestamp.toString()));
    }

    private Object getValidRabbitMQHeaderValue(Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (headerValue instanceof byte[]) {
            return headerValue;
        }
        if (headerValue instanceof LongString) {
            return headerValue;
        }
        return null;
    }

    public void populateRabbitExchange(Exchange camelExchange, Envelope envelope, AMQP.BasicProperties properties, byte[] body, boolean out) {
        Message message = this.resolveMessageFrom(camelExchange, out);
        this.populateMessageHeaders(message, envelope, properties);
        this.populateMessageBody(message, camelExchange, properties, body);
    }

    private Message resolveMessageFrom(Exchange camelExchange, boolean out) {
        Message message;
        if (out) {
            message = camelExchange.getOut();
        } else if (camelExchange.getIn() != null) {
            message = camelExchange.getIn();
        } else {
            message = new DefaultMessage();
            camelExchange.setIn(message);
        }
        return message;
    }

    private void populateMessageHeaders(Message message, Envelope envelope, AMQP.BasicProperties properties) {
        this.populateRoutingInfoHeaders(message, envelope);
        this.populateMessageHeadersFromRabbitMQHeaders(message, properties);
    }

    private void populateRoutingInfoHeaders(Message message, Envelope envelope) {
        if (envelope != null) {
            message.setHeader("rabbitmq.ROUTING_KEY", (Object)envelope.getRoutingKey());
            message.setHeader("rabbitmq.EXCHANGE_NAME", (Object)envelope.getExchange());
            message.setHeader("rabbitmq.DELIVERY_TAG", (Object)envelope.getDeliveryTag());
        }
    }

    private void populateMessageHeadersFromRabbitMQHeaders(Message message, AMQP.BasicProperties properties) {
        Map headers = properties.getHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (entry.getValue() instanceof LongString) {
                    message.setHeader((String)entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                message.setHeader((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void populateMessageBody(Message message, Exchange camelExchange, AMQP.BasicProperties properties, byte[] body) {
        if (this.hasSerializeHeader(properties)) {
            this.deserializeBody(camelExchange, message, body);
        } else {
            message.setBody((Object)body);
        }
    }

    private void deserializeBody(Exchange camelExchange, Message message, byte[] body) {
        Object messageBody = null;
        try (ByteArrayInputStream b = new ByteArrayInputStream(body);
             ObjectInputStream o = new ObjectInputStream(b);){
            messageBody = o.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warn("Could not deserialize the object");
            camelExchange.setException((Throwable)e);
        }
        if (messageBody instanceof Throwable) {
            LOG.debug("Reply was an Exception. Setting the Exception on the Exchange");
            camelExchange.setException((Throwable)messageBody);
        } else {
            message.setBody(messageBody);
        }
    }

    private boolean hasSerializeHeader(AMQP.BasicProperties properties) {
        return this.hasHeaders(properties) && Boolean.TRUE.equals(this.isSerializeHeaderEnabled(properties));
    }

    private boolean hasHeaders(AMQP.BasicProperties properties) {
        return properties != null && properties.getHeaders() != null;
    }

    private Object isSerializeHeaderEnabled(AMQP.BasicProperties properties) {
        return properties.getHeaders().get("CamelSerialize");
    }
}

