/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import com.rabbitmq.client.Connection;
import java.util.UUID;
import org.apache.camel.component.rabbitmq.reply.MessageSentCallback;
import org.apache.camel.component.rabbitmq.reply.ReplyManager;

public class UseMessageIdAsCorrelationIdMessageSentCallback
implements MessageSentCallback {
    private ReplyManager replyManager;
    private String correlationId;
    private long requestTimeout;

    public UseMessageIdAsCorrelationIdMessageSentCallback(ReplyManager replyManager, String correlationId, long requestTimeout) {
        this.replyManager = replyManager;
        this.correlationId = correlationId;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void sent(Connection session, byte[] message, String destination) {
        String newCorrelationID = UUID.randomUUID().toString();
        if (newCorrelationID != null) {
            this.replyManager.updateCorrelationId(this.correlationId, newCorrelationID, this.requestTimeout);
        }
    }
}

